/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.TaskErrorReporter;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ReportErrorPage;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryFilter;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewTaskPage;

public class ReportErrorWizard
extends Wizard {
    private final IStatus status;
    private final AttributeTaskMapper mapper;
    private ReportErrorPage reportErrorPage;
    private NewTaskPage newTaskPage;
    private final TaskErrorReporter taskErrorReporter;

    public ReportErrorWizard(TaskErrorReporter taskErrorReporter, IStatus status) {
        this.taskErrorReporter = taskErrorReporter;
        this.status = status;
        this.mapper = taskErrorReporter.preProcess(status);
        this.setWindowTitle("Report as Bug");
    }

    public void addPages() {
        this.reportErrorPage = new ReportErrorPage(this.mapper, this.status);
        this.addPage((IWizardPage)this.reportErrorPage);
        this.newTaskPage = new NewTaskPage(ITaskRepositoryFilter.CAN_CREATE_NEW_TASK, this.mapper.getTaskMapping());
        this.addPage((IWizardPage)this.newTaskPage);
    }

    public boolean performFinish() {
        if (this.reportErrorPage.getTaskRepository() != null) {
            this.taskErrorReporter.postProcess(this.mapper);
            return true;
        }
        return this.newTaskPage.performFinish();
    }
}

