/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.commons.net.WebClientLog;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.provisional.commons.ui.AbstractNotification;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.tasks.core.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryModelListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskDataStorage;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.RepositoryExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskDataStorageManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.ui.ActivityExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.ITaskHighlighter;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.OfflineCachingStorage;
import org.eclipse.mylyn.internal.tasks.ui.OfflineFileStorage;
import org.eclipse.mylyn.internal.tasks.ui.TaskActivityMonitor;
import org.eclipse.mylyn.internal.tasks.ui.TaskEditorBloatMonitor;
import org.eclipse.mylyn.internal.tasks.ui.TaskJobFactory;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListNotificationManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListSynchronizationScheduler;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryUtil;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractTaskEditorFactory;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationReminder;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotifier;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskListElementImporter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.mylyn.tasks.core.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksUiPlugin
extends AbstractUIPlugin {
    private static final int DELAY_QUERY_REFRESH_ON_STARTUP = 20000;
    private static final int LINK_PROVIDER_TIMEOUT_SECONDS = 5;
    public static final String LABEL_VIEW_REPOSITORIES = "Task Repositories";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.tasks.ui";
    private static final String FOLDER_OFFLINE = "offline";
    private static final String DIRECTORY_METADATA = ".metadata";
    private static final String NAME_DATA_DIR = ".mylyn";
    private static final char DEFAULT_PATH_SEPARATOR = '/';
    private static final int NOTIFICATION_DELAY = 5000;
    private static TasksUiPlugin INSTANCE;
    private static ExternalizationManager externalizationManager;
    private static TaskListManager taskListManager;
    private static TaskActivityManager taskActivityManager;
    private static TaskRepositoryManager repositoryManager;
    private static TaskListSynchronizationScheduler synchronizationScheduler;
    private static TaskDataManager taskDataManager;
    private static Map<String, AbstractRepositoryConnectorUi> repositoryConnectorUiMap;
    private TaskListNotificationManager taskListNotificationManager;
    private TaskListBackupManager taskListBackupManager;
    private TaskDataStorageManager taskDataStorageManager;
    private RepositoryTemplateManager repositoryTemplateManager;
    @Deprecated
    private final Set<AbstractTaskEditorFactory> taskEditorFactories = new HashSet<AbstractTaskEditorFactory>();
    private final Set<AbstractTaskEditorPageFactory> taskEditorPageFactories = new HashSet<AbstractTaskEditorPageFactory>();
    private final TreeSet<AbstractTaskRepositoryLinkProvider> repositoryLinkProviders = new TreeSet<AbstractTaskRepositoryLinkProvider>(new OrderComparator());
    private TaskListExternalizer taskListExternalizer;
    private ITaskHighlighter highlighter;
    private final Map<String, Image> brandingIcons = new HashMap<String, Image>();
    private final Map<String, ImageDescriptor> overlayIcons = new HashMap<String, ImageDescriptor>();
    private final Set<AbstractDuplicateDetector> duplicateDetectors = new HashSet<AbstractDuplicateDetector>();
    private ISaveParticipant saveParticipant;
    private TaskEditorBloatMonitor taskEditorBloatManager;
    private TaskJobFactory taskJobFactory;
    private FormColors formColors;
    private final List<AbstractSearchHandler> searchHandlers = new ArrayList<AbstractSearchHandler>();
    private static final boolean DEBUG_HTTPCLIENT;
    private static ITaskActivationListener CONTEXT_TASK_ACTIVATION_LISTENER;
    private static ITaskListNotificationProvider REMINDER_NOTIFICATION_PROVIDER;
    private final IPropertyChangeListener PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.data.dir") && event.getOldValue() instanceof String) {
                try {
                    TasksUiPlugin.this.setDataDirectory((String)event.getNewValue(), (IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Unable to load from task data folder", (Throwable)e));
                }
            }
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.planning.end.hour") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.planning.week.start.day")) {
                TasksUiPlugin.this.updateTaskActivityManager();
            }
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds")) {
                TasksUiPlugin.this.updateSynchronizationScheduler(false);
            }
        }
    };
    private TaskActivityMonitor taskActivityMonitor;
    private ServiceReference proxyServiceReference;
    private IProxyChangeListener proxyChangeListener;
    private TaskListExternalizationParticipant taskListSaveParticipant;
    private final Set<IRepositoryModelListener> listeners = new HashSet<IRepositoryModelListener>();
    private boolean settingDataDirectory = false;
    private static TaskList taskList;
    private static RepositoryModel repositoryModel;
    private final Map<String, List<IDynamicSubMenuContributor>> menuContributors = new HashMap<String, List<IDynamicSubMenuContributor>>();

    static {
        repositoryConnectorUiMap = new HashMap<String, AbstractRepositoryConnectorUi>();
        DEBUG_HTTPCLIENT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.mylyn.tasks.ui/debug/httpclient"));
        CONTEXT_TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

            public void taskActivated(ITask task) {
                ContextCore.getContextManager().activateContext(task.getHandleIdentifier());
            }

            public void taskDeactivated(ITask task) {
                ContextCore.getContextManager().deactivateContext(task.getHandleIdentifier());
            }
        };
        REMINDER_NOTIFICATION_PROVIDER = new ITaskListNotificationProvider(){

            @Override
            public Set<AbstractNotification> getNotifications() {
                Collection allTasks = TasksUiPlugin.getTaskList().getAllTasks();
                HashSet<AbstractNotification> reminders = new HashSet<AbstractNotification>();
                for (AbstractTask task : allTasks) {
                    if (!TasksUiPlugin.getTaskActivityManager().isPastReminder(task) || task.isReminded()) continue;
                    reminders.add(new TaskListNotificationReminder(task));
                    task.setReminded(true);
                }
                return reminders;
            }
        };
    }

    public TasksUiPlugin() {
        INSTANCE = this;
    }

    private void updateSynchronizationScheduler(boolean initial) {
        boolean enabled = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule");
        if (enabled) {
            long interval = TasksUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
            if (initial) {
                synchronizationScheduler.setInterval(20000L, interval);
            } else {
                synchronizationScheduler.setInterval(interval);
            }
        } else {
            synchronizationScheduler.setInterval(0L);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            IProxyService proxyService;
            WebUtil.init();
            WebClientLog.setLoggingEnabled((boolean)DEBUG_HTTPCLIENT);
            this.initializePreferences(this.getPreferenceStore());
            File dataDir = new File(this.getDataDirectory());
            dataDir.mkdirs();
            externalizationManager = new ExternalizationManager(this.getDataDirectory());
            repositoryManager = new TaskRepositoryManager();
            RepositoryExternalizationParticipant repositoryParticipant = new RepositoryExternalizationParticipant(externalizationManager, repositoryManager);
            externalizationManager.addParticipant((IExternalizationParticipant)repositoryParticipant);
            taskList = new TaskList();
            repositoryModel = new RepositoryModel(taskList, (IRepositoryManager)repositoryManager);
            this.taskListExternalizer = new TaskListExternalizer(repositoryModel, (IRepositoryManager)repositoryManager);
            TaskListElementImporter taskListImporter = new TaskListElementImporter(repositoryManager, repositoryModel);
            this.taskListSaveParticipant = new TaskListExternalizationParticipant(repositoryModel, taskList, this.taskListExternalizer, externalizationManager, repositoryManager);
            externalizationManager.addParticipant((IExternalizationParticipant)this.taskListSaveParticipant);
            taskList.addChangeListener((ITaskListChangeListener)this.taskListSaveParticipant);
            taskActivityManager = new TaskActivityManager(repositoryManager, taskList);
            taskActivityManager.addActivationListener((ITaskActivationListener)this.taskListSaveParticipant);
            taskListManager = new TaskListManager(taskList, this.taskListSaveParticipant, taskListImporter);
            this.updateTaskActivityManager();
            this.proxyServiceReference = context.getServiceReference(IProxyService.class.getName());
            if (this.proxyServiceReference != null && (proxyService = (IProxyService)context.getService(this.proxyServiceReference)) != null) {
                this.proxyChangeListener = new IProxyChangeListener(){

                    public void proxyInfoChanged(IProxyChangeEvent event) {
                        List repos = repositoryManager.getAllRepositories();
                        for (TaskRepository repo : repos) {
                            if (!repo.isDefaultProxyEnabled()) continue;
                            repositoryManager.notifyRepositorySettingsChanged(repo);
                        }
                    }
                };
                proxyService.addProxyChangeListener(this.proxyChangeListener);
            }
            this.repositoryTemplateManager = new RepositoryTemplateManager();
            TasksUiExtensionReader.initStartupExtensions(this.taskListExternalizer, taskListImporter);
            File root = new File(String.valueOf(this.getDataDirectory()) + '/' + FOLDER_OFFLINE);
            OfflineFileStorage storage = new OfflineFileStorage(root);
            OfflineCachingStorage cachedStorage = new OfflineCachingStorage(storage);
            this.taskDataStorageManager = new TaskDataStorageManager((IRepositoryManager)repositoryManager, (ITaskDataStorage)cachedStorage);
            this.taskDataStorageManager.start();
            TaskDataStore taskDataStore = new TaskDataStore((IRepositoryManager)repositoryManager);
            taskDataManager = new TaskDataManager(this.taskDataStorageManager, taskDataStore, (IRepositoryManager)repositoryManager, taskListManager.getTaskList(), taskActivityManager);
            taskDataManager.setDataPath(this.getDataDirectory());
            for (AbstractRepositoryConnector connector : repositoryManager.getRepositoryConnectors()) {
                if (!(connector instanceof AbstractLegacyRepositoryConnector)) continue;
                ((AbstractLegacyRepositoryConnector)connector).init((ITaskDataManager)taskDataManager);
            }
            this.taskJobFactory = new TaskJobFactory(taskListManager.getTaskList(), taskDataManager, (IRepositoryManager)repositoryManager, (IRepositoryModel)repositoryModel);
            taskActivityManager.addActivationListener(CONTEXT_TASK_ACTIVATION_LISTENER);
            this.taskActivityMonitor = new TaskActivityMonitor(taskActivityManager, ContextCorePlugin.getContextManager());
            this.taskActivityMonitor.start();
            this.saveParticipant = new ISaveParticipant(){

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) throws CoreException {
                }

                public void rollback(ISaveContext context) {
                }

                public void saving(ISaveContext context) throws CoreException {
                    if (context.getKind() == 1) {
                        externalizationManager.stop();
                        TasksUiPlugin.this.taskDataStorageManager.stop();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, this.saveParticipant);
            ActivityExternalizationParticipant ACTIVITY_EXTERNALIZTAION_PARTICIPANT = new ActivityExternalizationParticipant(externalizationManager);
            externalizationManager.addParticipant((IExternalizationParticipant)ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
            taskActivityManager.addActivityListener((ITaskActivityListener)ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
            this.taskActivityMonitor.setExternalizationParticipant(ACTIVITY_EXTERNALIZTAION_PARTICIPANT);
            this.loadDataSources();
            new TasksUiInitializationJob().schedule();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Task list initialization failed", (Throwable)e));
        }
    }

    private void updateTaskActivityManager() {
        int endHour = this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour");
        TaskActivityUtil.setEndHour((int)endHour);
        int newWeekStartDay = this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day");
        int oldWeekStartDay = taskActivityManager.getWeekStartDay();
        if (oldWeekStartDay != newWeekStartDay) {
            taskActivityManager.setWeekStartDay(newWeekStartDay);
        }
    }

    private void loadTemplateRepositories() {
        TaskRepository localRepository = this.getLocalTaskRepository();
        localRepository.setRepositoryLabel("Local");
        for (AbstractRepositoryConnector connector : repositoryManager.getRepositoryConnectors()) {
            for (RepositoryTemplate template : this.repositoryTemplateManager.getTemplates(connector.getConnectorKind())) {
                if (!template.addAutomatically || TaskRepositoryUtil.isAddAutomaticallyDisabled(template.repositoryUrl)) continue;
                try {
                    TaskRepository taskRepository = repositoryManager.getRepository(connector.getConnectorKind(), template.repositoryUrl);
                    if (taskRepository != null) continue;
                    taskRepository = new TaskRepository(connector.getConnectorKind(), template.repositoryUrl);
                    taskRepository.setVersion(template.version);
                    taskRepository.setRepositoryLabel(template.label);
                    taskRepository.setCharacterEncoding(template.characterEncoding);
                    if (template.anonymous) {
                        taskRepository.setCredentials(AuthenticationType.REPOSITORY, null, true);
                    }
                    repositoryManager.addRepository(taskRepository);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not load repository template", t));
                }
            }
        }
    }

    public TaskRepository getLocalTaskRepository() {
        TaskRepository localRepository = repositoryManager.getRepository("local", "local");
        if (localRepository == null) {
            localRepository = new TaskRepository("local", "local");
            localRepository.setVersion("1");
            localRepository.setRepositoryLabel("Local");
            repositoryManager.addRepository(localRepository);
        }
        return localRepository;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            try {
                if (this.formColors != null) {
                    this.formColors.dispose();
                    this.formColors = null;
                }
                if (this.taskActivityMonitor != null) {
                    this.taskActivityMonitor.stop();
                }
                if (ResourcesPlugin.getWorkspace() != null) {
                    ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
                }
                if (this.proxyServiceReference != null) {
                    IProxyService proxyService = (IProxyService)context.getService(this.proxyServiceReference);
                    if (proxyService != null) {
                        proxyService.removeProxyChangeListener(this.proxyChangeListener);
                    }
                    context.ungetService(this.proxyServiceReference);
                }
                if (PlatformUI.isWorkbenchRunning()) {
                    this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.taskListNotificationManager);
                    this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.taskListBackupManager);
                    this.getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
                    CommonColors.dispose();
                    this.taskEditorBloatManager.dispose(PlatformUI.getWorkbench());
                    INSTANCE = null;
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Task list stop terminated abnormally", (Throwable)e));
                super.stop(context);
            }
        }
        finally {
            super.stop(context);
        }
    }

    public String getDefaultDataDirectory() {
        return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + '/' + DIRECTORY_METADATA + '/' + NAME_DATA_DIR;
    }

    public String getDataDirectory() {
        return this.getPreferenceStore().getString("org.eclipse.mylyn.data.dir");
    }

    public void setDataDirectory(String newPath, IProgressMonitor monitor) throws CoreException {
        this.setDataDirectory(newPath, monitor, true);
    }

    private void setDataDirectory(String newPath, IProgressMonitor monitor, boolean setPreference) throws CoreException {
        if (this.settingDataDirectory) {
            return;
        }
        try {
            File newFile;
            this.settingDataDirectory = true;
            this.loadDataDirectory(newPath, !setPreference);
            if (setPreference) {
                this.getPreferenceStore().setValue("org.eclipse.mylyn.data.dir", newPath);
            }
            if (!(newFile = new File(newPath, "contexts")).exists()) {
                newFile.mkdirs();
            }
            ContextCorePlugin.getContextStore().setContextDirectory(newFile);
        }
        finally {
            this.settingDataDirectory = false;
        }
    }

    public void reloadDataDirectory() throws CoreException {
        this.loadDataDirectory(this.getDataDirectory(), false);
    }

    private synchronized void loadDataDirectory(final String newPath, final boolean save) throws CoreException {
        IRunnableWithProgress setDirectoryRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Load Data Directory", -1);
                    if (save) {
                        externalizationManager.save(false);
                    }
                    Job.getJobManager().beginRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    TasksUi.getTaskActivityManager().deactivateActiveTask();
                    externalizationManager.setRootFolderPath(newPath);
                    TasksUiPlugin.this.loadDataSources();
                }
                finally {
                    Job.getJobManager().endRule(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
                    monitor.done();
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            if (!CoreUtil.TEST_MODE) {
                service.run(false, false, setDirectoryRunnable);
            } else {
                setDirectoryRunnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, ID_PLUGIN, "Failed to set data directory", e.getCause()));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    private void loadDataSources() {
        File storeFile = this.getContextStoreDir();
        ContextCorePlugin.getContextStore().setContextDirectory(storeFile);
        externalizationManager.load();
        this.loadTemplateRepositories();
        taskActivityManager.clear();
        ContextCorePlugin.getContextManager().loadActivityMetaContext();
        this.taskActivityMonitor.reloadActivityTime();
        taskActivityManager.reloadPlanningData();
        for (final IRepositoryModelListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    StatusHandler.log((IStatus)new Status(2, TasksUiPlugin.ID_PLUGIN, "Listener failed: " + listener.getClass(), exception));
                }

                public void run() throws Exception {
                    listener.loaded();
                }
            });
        }
    }

    private File getContextStoreDir() {
        File storeFile = new File(this.getDataDirectory(), "contexts");
        if (!storeFile.exists()) {
            storeFile.mkdirs();
        }
        return storeFile;
    }

    private void initializePreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.mylyn.data.dir", this.getDefaultDataDirectory());
        store.setDefault("org.eclipse.mylyn.tasks.ui.group.subtasks", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.notifications.enabled", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.priority", ITask.PriorityLevel.P5.toString());
        store.setDefault("org.eclipse.mylyn.tasks.ui.reporting.open.editor", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.activate.when.opened", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.show.trim", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.subtasks.local", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", "1200000");
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.maxfiles", 20);
        store.setDefault("org.eclipse.mylyn.tasks.ui.backup.last", 0.0f);
        store.setDefault("org.eclipse.mylyn.tasks.ui.filters.archive", true);
        store.setDefault("org.eclipse.mylyn.tasks.ui.activation.multipe", false);
        store.setValue("org.eclipse.mylyn.tasks.ui.activation.multipe", false);
        store.setDefault("org.eclipse.mylyn.tasks.ui.planning.week.start.day", Calendar.getInstance().getFirstDayOfWeek());
        store.setDefault("org.eclipse.mylyn.tasks.ui.planning.end.hour", 18);
    }

    public static TaskListManager getTaskListManager() {
        return taskListManager;
    }

    public static TaskActivityManager getTaskActivityManager() {
        return taskActivityManager;
    }

    public static TaskListNotificationManager getTaskListNotificationManager() {
        return TasksUiPlugin.INSTANCE.taskListNotificationManager;
    }

    public static TasksUiPlugin getDefault() {
        return INSTANCE;
    }

    public boolean groupSubtasks(ITaskContainer element) {
        AbstractRepositoryConnectorUi connectorUi;
        boolean groupSubtasks = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.group.subtasks");
        if (element instanceof ITask && (connectorUi = TasksUiPlugin.getConnectorUi(((ITask)element).getConnectorKind())) != null && connectorUi.hasStrictSubtaskHierarchy()) {
            groupSubtasks = true;
        }
        if (element instanceof IRepositoryQuery && (connectorUi = TasksUiPlugin.getConnectorUi(((IRepositoryQuery)element).getConnectorKind())) != null && connectorUi.hasStrictSubtaskHierarchy()) {
            groupSubtasks = true;
        }
        return groupSubtasks;
    }

    public Map<String, List<IDynamicSubMenuContributor>> getDynamicMenuMap() {
        return this.menuContributors;
    }

    public void addDynamicPopupContributor(String menuPath, IDynamicSubMenuContributor contributor) {
        List<IDynamicSubMenuContributor> contributors = this.menuContributors.get(menuPath);
        if (contributors == null) {
            contributors = new ArrayList<IDynamicSubMenuContributor>();
            this.menuContributors.put(menuPath, contributors);
        }
        contributors.add(contributor);
    }

    public String[] getSaveOptions() {
        String[] options = new String[]{TaskListSaveMode.ONE_HOUR.toString(), TaskListSaveMode.THREE_HOURS.toString(), TaskListSaveMode.DAY.toString()};
        return options;
    }

    public String getBackupFolderPath() {
        return String.valueOf(this.getDataDirectory()) + '/' + "backup";
    }

    public ITaskHighlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(ITaskHighlighter highlighter) {
        this.highlighter = highlighter;
    }

    public AbstractTaskEditorPageFactory[] getTaskEditorPageFactories() {
        return this.taskEditorPageFactories.toArray(new AbstractTaskEditorPageFactory[0]);
    }

    public Set<AbstractTaskEditorFactory> getTaskEditorFactories() {
        return this.taskEditorFactories;
    }

    public void addContextEditor(AbstractTaskEditorFactory contextEditor) {
        if (contextEditor != null) {
            this.taskEditorFactories.add(contextEditor);
        }
    }

    public void addTaskEditorPageFactory(AbstractTaskEditorPageFactory factory) {
        Assert.isNotNull((Object)factory);
        this.taskEditorPageFactories.add(factory);
    }

    public void removeTaskEditorPageFactory(AbstractTaskEditorPageFactory factory) {
        Assert.isNotNull((Object)factory);
        this.taskEditorPageFactories.remove(factory);
    }

    public static TaskRepositoryManager getRepositoryManager() {
        return repositoryManager;
    }

    public static RepositoryTemplateManager getRepositoryTemplateManager() {
        return TasksUiPlugin.INSTANCE.repositoryTemplateManager;
    }

    public void addBrandingIcon(String repositoryType, Image icon) {
        this.brandingIcons.put(repositoryType, icon);
    }

    public Image getBrandingIcon(String repositoryType) {
        return this.brandingIcons.get(repositoryType);
    }

    public void addOverlayIcon(String repositoryType, ImageDescriptor icon) {
        this.overlayIcons.put(repositoryType, icon);
    }

    public ImageDescriptor getOverlayIcon(String repositoryType) {
        return this.overlayIcons.get(repositoryType);
    }

    public void addRepositoryLinkProvider(AbstractTaskRepositoryLinkProvider repositoryLinkProvider) {
        if (repositoryLinkProvider != null) {
            this.repositoryLinkProviders.add(repositoryLinkProvider);
        }
    }

    public static TaskListBackupManager getBackupManager() {
        return TasksUiPlugin.INSTANCE.taskListBackupManager;
    }

    public static TaskDataStorageManager getTaskDataStorageManager() {
        return TasksUiPlugin.INSTANCE.taskDataStorageManager;
    }

    public void addRepositoryConnectorUi(AbstractRepositoryConnectorUi repositoryConnectorUi) {
        if (!repositoryConnectorUiMap.values().contains(repositoryConnectorUi)) {
            repositoryConnectorUiMap.put(repositoryConnectorUi.getConnectorKind(), repositoryConnectorUi);
        }
    }

    public static AbstractRepositoryConnector getConnector(String kind) {
        return TasksUiPlugin.getRepositoryManager().getRepositoryConnector(kind);
    }

    public static AbstractRepositoryConnectorUi getConnectorUi(String kind) {
        return repositoryConnectorUiMap.get(kind);
    }

    public static TaskListSynchronizationScheduler getSynchronizationScheduler() {
        return synchronizationScheduler;
    }

    public static TaskDataManager getTaskDataManager() {
        return taskDataManager;
    }

    public static TaskJobFactory getTaskJobFactory() {
        return TasksUiPlugin.INSTANCE.taskJobFactory;
    }

    public void addDuplicateDetector(AbstractDuplicateDetector duplicateDetector) {
        Assert.isNotNull((Object)duplicateDetector);
        this.duplicateDetectors.add(duplicateDetector);
    }

    public Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        return this.duplicateDetectors;
    }

    public String getRepositoriesFilePath() {
        return String.valueOf(this.getDataDirectory()) + File.separator + "repositories.xml.zip";
    }

    public void addModelListener(IRepositoryModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IRepositoryModelListener listener) {
        this.listeners.remove(listener);
    }

    public boolean canSetRepositoryForResource(IResource resource) {
        if (resource == null) {
            return false;
        }
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            TaskRepository repository = linkProvider.getTaskRepository(resource, (IRepositoryManager)TasksUiPlugin.getRepositoryManager());
            if (repository == null) continue;
            return linkProvider.canSetTaskRepository(resource);
        }
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            if (!linkProvider.canSetTaskRepository(resource)) continue;
            return true;
        }
        return false;
    }

    public void setRepositoryForResource(IResource resource, TaskRepository repository) throws CoreException {
        if (resource == null || repository == null) {
            return;
        }
        for (AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            TaskRepository r = linkProvider.getTaskRepository(resource, (IRepositoryManager)TasksUiPlugin.getRepositoryManager());
            boolean canSetRepository = linkProvider.canSetTaskRepository(resource);
            if (r != null && !canSetRepository) {
                return;
            }
            if (!canSetRepository) continue;
            linkProvider.setTaskRepository(resource, repository);
            return;
        }
    }

    public TaskRepository getRepositoryForResource(final IResource resource) {
        Assert.isNotNull((Object)resource);
        HashSet<AbstractTaskRepositoryLinkProvider> defectiveLinkProviders = new HashSet<AbstractTaskRepositoryLinkProvider>();
        for (final AbstractTaskRepositoryLinkProvider linkProvider : this.repositoryLinkProviders) {
            long startTime = System.nanoTime();
            final TaskRepository[] repository = new TaskRepository[1];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Repository link provider failed: \"" + linkProvider.getId() + "\"", e));
                }

                public void run() throws Exception {
                    repository[0] = linkProvider.getTaskRepository(resource, (IRepositoryManager)TasksUiPlugin.getRepositoryManager());
                }
            });
            long elapsed = System.nanoTime() - startTime;
            if (elapsed > 705032704L) {
                defectiveLinkProviders.add(linkProvider);
            }
            if (repository[0] == null) continue;
            return repository[0];
        }
        if (!defectiveLinkProviders.isEmpty()) {
            this.repositoryLinkProviders.removeAll(defectiveLinkProviders);
            StatusHandler.log((IStatus)new Status(2, ID_PLUGIN, "Repository link provider took over 5s to execute and was timed out: \"" + defectiveLinkProviders + "\""));
        }
        return null;
    }

    @Deprecated
    public TaskRepository getRepositoryForResource(IResource resource, boolean silent) {
        TaskRepository repository = this.getRepositoryForResource(resource);
        if (repository == null && !silent) {
            MessageDialog.openInformation(null, (String)"No Repository Found", (String)"No repository was found. Associate a Task Repository with this project via the project's property page.");
        }
        return repository;
    }

    public String getNextNewRepositoryTaskId() {
        return TasksUiPlugin.getTaskDataStorageManager().getNewRepositoryTaskId();
    }

    public static ExternalizationManager getExternalizationManager() {
        return externalizationManager;
    }

    public static TaskActivityMonitor getTaskActivityMonitor() {
        return TasksUiPlugin.INSTANCE.taskActivityMonitor;
    }

    public static TaskList getTaskList() {
        return taskList;
    }

    public static RepositoryModel getRepositoryModel() {
        return repositoryModel;
    }

    public void addSearchHandler(AbstractSearchHandler searchHandler) {
        this.searchHandlers.add(searchHandler);
    }

    public void removeSearchHandler(AbstractSearchHandler searchHandler) {
        this.searchHandlers.remove(searchHandler);
    }

    public AbstractSearchHandler getSearchHandler(String connectorKind) {
        Assert.isNotNull((Object)connectorKind);
        for (AbstractSearchHandler searchHandler : this.searchHandlers) {
            if (!searchHandler.getConnectorKind().equals(connectorKind)) continue;
            return searchHandler;
        }
        return null;
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrderComparator
    implements Comparator<AbstractTaskRepositoryLinkProvider> {
        private OrderComparator() {
        }

        @Override
        public int compare(AbstractTaskRepositoryLinkProvider p1, AbstractTaskRepositoryLinkProvider p2) {
            return p1.getOrder() - p2.getOrder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportOpenMode {
        EDITOR,
        INTERNAL_BROWSER,
        EXTERNAL_BROWSER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskListSaveMode {
        ONE_HOUR,
        THREE_HOURS,
        DAY;


        public String toString() {
            switch (this) {
                case ONE_HOUR: {
                    return "1 hour";
                }
                case THREE_HOURS: {
                    return "3 hours";
                }
                case DAY: {
                    return "1 day";
                }
            }
            return "3 hours";
        }

        public static TaskListSaveMode fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("1 hour")) {
                return ONE_HOUR;
            }
            if (string.equals("3 hours")) {
                return THREE_HOURS;
            }
            if (string.equals("1 day")) {
                return DAY;
            }
            return null;
        }

        public static long fromStringToLong(String string) {
            long hour = 3600000L;
            switch (TaskListSaveMode.fromString(string)) {
                case ONE_HOUR: {
                    return hour;
                }
                case THREE_HOURS: {
                    return hour * 3L;
                }
                case DAY: {
                    return hour * 24L;
                }
            }
            return hour * 3L;
        }
    }

    private class TasksUiInitializationJob
    extends UIJob {
        public TasksUiInitializationJob() {
            super("Initializing Task List");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            block14: {
                monitor.beginTask("Initializing Task List", 5);
                try {
                    TasksUiExtensionReader.initWorkbenchUiExtensions();
                    externalizationManager.getLoadStatus();
                    for (AbstractTask task : taskListManager.getTaskList().getAllTasks()) {
                        if (!task.isActive()) continue;
                        taskListManager.activateTask(task);
                        break;
                    }
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize task activity", t));
                }
                monitor.worked(1);
                try {
                    TasksUiPlugin.this.taskListNotificationManager = new TaskListNotificationManager();
                    TasksUiPlugin.this.taskListNotificationManager.addNotificationProvider(REMINDER_NOTIFICATION_PROVIDER);
                    TasksUiPlugin.this.taskListNotificationManager.addNotificationProvider(new TaskListNotifier(TasksUiPlugin.getRepositoryModel(), TasksUiPlugin.getTaskDataManager()));
                    TasksUiPlugin.this.taskListNotificationManager.startNotification(5000L);
                    TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)TasksUiPlugin.this.taskListNotificationManager);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize notifications", t));
                }
                monitor.worked(1);
                try {
                    TasksUiPlugin.this.taskListBackupManager = new TaskListBackupManager(TasksUiPlugin.this.getBackupFolderPath());
                    TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)TasksUiPlugin.this.taskListBackupManager);
                    synchronizationScheduler = new TaskListSynchronizationScheduler(TasksUiPlugin.this.taskJobFactory);
                    TasksUiPlugin.this.updateSynchronizationScheduler(true);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not initialize task list backup and synchronization", t));
                }
                monitor.worked(1);
                try {
                    try {
                        TasksUiPlugin.this.getPreferenceStore().addPropertyChangeListener(TasksUiPlugin.this.PROPERTY_LISTENER);
                        TaskRepositoriesView repositoriesView = TaskRepositoriesView.getFromActivePerspective();
                        if (repositoriesView != null) {
                            repositoriesView.getViewer().refresh();
                        }
                        TasksUiPlugin.this.taskEditorBloatManager = new TaskEditorBloatMonitor();
                        TasksUiPlugin.this.taskEditorBloatManager.install(PlatformUI.getWorkbench());
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, TasksUiPlugin.ID_PLUGIN, "Could not finish Tasks UI initialization", t));
                        monitor.done();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return new Status(0, TasksUiPlugin.ID_PLUGIN, 0, "", null);
        }
    }

    public static class TasksUiStartup
    implements IStartup {
        public void earlyStartup() {
        }
    }
}

