/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;

public class OpenTaskListElementAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.open";
    private final TreeViewer viewer;

    public OpenTaskListElementAction(TreeViewer view) {
        this.viewer = view;
        this.setText("Open");
        this.setToolTipText("Open Task List Element");
        this.setId(ID);
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        ISelection selection = this.viewer.getSelection();
        List list = ((IStructuredSelection)selection).toList();
        for (Object element : list) {
            if (element instanceof ITask && event != null && (event.keyCode & SWT.MOD1) != 0) {
                TasksUiInternal.openTaskInBackground((ITask)((AbstractTask)element), true);
                continue;
            }
            if (element instanceof ITask) {
                TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)((ITask)element));
                continue;
            }
            if (this.viewer.getExpandedState(element)) {
                this.viewer.collapseToLevel(element, 1);
                continue;
            }
            this.viewer.expandToLevel(element, 1);
        }
    }
}

