/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListContentProvider
extends AbstractTaskListContentProvider {
    public TaskListContentProvider(TaskListView taskListView) {
        super(taskListView);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.taskListView.expandToActiveTasks();
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.taskListView.getViewSite())) {
            return this.applyFilter(TasksUiPlugin.getTaskList().getRootElements()).toArray();
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof ITask) {
            ITask task = (ITask)child;
            AbstractTaskCategory parent = TaskCategory.getParentTaskCategory((ITask)task);
            if (parent != null) {
                return parent;
            }
            Set parents = ((AbstractTask)task).getParentContainers();
            Iterator it = parents.iterator();
            if (it.hasNext()) {
                return parents.iterator().next();
            }
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        return this.getFilteredChildrenFor(parent).toArray();
    }

    public boolean hasChildren(Object parent) {
        Object[] children = this.getChildren(parent);
        return children != null && children.length > 0;
    }

    protected List<AbstractTaskContainer> applyFilter(Set<AbstractTaskContainer> roots) {
        ArrayList<AbstractTaskContainer> filteredRoots = new ArrayList<AbstractTaskContainer>();
        for (AbstractTaskContainer element : roots) {
            if (!this.selectContainer((ITaskContainer)element)) continue;
            filteredRoots.add(element);
        }
        return filteredRoots;
    }

    private boolean containsNoFilterText(String filterText) {
        return filterText == null || filterText.length() == 0;
    }

    private boolean selectContainer(ITaskContainer container) {
        return !this.filter(null, container);
    }

    private List<IRepositoryElement> getFilteredChildrenFor(Object parent) {
        if (this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterControl().getText())) {
            ArrayList<IRepositoryElement> children = new ArrayList<IRepositoryElement>();
            if (parent instanceof ITask) {
                Collection subTasks = ((AbstractTask)parent).getChildren();
                for (ITask task : subTasks) {
                    if (this.filter(parent, task)) continue;
                    children.add((IRepositoryElement)task);
                }
                return children;
            }
            if (parent instanceof ITaskContainer) {
                return this.getFilteredRootChildren((ITaskContainer)parent);
            }
        } else {
            ArrayList<IRepositoryElement> children = new ArrayList<IRepositoryElement>();
            if (parent instanceof ITaskContainer) {
                children.addAll(((ITaskContainer)parent).getChildren());
                return children;
            }
        }
        return Collections.emptyList();
    }

    private List<IRepositoryElement> getFilteredRootChildren(ITaskContainer parent) {
        ArrayList<IRepositoryElement> result = new ArrayList<IRepositoryElement>();
        if (TasksUiPlugin.getDefault().groupSubtasks(parent)) {
            Collection parentTasks = parent.getChildren();
            HashSet<ITask> parents = new HashSet<ITask>();
            HashSet<ITask> children = new HashSet<ITask>();
            for (ITask element : parentTasks) {
                if (!(element instanceof ITaskContainer)) continue;
                for (ITask abstractTask : ((ITaskContainer)element).getChildren()) {
                    children.add(abstractTask);
                }
            }
            for (ITask task : parentTasks) {
                if (this.filter(parent, task) || children.contains(task)) continue;
                parents.add(task);
            }
            result.addAll(parents);
        } else {
            for (IRepositoryElement element : parent.getChildren()) {
                if (this.filter(parent, element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected boolean filter(Object parent, Object object) {
        boolean emptyFilterText = this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterControl().getText());
        for (AbstractTaskListFilter filter : this.taskListView.getFilters()) {
            if (!(emptyFilterText ? !filter.select(parent, object) : filter.applyToFilteredText() && !filter.select(parent, object))) continue;
            return true;
        }
        return false;
    }
}

