/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryModelListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryAdapter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.views.DisconnectRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.UpdateRepositoryConfigurationAction;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class TaskRepositoriesView
extends ViewPart {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.views.repositories";
    private TableViewer viewer;
    private final Action addRepositoryAction = new AddRepositoryAction();
    private BaseSelectionListenerAction deleteRepositoryAction;
    private BaseSelectionListenerAction resetConfigurationAction;
    private DisconnectRepositoryAction offlineAction;
    private final IRepositoryModelListener MODEL_LISTENER = new IRepositoryModelListener(){

        public void loaded() {
            TaskRepositoriesView.this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }
    };
    private final IRepositoryListener REPOSITORY_LISTENER = new TaskRepositoryAdapter(){

        public void repositoryAdded(TaskRepository repository) {
            TaskRepositoriesView.this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }

        public void repositoryRemoved(TaskRepository repository) {
            TaskRepositoriesView.this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }

        public void repositorySettingsChanged(TaskRepository repository) {
            TaskRepositoriesView.this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }
    };

    private void asyncExec(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public TaskRepositoriesView() {
        TasksUi.getRepositoryManager().addListener(this.REPOSITORY_LISTENER);
        TasksUiPlugin.getDefault().addModelListener(this.MODEL_LISTENER);
    }

    public void dispose() {
        super.dispose();
        TasksUiPlugin.getRepositoryManager().removeListener(this.REPOSITORY_LISTENER);
        TasksUiPlugin.getDefault().removeModelListener(this.MODEL_LISTENER);
    }

    public static TaskRepositoriesView getFromActivePerspective() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage == null) {
                return null;
            }
            IViewPart view = activePage.findView(ID);
            if (view instanceof TaskRepositoriesView) {
                return (TaskRepositoriesView)view;
            }
        }
        return null;
    }

    public static TaskRepositoriesView openInActivePerspective() {
        try {
            return (TaskRepositoriesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new TaskRepositoriesSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService service = (IHandlerService)TaskRepositoriesView.this.getSite().getService(IHandlerService.class);
                if (service != null) {
                    try {
                        service.executeCommand("org.eclipse.ui.file.properties", null);
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Opening repository properties failed", (Throwable)e));
                    }
                }
            }
        });
        TasksUi.getRepositoryManager().addListener((IRepositoryListener)new TaskRepositoryListener());
        this.makeActions();
        this.hookContextMenu();
        this.hookGlobalActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteRepositoryAction);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.resetConfigurationAction);
    }

    private void makeActions() {
        this.deleteRepositoryAction = new DeleteTaskRepositoryAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteRepositoryAction);
        this.resetConfigurationAction = new UpdateRepositoryConfigurationAction();
        this.resetConfigurationAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.resetConfigurationAction);
        this.offlineAction = new DisconnectRepositoryAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.offlineAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskRepositoriesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteRepositoryAction);
        manager.add((IAction)this.resetConfigurationAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.offlineAction);
        manager.add((IContributionItem)new Separator("repository"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("properties"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRepositoryAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public class TaskRepositoryListener
    extends TaskRepositoryAdapter {
        public void repositorySettingsChanged(TaskRepository repository) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!TaskRepositoriesView.this.getViewer().getControl().isDisposed()) {
                        TaskRepositoriesView.this.getViewer().refresh(true);
                    }
                }
            });
        }
    }

    static class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return TasksUi.getRepositoryManager().getAllRepositories().toArray();
        }
    }
}

