/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.ui.PlatformUI;

public class TaskScheduleContentProvider
extends TaskListContentProvider
implements ITaskActivityListener {
    private final TaskActivityManager taskActivityManager = TasksUiPlugin.getTaskActivityManager();
    private Timer timer;
    private final Unscheduled unscheduled;
    private final Calendar END_OF_TIME;

    public TaskScheduleContentProvider(TaskListView taskListView) {
        super(taskListView);
        this.taskActivityManager.addActivityListener((ITaskActivityListener)this);
        this.END_OF_TIME = TaskActivityUtil.getCalendar();
        this.END_OF_TIME.add(1, 5000);
        this.END_OF_TIME.getTime();
        this.unscheduled = new Unscheduled(this.taskActivityManager, new DateRange(this.END_OF_TIME));
        this.timer = new Timer();
    }

    public Object[] getElements(Object parent) {
        if (parent != null && parent.equals(this.taskListView.getViewSite())) {
            HashSet<AbstractTaskContainer> containers = new HashSet<AbstractTaskContainer>();
            WeekDateRange week = TaskActivityUtil.getCurrentWeek();
            WeekDateRange nextWeek = TaskActivityUtil.getNextWeek();
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new RolloverCheck(), week.getToday().getEndDate().getTime());
            for (DateRange day : week.getRemainingDays()) {
                containers.add((AbstractTaskContainer)new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), day));
            }
            containers.add((AbstractTaskContainer)new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), (DateRange)week));
            for (DateRange day : nextWeek.getDaysOfWeek()) {
                containers.add((AbstractTaskContainer)new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), day));
            }
            ScheduledTaskContainer nextWeekContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)nextWeek);
            containers.add((AbstractTaskContainer)nextWeekContainer);
            ScheduledTaskContainer twoWeeksContainer = new ScheduledTaskContainer(this.taskActivityManager, (DateRange)week.next().next(), "Two Weeks");
            containers.add((AbstractTaskContainer)twoWeeksContainer);
            containers.add((AbstractTaskContainer)this.unscheduled);
            Calendar startDate = TaskActivityUtil.getCalendar();
            startDate.setTimeInMillis(twoWeeksContainer.getEnd().getTimeInMillis());
            TaskActivityUtil.snapNextDay((Calendar)startDate);
            Calendar endDate = TaskActivityUtil.getCalendar();
            endDate.add(1, 4999);
            DateRange future = new DateRange(startDate, endDate);
            ScheduledTaskContainer futureContainer = new ScheduledTaskContainer(this.taskActivityManager, future, "Future");
            containers.add((AbstractTaskContainer)futureContainer);
            return this.applyFilter(containers).toArray();
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        return null;
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    public Object[] getChildren(Object parent) {
        HashSet<ITask> result;
        block2: {
            block3: {
                result = new HashSet<ITask>();
                if (parent instanceof ITask) break block2;
                if (!(parent instanceof ScheduledTaskContainer)) break block3;
                for (ITask child : ((ScheduledTaskContainer)parent).getChildren()) {
                    if (this.filter(parent, child)) continue;
                    result.add(child);
                }
                break block2;
            }
            if (!(parent instanceof ITaskContainer)) break block2;
            for (ITask child : ((ITaskContainer)parent).getChildren()) {
                result.add(child);
            }
        }
        return result.toArray();
    }

    private void refresh() {
        if (Platform.isRunning() && PlatformUI.getWorkbench() != null && !PlatformUI.getWorkbench().isClosing()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskScheduleContentProvider.this.taskListView.refresh();
                }
            });
        }
    }

    public void dispose() {
        this.taskActivityManager.removeActivityListener((ITaskActivityListener)this);
        super.dispose();
    }

    public void activityReset() {
        this.refresh();
    }

    public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
    }

    public void preTaskActivated(ITask task) {
    }

    public void preTaskDeactivated(ITask task) {
    }

    public void taskActivated(ITask task) {
    }

    public void taskDeactivated(ITask task) {
    }

    private class RolloverCheck
    extends TimerTask {
        private RolloverCheck() {
        }

        public void run() {
            TaskScheduleContentProvider.this.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Unscheduled
    extends ScheduledTaskContainer {
        private final TaskActivityManager activityManager;

        public Unscheduled(TaskActivityManager activityManager, DateRange range) {
            super(activityManager, range, "Unscheduled");
            this.activityManager = activityManager;
        }

        public Collection<ITask> getChildren() {
            HashSet<ITask> all = new HashSet<ITask>();
            for (ITask task : this.activityManager.getUnscheduled()) {
                if (task.isCompleted() && (!task.isCompleted() || task.getSynchronizationState().isSynchronized())) continue;
                all.add(task);
            }
            return all;
        }
    }
}

