/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.LocalAttachment;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ImageAttachment;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

@Deprecated
public class PreviewAttachmentPage
extends WizardPage {
    private static final String PAGE_NAME = "PreviewAttachmentPage";
    private static final String TITLE = "Attachment Preview";
    private static final String DESCRIPTION = "Review the attachment before submitting";
    private final LocalAttachment attachment;
    private static HashMap<String, String> textTypes = new HashMap();
    private static HashMap<String, String> imageTypes = new HashMap();
    private ScrolledComposite scrolledComposite;

    static {
        textTypes.put("text/plain", "");
        textTypes.put("text/html", "");
        textTypes.put("text/html", "");
        textTypes.put("application/xml", "");
        imageTypes.put("image/jpeg", "");
        imageTypes.put("image/gif", "");
        imageTypes.put("image/png", "");
    }

    private static boolean isTextAttachment(String contentType) {
        return textTypes.get(contentType) != null;
    }

    private static boolean isImageAttachment(String contentType) {
        return imageTypes.get(contentType) != null;
    }

    protected PreviewAttachmentPage(LocalAttachment attachment) {
        super(PAGE_NAME);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.attachment = attachment;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        if (this.attachment instanceof ImageAttachment) {
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Preparing image for preview...", 1);
                        ((ImageAttachment)PreviewAttachmentPage.this.attachment).ensureImageFileWasCreated();
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                this.createErrorPreview(composite, "Could not create image for preview");
                return;
            }
            catch (InterruptedException interruptedException) {
                this.createErrorPreview(composite, "Could not create image for preview");
                return;
            }
        }
        if ("<Clipboard>".equals(this.attachment.getFilePath())) {
            this.createTextPreview(composite, ((NewAttachmentWizard)this.getWizard()).getClipboardContents());
        } else if (PreviewAttachmentPage.isTextAttachment(this.attachment.getContentType())) {
            this.createTextPreview(composite, this.attachment);
        } else if (PreviewAttachmentPage.isImageAttachment(this.attachment.getContentType())) {
            this.createImagePreview(composite, this.attachment);
        } else {
            this.createGenericPreview(composite, this.attachment);
        }
    }

    private void createTextPreview(Composite composite, String contents) {
        Text text = new Text(composite, 2826);
        GridData gd = new GridData(1808);
        gd.heightHint = composite.getBounds().y;
        gd.widthHint = composite.getBounds().x;
        text.setLayoutData((Object)gd);
        text.setText(contents);
    }

    private void createTextPreview(Composite composite, LocalAttachment attachment) {
        try {
            String line;
            StringBuffer content = new StringBuffer();
            BufferedReader in = new BufferedReader(new FileReader(new File(attachment.getFilePath())));
            while ((line = in.readLine()) != null) {
                content.append(line);
                content.append("\n");
            }
            in.close();
            this.createTextPreview(composite, content.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.createErrorPreview(composite, "Could not locate file '" + attachment.getFilePath() + "'");
        }
        catch (IOException iOException) {
            this.createErrorPreview(composite, "Error reading file '" + attachment.getFilePath() + "'");
        }
    }

    private void createImagePreview(Composite composite, LocalAttachment attachment) {
        Image originalImage = new Image((Device)composite.getDisplay(), attachment.getFilePath());
        final Image bufferedImage = new Image((Device)composite.getDisplay(), originalImage.getBounds());
        GC gc = new GC((Drawable)bufferedImage);
        gc.setBackground(composite.getBackground());
        gc.fillRectangle(originalImage.getBounds());
        gc.drawImage(originalImage, 0, 0);
        gc.dispose();
        originalImage.dispose();
        this.scrolledComposite = new ScrolledComposite(composite, 2816);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        Composite canvasComposite = new Composite((Composite)this.scrolledComposite, 0);
        canvasComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Canvas canvas = new Canvas(canvasComposite, 262144);
        final Rectangle imgSize = bufferedImage.getBounds();
        canvas.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(imgSize.width, imgSize.height).create());
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(bufferedImage, 0, 0);
            }
        });
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bufferedImage.dispose();
            }
        });
        canvas.setSize(imgSize.width, imgSize.height);
        this.scrolledComposite.setMinSize(imgSize.width, imgSize.height);
        this.scrolledComposite.setContent((Control)canvasComposite);
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PreviewAttachmentPage.this.adjustScrollbars(imgSize);
            }
        });
        this.adjustScrollbars(imgSize);
    }

    private void adjustScrollbars(Rectangle imgSize) {
        Rectangle clientArea = this.scrolledComposite.getClientArea();
        ScrollBar hBar = this.scrolledComposite.getHorizontalBar();
        hBar.setMinimum(0);
        hBar.setMaximum(imgSize.width - 1);
        hBar.setPageIncrement(clientArea.width);
        hBar.setIncrement(10);
        ScrollBar vBar = this.scrolledComposite.getVerticalBar();
        vBar.setMinimum(0);
        vBar.setMaximum(imgSize.height - 1);
        vBar.setPageIncrement(clientArea.height);
        vBar.setIncrement(10);
    }

    private void createGenericPreview(Composite composite, LocalAttachment attachment) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        label.setText("Attaching File '" + attachment.getFilePath() + "'\nA preview the type '" + attachment.getContentType() + "' is currently not available");
    }

    private void createErrorPreview(Composite composite, String message) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        label.setText(message);
    }
}

