/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataExportOperation;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataExportWizardPage;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TaskDataExportWizard
extends Wizard
implements IExportWizard {
    private static final String SETTINGS_SECTION = "org.eclipse.mylyn.tasklist.ui.exportWizard";
    private static final String WINDOW_TITLE = "Export";
    private TaskDataExportWizardPage exportPage = null;

    public TaskDataExportWizard() {
        IDialogSettings masterSettings = TasksUiPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WINDOW_TITLE);
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings settings = master.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = master.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    public void addPages() {
        this.exportPage = new TaskDataExportWizardPage();
        this.exportPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.exportPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return this.exportPage.isPageComplete();
    }

    public boolean performFinish() {
        boolean overwrite = this.exportPage.overwrite();
        boolean zip = this.exportPage.zip();
        Collection taskContextsToExport = TasksUiPlugin.getTaskList().getAllTasks();
        String destDir = this.exportPage.getDestinationDirectory();
        File destDirFile = new File(destDir);
        if (!destDirFile.exists() || !destDirFile.isDirectory()) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export data because specified location does not exist or is not a folder", (Throwable)new Exception()));
            return false;
        }
        File destTaskListFile = new File(String.valueOf(destDir) + File.separator + "tasks.xml.zip");
        File destActivationHistoryFile = new File(String.valueOf(destDir) + File.separator + "activity" + ".xml.zip");
        File destZipFile = new File(String.valueOf(destDir) + File.separator + TaskListBackupManager.getBackupFileName());
        if (!overwrite) {
            if (zip) {
                if (destZipFile.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm File Replace", (String)("The zip file " + destZipFile.getPath() + " already exists. Do you want to overwrite it?"))) {
                    return false;
                }
            } else {
                if (this.exportPage.exportTaskList() && destTaskListFile.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm File Replace", (String)("The task list file " + destTaskListFile.getPath() + " already exists. Do you want to overwrite it?"))) {
                    return false;
                }
                if (this.exportPage.exportActivationHistory() && destActivationHistoryFile.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm File Replace", (String)("The task activation history file " + destActivationHistoryFile.getPath() + " already exists. Do you want to overwrite it?"))) {
                    return false;
                }
                if (this.exportPage.exportTaskContexts()) {
                    for (ITask task : taskContextsToExport) {
                        File contextFile = ContextCorePlugin.getContextStore().getFileForContext(task.getHandleIdentifier());
                        File destTaskFile = new File(String.valueOf(destDir) + File.separator + contextFile.getName());
                        if (!destTaskFile.exists()) continue;
                        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm File Replace", (String)("Task context files already exist in " + destDir + ". Do you want to overwrite them?"))) break;
                        return false;
                    }
                }
            }
        }
        TaskDataExportOperation job = new TaskDataExportOperation(this.exportPage.getDestinationDirectory(), this.exportPage.exportTaskList(), this.exportPage.exportActivationHistory(), this.exportPage.exportTaskContexts(), this.exportPage.zip(), destZipFile.getName(), taskContextsToExport);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.run(true, false, (IRunnableWithProgress)job);
        }
        catch (InvocationTargetException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export files", (Throwable)e));
        }
        catch (InterruptedException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not export files", (Throwable)e));
        }
        this.exportPage.saveSettings();
        return true;
    }
}

