/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.ui.ChangeActivityHandleOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskAttachmentDropListener;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttachmentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorNewCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlinePage;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPeoplePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPlanningPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorRichTextPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorSummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobListener;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskEditorPage
extends FormPage
implements ISelectionProvider,
ISelectionChangedListener {
    private final ITaskDataManagerListener TASK_DATA_LISTENER = new ITaskDataManagerListener(){

        public void taskDataUpdated(TaskDataManagerEvent event) {
            ITask task = event.getTask();
            if (task.equals(AbstractTaskEditorPage.this.getTask()) && event.getTaskDataUpdated()) {
                this.refresh(task);
            }
        }

        private void refresh(final ITask task) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AbstractTaskEditorPage.this.refreshDisabled) {
                        return;
                    }
                    if (!AbstractTaskEditorPage.this.isDirty() && task.getSynchronizationState() == ITask.SynchronizationState.SYNCHRONIZED) {
                        AbstractTaskEditorPage.this.refreshFormContent();
                    } else {
                        AbstractTaskEditorPage.this.getTaskEditor().setMessage("Task has incoming changes", 2, (IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                AbstractTaskEditorPage.this.refreshFormContent();
                            }
                        });
                        AbstractTaskEditorPage.this.setSubmitEnabled(false);
                    }
                }
            });
        }

        public void editsDiscarded(TaskDataManagerEvent event) {
            if (event.getTask().equals(AbstractTaskEditorPage.this.getTask())) {
                this.refresh(event.getTask());
            }
        }
    };
    private static final String ERROR_NOCONNECTIVITY = "Unable to submit at this time. Check connectivity and retry.";
    public static final String ID_PART_ACTIONS = "org.eclipse.mylyn.tasks.ui.editors.parts.actions";
    public static final String ID_PART_ATTACHMENTS = "org.eclipse.mylyn.tasks.ui.editors.parts.attachments";
    public static final String ID_PART_ATTRIBUTES = "org.eclipse.mylyn.tasks.ui.editors.parts.attributes";
    public static final String ID_PART_COMMENTS = "org.eclipse.mylyn.tasks.ui.editors.parts.comments";
    public static final String ID_PART_DESCRIPTION = "org.eclipse.mylyn.tasks.ui.editors.parts.descriptions";
    public static final String ID_PART_NEW_COMMENT = "org.eclipse.mylyn.tasks.ui.editors.parts.newComment";
    public static final String ID_PART_PEOPLE = "org.eclipse.mylyn.tasks.ui.editors.parts.people";
    public static final String ID_PART_PLANNING = "org.eclipse.mylyn.tasks.ui.editors.parts.planning";
    public static final String ID_PART_SUMMARY = "org.eclipse.mylyn.tasks.ui.editors.parts.summary";
    public static final String PATH_ACTIONS = "actions";
    public static final String PATH_ATTACHMENTS = "attachments";
    public static final String PATH_ATTRIBUTES = "attributes";
    public static final String PATH_COMMENTS = "comments";
    public static final String PATH_HEADER = "header";
    public static final String PATH_PEOPLE = "people";
    public static final String PATH_PLANNING = "planning";
    private AttributeEditorFactory attributeEditorFactory;
    private AttributeEditorToolkit attributeEditorToolkit;
    private Action clearOutgoingAction;
    private AbstractRepositoryConnector connector;
    private final String connectorKind;
    private StructuredSelection defaultSelection;
    private Composite editorComposite;
    private ScrolledForm form;
    private boolean formBusy;
    private Action historyAction;
    private Control lastFocusControl;
    private ISelection lastSelection;
    private TaskDataModel model;
    private boolean needsAddToCategory;
    private NewSubTaskAction newSubTaskAction;
    private Action openBrowserAction;
    private boolean reflow;
    private volatile boolean refreshDisabled;
    private final ListenerList selectionChangedListeners;
    private SynchronizeEditorAction synchronizeEditorAction;
    private DeleteTaskEditorAction deleteAction;
    private ITask task;
    private TaskData taskData;
    private FormToolkit toolkit;
    private TaskEditorOutlinePage outlinePage;
    private TaskAttachmentDropListener defaultDropListener;

    public AbstractTaskEditorPage(TaskEditor editor, String connectorKind) {
        super((FormEditor)editor, "id", "label");
        Assert.isNotNull((Object)connectorKind);
        this.connectorKind = connectorKind;
        this.reflow = true;
        this.selectionChangedListeners = new ListenerList();
    }

    private void addFocusListener(Composite composite, FocusListener listener) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text || control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Tree || control instanceof Table || control instanceof Spinner || control instanceof Link || control instanceof List || control instanceof TabFolder || control instanceof CTabFolder || control instanceof Hyperlink || control instanceof FilteredTree || control instanceof StyledText) {
                control.addFocusListener(listener);
            }
            if (control instanceof Composite) {
                this.addFocusListener((Composite)control, listener);
            }
            ++n2;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void appendTextToNewComment(String text) {
        AbstractTaskEditorPart newCommentPart = this.getPart(ID_PART_NEW_COMMENT);
        if (newCommentPart instanceof TaskEditorRichTextPart) {
            ((TaskEditorRichTextPart)newCommentPart).appendText(text);
            newCommentPart.setFocus();
        }
    }

    public boolean canPerformAction(String actionId) {
        return EditorUtil.canPerformAction(actionId, EditorUtil.getFocusControl((IFormPage)this));
    }

    public void close() {
        Display activeDisplay = this.getSite().getShell().getDisplay();
        activeDisplay.asyncExec(new Runnable(){

            public void run() {
                if (AbstractTaskEditorPage.this.getSite() != null && AbstractTaskEditorPage.this.getSite().getPage() != null && !AbstractTaskEditorPage.this.getManagedForm().getForm().isDisposed()) {
                    if (AbstractTaskEditorPage.this.getTaskEditor() != null) {
                        AbstractTaskEditorPage.this.getSite().getPage().closeEditor((IEditorPart)AbstractTaskEditorPage.this.getTaskEditor(), false);
                    } else {
                        AbstractTaskEditorPage.this.getSite().getPage().closeEditor((IEditorPart)AbstractTaskEditorPage.this, false);
                    }
                }
            }
        });
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new AttributeEditorFactory(this.getModel(), this.getTaskRepository());
    }

    AttributeEditorToolkit createAttributeEditorToolkit() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        return new AttributeEditorToolkit(handlerService);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.registerDefaultDropListener((Control)this.form);
        EditorUtil.disableScrollingOnFocus(this.form);
        try {
            this.setReflow(false);
            this.editorComposite = this.form.getBody();
            GridLayout editorLayout = new GridLayout();
            this.editorComposite.setLayout((Layout)editorLayout);
            this.editorComposite.setLayoutData((Object)new GridData(1808));
            this.editorComposite.setMenu(this.getTaskEditor().getMenu());
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.getConnectorKind());
            if (connectorUi == null) {
                this.getTaskEditor().setMessage("Synchronize to update editor contents", 1, (IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        AbstractTaskEditorPage.this.refreshFormContent();
                    }
                });
            }
            if (this.taskData != null) {
                this.createFormContentInternal();
            }
            this.updateHeaderMessage();
        }
        finally {
            this.setReflow(true);
        }
    }

    private void createFormContentInternal() {
        if (this.attributeEditorToolkit != null) {
            this.attributeEditorToolkit.dispose();
        }
        if (this.attributeEditorFactory == null) {
            this.attributeEditorFactory = this.createAttributeEditorFactory();
            Assert.isNotNull((Object)this.attributeEditorFactory);
        }
        this.attributeEditorToolkit = this.createAttributeEditorToolkit();
        Assert.isNotNull((Object)this.attributeEditorToolkit);
        this.attributeEditorToolkit.setMenu(this.editorComposite.getMenu());
        this.attributeEditorToolkit.setSelectionChangedListener(this);
        this.createParts();
        FocusAdapter listener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AbstractTaskEditorPage.this.lastFocusControl = (Control)e.widget;
            }
        };
        this.addFocusListener(this.editorComposite, (FocusListener)listener);
        AbstractTaskEditorPart summaryPart = this.getPart(ID_PART_SUMMARY);
        if (summaryPart != null) {
            this.lastFocusControl = summaryPart.getControl();
        }
    }

    protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
        ITaskDataWorkingCopy taskDataState;
        try {
            taskDataState = TasksUi.getTaskDataManager().getWorkingCopy(this.task);
        }
        catch (OperationCanceledException operationCanceledException) {
            taskDataState = TasksUi.getTaskDataManager().getWorkingCopy(this.task);
        }
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(taskDataState.getConnectorKind(), taskDataState.getRepositoryUrl());
        return new TaskDataModel(taskRepository, input.getTask(), taskDataState);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        LinkedHashSet<TaskEditorPartDescriptor> descriptors = new LinkedHashSet<TaskEditorPartDescriptor>();
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_SUMMARY){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorSummaryPart();
            }
        }.setPath(PATH_HEADER));
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_ATTRIBUTES){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorAttributePart();
            }
        }.setPath(PATH_ATTRIBUTES));
        if (!this.taskData.isNew()) {
            descriptors.add(new TaskEditorPartDescriptor(ID_PART_ATTACHMENTS){

                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorAttachmentPart();
                }
            }.setPath(PATH_ATTACHMENTS));
        }
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_DESCRIPTION){

            public AbstractTaskEditorPart createPart() {
                TaskEditorDescriptionPart part = new TaskEditorDescriptionPart();
                if (AbstractTaskEditorPage.this.getModel().getTaskData().isNew()) {
                    part.setExpandVertically(true);
                    part.setSectionStyle(320);
                }
                return part;
            }
        }.setPath(PATH_COMMENTS));
        if (!this.taskData.isNew()) {
            descriptors.add(new TaskEditorPartDescriptor(ID_PART_COMMENTS){

                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorCommentPart();
                }
            }.setPath(PATH_COMMENTS));
        }
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_NEW_COMMENT){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorNewCommentPart();
            }
        }.setPath(PATH_COMMENTS));
        if (this.taskData.isNew()) {
            descriptors.add(new TaskEditorPartDescriptor(ID_PART_PLANNING){

                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorPlanningPart();
                }
            }.setPath(PATH_PLANNING));
        }
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_ACTIONS){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorActionPart();
            }
        }.setPath(PATH_ACTIONS));
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_PEOPLE){

            public AbstractTaskEditorPart createPart() {
                return new TaskEditorPeoplePart();
            }
        }.setPath(PATH_PEOPLE));
        return descriptors;
    }

    protected void createParts() {
        LinkedList<TaskEditorPartDescriptor> descriptors = new LinkedList<TaskEditorPartDescriptor>(this.createPartDescriptors());
        this.createParts(PATH_HEADER, this.editorComposite, descriptors);
        this.createParts(PATH_ATTRIBUTES, this.editorComposite, descriptors);
        this.createParts(PATH_ATTACHMENTS, this.editorComposite, descriptors);
        this.createParts(PATH_COMMENTS, this.editorComposite, descriptors);
        this.createParts(PATH_PLANNING, this.editorComposite, descriptors);
        Composite bottomComposite = this.toolkit.createComposite(this.editorComposite);
        bottomComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bottomComposite);
        this.createParts(PATH_ACTIONS, bottomComposite, descriptors);
        this.createParts(PATH_PEOPLE, bottomComposite, descriptors);
        bottomComposite.pack(true);
    }

    private void createParts(String path, final Composite parent, Collection<TaskEditorPartDescriptor> descriptors) {
        Iterator<TaskEditorPartDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            final TaskEditorPartDescriptor descriptor = it.next();
            if (path != null && !path.equals(descriptor.getPath())) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating task editor part: \"" + descriptor.getId() + "\"", e));
                }

                public void run() throws Exception {
                    AbstractTaskEditorPart part = descriptor.createPart();
                    part.setPartId(descriptor.getId());
                    AbstractTaskEditorPage.this.initializePart(parent, part);
                }
            });
            it.remove();
        }
    }

    public void dispose() {
        if (this.attributeEditorToolkit != null) {
            this.attributeEditorToolkit.dispose();
        }
        TasksUiPlugin.getTaskDataManager().removeListener(this.TASK_DATA_LISTENER);
        super.dispose();
    }

    public void doAction(String actionId) {
        EditorUtil.doAction(actionId, EditorUtil.getFocusControl((IFormPage)this));
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        this.getManagedForm().commit(true);
        try {
            this.model.save(monitor);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error saving task", (Throwable)e));
            this.getTaskEditor().setMessage("Could not save task", 3, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    TasksUiInternal.displayStatus("Save failed", e.getStatus());
                }
            });
        }
        if (this.getTask().getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
            final String summary = this.connector.getTaskMapping(this.model.getTaskData()).getSummary();
            try {
                TasksUiPlugin.getTaskList().run(new ITaskListRunnable(){

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        AbstractTaskEditorPage.this.task.setSummary(summary);
                    }
                });
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)this.task);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to set summary for task \"" + this.task + "\"", (Throwable)e));
            }
        }
        this.updateHeaderMessage();
        this.getManagedForm().dirtyStateChanged();
        this.getTaskEditor().updateHeaderToolBar();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void doSubmit() {
        this.showEditorBusy(true);
        this.doSave((IProgressMonitor)new NullProgressMonitor());
        SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskJob(this.connector, this.getModel().getTaskRepository(), this.task, this.getModel().getTaskData(), this.getModel().getChangedOldAttributes());
        submitJob.addSubmitJobListener((SubmitJobListener)new SubmitTaskJobListener(this.getAttachContext()));
        submitJob.schedule();
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        TaskRepository taskRepository;
        TaskRepository taskRepository2 = taskRepository = this.model != null ? this.getModel().getTaskRepository() : null;
        if (taskRepository != null) {
            ControlContribution repositoryLabelControl = new ControlContribution("Title"){

                protected Control createControl(Composite parent) {
                    FormToolkit toolkit = AbstractTaskEditorPage.this.getTaskEditor().getHeaderForm().getToolkit();
                    Composite composite = toolkit.createComposite(parent);
                    composite.setLayout((Layout)new RowLayout());
                    composite.setBackground(null);
                    String label = taskRepository.getRepositoryLabel();
                    if (label.indexOf("//") != -1) {
                        label = label.substring(taskRepository.getRepositoryUrl().indexOf("//") + 2);
                    }
                    Hyperlink link = new Hyperlink(composite, 0);
                    link.setText(label);
                    link.setFont(JFaceResources.getBannerFont());
                    link.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            TasksUiUtil.openEditRepositoryWizard(taskRepository);
                        }
                    });
                    return composite;
                }
            };
            toolBarManager.add((IContributionItem)repositoryLabelControl);
        }
        if (this.taskData == null) {
            this.synchronizeEditorAction = new SynchronizeEditorAction();
            this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditor()));
            toolBarManager.add((IAction)this.synchronizeEditorAction);
        } else if (this.taskData.isNew()) {
            this.deleteAction = new DeleteTaskEditorAction(this.getTask());
            toolBarManager.add((IAction)this.deleteAction);
        } else if (taskRepository != null) {
            String taskUrlToOpen;
            String historyUrl;
            AbstractRepositoryConnectorUi connectorUi;
            this.clearOutgoingAction = new ClearOutgoingAction(Collections.singletonList(this.task));
            ((ClearOutgoingAction)this.clearOutgoingAction).setTaskEditorPage(this);
            if (this.clearOutgoingAction.isEnabled()) {
                toolBarManager.add((IAction)this.clearOutgoingAction);
            }
            if (this.task.getSynchronizationState() != ITask.SynchronizationState.OUTGOING_NEW) {
                this.synchronizeEditorAction = new SynchronizeEditorAction();
                this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditor()));
                toolBarManager.add((IAction)this.synchronizeEditorAction);
            }
            this.newSubTaskAction = new NewSubTaskAction();
            this.newSubTaskAction.selectionChanged((IAction)this.newSubTaskAction, (ISelection)new StructuredSelection((Object)this.task));
            if (this.newSubTaskAction.isEnabled()) {
                toolBarManager.add((IAction)this.newSubTaskAction);
            }
            if ((connectorUi = TasksUiPlugin.getConnectorUi(this.taskData.getConnectorKind())) != null && (historyUrl = connectorUi.getTaskHistoryUrl(taskRepository, this.task)) != null) {
                this.historyAction = new Action(){

                    public void run() {
                        TasksUiUtil.openUrl(historyUrl);
                    }
                };
                this.historyAction.setImageDescriptor(TasksUiImages.TASK_REPOSITORY_HISTORY);
                this.historyAction.setToolTipText("History");
                toolBarManager.add((IAction)this.historyAction);
            }
            if ((taskUrlToOpen = this.task.getUrl()) != null) {
                this.openBrowserAction = new Action(){

                    public void run() {
                        TasksUiUtil.openUrl(taskUrlToOpen);
                    }
                };
                this.openBrowserAction.setImageDescriptor(CommonImages.BROWSER_OPEN_TASK);
                this.openBrowserAction.setToolTipText("Open with Web Browser");
                toolBarManager.add((IAction)this.openBrowserAction);
            }
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            this.updateOutlinePage();
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    private void updateOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new TaskEditorOutlinePage();
            this.outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object select;
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection && (select = ((StructuredSelection)selection).getFirstElement()) instanceof TaskEditorOutlineNode) {
                        TaskEditorOutlineNode node = (TaskEditorOutlineNode)select;
                        TaskAttribute attribute = node.getData();
                        if (attribute != null) {
                            AbstractTaskEditorPart actionPart;
                            if ("comment".equals(attribute.getMetaData().getType()) && (actionPart = AbstractTaskEditorPage.this.getPart(AbstractTaskEditorPage.ID_PART_COMMENTS)) != null && actionPart.getControl() instanceof ExpandableComposite) {
                                EditorUtil.toggleExpandableComposite(true, (ExpandableComposite)actionPart.getControl());
                            }
                            EditorUtil.reveal(AbstractTaskEditorPage.this.form, attribute.getId());
                        } else {
                            EditorUtil.reveal(AbstractTaskEditorPage.this.form, node.getLabel());
                        }
                    }
                }
            });
        }
        if (this.getModel() != null) {
            TaskEditorOutlineNode node = TaskEditorOutlineNode.parse(this.getModel().getTaskData());
            this.outlinePage.setInput(this.getTaskRepository(), node);
        } else {
            this.outlinePage.setInput(null, null);
        }
    }

    private boolean getAttachContext() {
        AbstractTaskEditorPart actionPart = this.getPart(ID_PART_ACTIONS);
        if (actionPart instanceof TaskEditorActionPart) {
            return ((TaskEditorActionPart)actionPart).getAttachContext();
        }
        return false;
    }

    public AttributeEditorFactory getAttributeEditorFactory() {
        return this.attributeEditorFactory;
    }

    public AttributeEditorToolkit getAttributeEditorToolkit() {
        return this.attributeEditorToolkit;
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public Composite getEditorComposite() {
        return this.editorComposite;
    }

    public TaskDataModel getModel() {
        return this.model;
    }

    public AbstractTaskEditorPart getPart(String partId) {
        Assert.isNotNull((Object)partId);
        IFormPart[] iFormPartArray = this.getManagedForm().getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTaskEditorPart taskEditorPart;
            IFormPart part = iFormPartArray[n2];
            if (part instanceof AbstractTaskEditorPart && partId.equals((taskEditorPart = (AbstractTaskEditorPart)part).getPartId())) {
                return taskEditorPart;
            }
            ++n2;
        }
        return null;
    }

    public ISelection getSelection() {
        return this.lastSelection;
    }

    public ITask getTask() {
        return this.task;
    }

    public TaskEditor getTaskEditor() {
        return (TaskEditor)this.getEditor();
    }

    public TaskRepository getTaskRepository() {
        return this.getModel().getTaskRepository();
    }

    private void handleSubmitError(SubmitJob job) {
        if (this.form != null && !this.form.isDisposed()) {
            final IStatus status = job.getStatus();
            if (status.getCode() == 9) {
                TasksUiInternal.displayStatus("Comment required", status);
                AbstractTaskEditorPart newCommentPart = this.getPart(ID_PART_NEW_COMMENT);
                if (newCommentPart != null) {
                    newCommentPart.setFocus();
                }
            } else if (status.getCode() == 3) {
                if (TasksUiUtil.openEditRepositoryWizard(this.getTaskRepository()) == 0) {
                    this.doSubmit();
                }
            } else {
                String message = status.getCode() == 5 ? ERROR_NOCONNECTIVITY : (status.getMessage().length() > 0 ? "Submit failed: " + status.getMessage() : "Submit failed");
                this.getTaskEditor().setMessage(message, 3, (IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TasksUiInternal.displayStatus("Submit failed", status);
                    }
                });
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        site.setSelectionProvider((ISelectionProvider)this);
        TaskEditorInput taskEditorInput = (TaskEditorInput)input;
        this.task = taskEditorInput.getTask();
        this.defaultSelection = new StructuredSelection((Object)this.task);
        this.lastSelection = this.defaultSelection;
        this.initModel(taskEditorInput);
        TasksUiPlugin.getTaskDataManager().addListener(this.TASK_DATA_LISTENER);
    }

    private void initModel(TaskEditorInput input) {
        Assert.isTrue((this.model == null ? 1 : 0) != 0);
        try {
            this.model = this.createModel(input);
            this.connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.getConnectorKind());
            this.setTaskData(this.model.getTaskData());
            this.model.addModelListener(new TaskDataModelListener(){

                public void attributeChanged(TaskDataModelEvent event) {
                    AbstractTaskEditorPage.this.getManagedForm().dirtyStateChanged();
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error opening task", (Throwable)e));
            this.getTaskEditor().setStatus("Error opening task", "Open failed", e.getStatus());
        }
    }

    private void initializePart(Composite parent, AbstractTaskEditorPart part) {
        this.getManagedForm().addPart((IFormPart)part);
        part.initialize(this);
        part.createControl(parent, this.toolkit);
        if (part.getControl() != null) {
            if (ID_PART_ACTIONS.equals(part.getPartId())) {
                GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo(part.getControl());
            } else if (part.getExpandVertically()) {
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(part.getControl());
            } else {
                GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo(part.getControl());
            }
            if (ID_PART_COMMENTS.equals(part.getPartId())) {
                EditorUtil.setMarker((Widget)part.getControl(), "Comments");
            }
        }
    }

    public boolean isDirty() {
        return this.getModel() != null && this.getModel().isDirty() || this.getManagedForm() != null && this.getManagedForm().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean needsAddToCategory() {
        return this.needsAddToCategory;
    }

    public void reflow() {
        if (this.reflow) {
            this.form.layout(true, true);
            this.form.reflow(true);
        }
    }

    public void refreshFormContent() {
        if (this.getManagedForm().getForm().isDisposed()) {
            return;
        }
        try {
            this.showEditorBusy(true);
            if (this.model != null) {
                this.doSave((IProgressMonitor)new NullProgressMonitor());
                this.refreshInput();
            } else {
                this.initModel(this.getTaskEditor().getTaskEditorInput());
            }
            if (this.taskData != null) {
                try {
                    this.setReflow(false);
                    Menu menu = this.editorComposite.getMenu();
                    this.setMenu(this.editorComposite, null);
                    Control[] controlArray = this.editorComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    this.lastFocusControl = null;
                    this.lastSelection = null;
                    controlArray = this.getManagedForm().getParts();
                    n = controlArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Control part = controlArray[n2];
                        part.dispose();
                        this.getManagedForm().removePart((IFormPart)part);
                        ++n2;
                    }
                    this.editorComposite.setMenu(menu);
                    this.createFormContentInternal();
                    this.getTaskEditor().setMessage(null, 0);
                    this.getTaskEditor().setActivePage(this.getId());
                    this.setSubmitEnabled(true);
                }
                finally {
                    this.setReflow(true);
                }
            }
            this.updateOutlinePage();
            this.updateHeaderMessage();
            this.getManagedForm().dirtyStateChanged();
            this.getTaskEditor().updateHeaderToolBar();
        }
        finally {
            this.showEditorBusy(false);
        }
        this.reflow();
    }

    private void refreshInput() {
        try {
            try {
                this.refreshDisabled = true;
                this.model.refresh(null);
            }
            catch (CoreException e) {
                this.getTaskEditor().setMessage("Failed to read task data: " + e.getMessage(), 3);
                this.taskData = null;
                this.refreshDisabled = false;
                return;
            }
        }
        finally {
            this.refreshDisabled = false;
        }
        this.setTaskData(this.model.getTaskData());
    }

    public void registerDefaultDropListener(Control control) {
        if (this.getModel() == null || this.getModel().getTaskData().isNew()) {
            return;
        }
        DropTarget target = new DropTarget(control, 17);
        TextTransfer textTransfer = TextTransfer.getInstance();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer, fileTransfer};
        target.setTransfer(types);
        if (this.defaultDropListener == null) {
            this.defaultDropListener = new TaskAttachmentDropListener(this);
        }
        target.addDropListener((DropTargetListener)this.defaultDropListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(Object element) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(element)));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof TextSelection) {
            ((TaskEditorActionContributor)this.getEditorSite().getActionBarContributor()).updateSelectableActions(event.getSelection());
            return;
        }
        if (selection.isEmpty()) {
            selection = this.defaultSelection;
            ((TaskEditorActionContributor)this.getEditorSite().getActionBarContributor()).forceActionsEnabled();
        }
        if (!selection.equals(this.lastSelection)) {
            this.lastSelection = selection;
            this.fireSelectionChanged(this.lastSelection);
        }
    }

    public void setFocus() {
        if (this.lastFocusControl != null && !this.lastFocusControl.isDisposed()) {
            this.lastFocusControl.setFocus();
        }
    }

    private void setMenu(Composite comp, Menu menu) {
        if (!comp.isDisposed()) {
            comp.setMenu(menu);
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setMenu(menu);
                if (child instanceof Composite) {
                    this.setMenu((Composite)child, menu);
                }
                ++n2;
            }
        }
    }

    public void setNeedsAddToCategory(boolean needsAddToCategory) {
        this.needsAddToCategory = needsAddToCategory;
    }

    public void setReflow(boolean reflow) {
        this.reflow = reflow;
        this.form.setRedraw(reflow);
    }

    public void setSelection(ISelection selection) {
        IFormPart[] parts;
        IFormPart[] iFormPartArray = parts = this.getManagedForm().getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart formPart = iFormPartArray[n2];
            if (formPart instanceof AbstractTaskEditorPart && ((AbstractTaskEditorPart)formPart).setSelection(selection)) {
                this.lastSelection = selection;
                return;
            }
            ++n2;
        }
    }

    private void setSubmitEnabled(boolean enabled) {
        AbstractTaskEditorPart actionPart = this.getPart(ID_PART_ACTIONS);
        if (actionPart instanceof TaskEditorActionPart) {
            ((TaskEditorActionPart)actionPart).setSubmitEnabled(enabled);
        }
    }

    private void setTaskData(TaskData taskData) {
        this.taskData = taskData;
    }

    public void showBusy(boolean busy) {
        if (!this.getManagedForm().getForm().isDisposed() && busy != this.formBusy) {
            EditorUtil.setEnabledState(this.editorComposite, !busy);
            this.formBusy = busy;
        }
    }

    public void showEditorBusy(boolean busy) {
        this.getTaskEditor().showBusy(busy);
        this.refreshDisabled = busy;
    }

    private void updateHeaderMessage() {
        if (this.taskData == null) {
            this.getTaskEditor().setMessage("Synchronize to retrieve task data", 2, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (AbstractTaskEditorPage.this.synchronizeEditorAction != null) {
                        AbstractTaskEditorPage.this.synchronizeEditorAction.run();
                    }
                }
            });
        }
    }

    private class SubmitTaskJobListener
    extends SubmitJobListener {
        private final boolean attachContext;

        public SubmitTaskJobListener(boolean attachContext) {
            this.attachContext = attachContext;
        }

        public void done(SubmitJobEvent event) {
            final SubmitJob job = event.getJob();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                private void openNewTask(ITask newTask) {
                    AbstractTaskCategory parent = null;
                    AbstractTaskEditorPart actionPart = AbstractTaskEditorPage.this.getPart(AbstractTaskEditorPage.ID_PART_ACTIONS);
                    if (actionPart instanceof TaskEditorAttributePart) {
                        parent = ((TaskEditorActionPart)actionPart).getCategory();
                    }
                    TasksUiInternal.getTaskList().addTask(newTask, (AbstractTaskContainer)parent);
                    ITask oldTask = AbstractTaskEditorPage.this.getTask();
                    if (oldTask instanceof AbstractTask && newTask instanceof AbstractTask) {
                        ((AbstractTask)newTask).setNotes(((AbstractTask)oldTask).getNotes());
                        DateRange scheduledDate = ((AbstractTask)oldTask).getScheduledForDate();
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)newTask, scheduledDate);
                        Date dueDate = ((AbstractTask)oldTask).getDueDate();
                        TasksUiPlugin.getTaskActivityManager().setDueDate(newTask, dueDate);
                        ((AbstractTask)newTask).setEstimatedTimeHours(((AbstractTask)oldTask).getEstimatedTimeHours());
                    }
                    ContextCorePlugin.getContextStore().saveActiveContext();
                    ContextCore.getContextStore().cloneContext(oldTask.getHandleIdentifier(), newTask.getHandleIdentifier());
                    ChangeActivityHandleOperation operation = new ChangeActivityHandleOperation(oldTask.getHandleIdentifier(), newTask.getHandleIdentifier());
                    try {
                        operation.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Failed to migrate activity to new task", e.getCause()));
                    }
                    catch (InterruptedException interruptedException) {}
                    AbstractTaskEditorPage.this.close();
                    TasksUiInternal.getTaskList().deleteTask(oldTask);
                    ContextCore.getContextManager().deleteContext(oldTask.getHandleIdentifier());
                    try {
                        TasksUiPlugin.getTaskDataManager().deleteTaskData(oldTask);
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
                    }
                    TasksUiInternal.openTaskInBackground(newTask, false);
                }

                public void run() {
                    try {
                        if (job.getStatus() == null) {
                            TasksUiInternal.synchronizeRepository(AbstractTaskEditorPage.this.getTaskRepository(), false);
                            if (job.getTask().equals(AbstractTaskEditorPage.this.getTask())) {
                                AbstractTaskEditorPage.this.refreshFormContent();
                            } else {
                                this.openNewTask(job.getTask());
                            }
                        } else {
                            AbstractTaskEditorPage.this.handleSubmitError(job);
                        }
                    }
                    finally {
                        AbstractTaskEditorPage.this.showEditorBusy(false);
                    }
                }
            });
        }

        public void taskSubmitted(SubmitJobEvent event, IProgressMonitor monitor) throws CoreException {
            if (!AbstractTaskEditorPage.this.getModel().getTaskData().isNew() && this.attachContext) {
                AttachmentUtil.postContext(AbstractTaskEditorPage.this.connector, AbstractTaskEditorPage.this.getModel().getTaskRepository(), AbstractTaskEditorPage.this.task, "", null, monitor);
            }
        }

        public void taskSynchronized(SubmitJobEvent event, IProgressMonitor monitor) {
        }
    }
}

