/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.themes.IThemeManager;

public class AttributeEditorToolkit {
    private final Color colorIncoming;
    public IHandlerActivation contentAssistHandlerActivation;
    private final IHandlerService handlerService;
    private Menu menu;
    private IHandlerActivation quickAssistHandlerActivation;
    private ISelectionChangedListener selectionChangedListener;
    private AbstractRenderingEngine renderingEngine;

    AttributeEditorToolkit(IHandlerService handlerService) {
        this.handlerService = handlerService;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.colorIncoming = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.incoming.background");
    }

    private IHandlerActivation activateHandler(SourceViewer viewer, int operation, String actionDefinitionId) {
        IHandler handler = this.createActionHandler(viewer, operation, actionDefinitionId);
        return this.handlerService.activateHandler(actionDefinitionId, handler, (Expression)new ActiveShellExpression(viewer.getTextWidget().getShell()));
    }

    private void activateHandlers(SourceViewer viewer, boolean spellCheck) {
        this.deactivateHandlers();
        if (spellCheck) {
            this.quickAssistHandlerActivation = this.activateHandler(viewer, 22, "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }
        this.contentAssistHandlerActivation = this.activateHandler(viewer, 13, "org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    public void adapt(AbstractAttributeEditor editor) {
        if (editor.getControl() instanceof Text || editor.getControl() instanceof CCombo) {
            Control control = editor.getControl();
            if (!editor.isReadOnly() && this.hasContentAssist(editor.getTaskAttribute())) {
                IContentProposalProvider contentProposalProvider = this.createContentProposalProvider(editor.getTaskAttribute());
                ILabelProvider labelPropsalProvider = this.createLabelProposalProvider(editor.getTaskAttribute());
                if (contentProposalProvider != null && labelPropsalProvider != null) {
                    ContentAssistCommandAdapter adapter = this.applyContentAssist(control, contentProposalProvider);
                    adapter.setLabelProvider(labelPropsalProvider);
                    adapter.setProposalAcceptanceStyle(2);
                }
            }
        } else if (editor instanceof RichTextAttributeEditor) {
            RichTextAttributeEditor richTextEditor = (RichTextAttributeEditor)editor;
            boolean spellCheck = this.hasSpellChecking(editor.getTaskAttribute());
            final SourceViewer viewer = richTextEditor.getViewer();
            viewer.getControl().addFocusListener((FocusListener)new StyledTextFocusListener(viewer, spellCheck));
            if (this.selectionChangedListener != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
                viewer.addTextListener(new ITextListener(){

                    public void textChanged(TextEvent event) {
                        if (AttributeEditorToolkit.this.selectionChangedListener != null) {
                            AttributeEditorToolkit.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)viewer, viewer.getSelection()));
                        }
                    }
                });
            }
            if (!editor.isReadOnly() && richTextEditor.getMode() == RepositoryTextViewerConfiguration.Mode.TASK_RELATION) {
                this.applyContentAssist(viewer.getControl(), null);
            }
            this.installMenu(viewer.getControl());
            EditorUtil.setTextViewer((Widget)editor.getControl(), (TextViewer)viewer);
        } else {
            final TextViewer viewer = EditorUtil.getTextViewer((Widget)editor.getControl());
            if (viewer != null) {
                if (this.selectionChangedListener != null) {
                    viewer.addSelectionChangedListener(this.selectionChangedListener);
                    viewer.addTextListener(new ITextListener(){

                        public void textChanged(TextEvent event) {
                            if (AttributeEditorToolkit.this.selectionChangedListener != null) {
                                AttributeEditorToolkit.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)viewer, viewer.getSelection()));
                            }
                        }
                    });
                }
                this.installMenu(viewer.getControl());
            }
        }
        EditorUtil.setMarker((Widget)editor.getControl(), editor.getTaskAttribute().getId());
        editor.decorate(this.getColorIncoming());
    }

    private void installMenu(final Control control) {
        if (this.menu != null) {
            control.setMenu(this.menu);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    control.setMenu(null);
                }
            });
        }
    }

    private ContentAssistCommandAdapter applyContentAssist(Control control, IContentProposalProvider proposalProvider) {
        ControlDecoration controlDecoration = new ControlDecoration(control, 16512);
        controlDecoration.setMarginWidth(0);
        controlDecoration.setShowHover(true);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        controlDecoration.setDescriptionText(NLS.bind((String)"Content Assist Available ({0})", (Object)bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals")));
        if (proposalProvider != null) {
            TextContentAdapter textContentAdapter = new TextContentAdapter();
            ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter(control, (IControlContentAdapter)textContentAdapter, proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0]);
            return adapter;
        }
        return null;
    }

    private IHandler createActionHandler(final SourceViewer viewer, final int operation, String actionDefinitionId) {
        Action quickFixAction = new Action(){

            public void run() {
                if (viewer.canDoOperation(operation)) {
                    viewer.doOperation(operation);
                }
            }
        };
        quickFixAction.setActionDefinitionId(actionDefinitionId);
        return new ActionHandler((IAction)quickFixAction);
    }

    private IContentProposalProvider createContentProposalProvider(TaskAttribute attribute) {
        return new PersonProposalProvider(null, attribute.getTaskData());
    }

    private ILabelProvider createLabelProposalProvider(TaskAttribute attribute) {
        return new PersonProposalLabelProvider();
    }

    private void deactivateHandlers() {
        if (this.quickAssistHandlerActivation != null) {
            this.handlerService.deactivateHandler(this.quickAssistHandlerActivation);
            this.quickAssistHandlerActivation = null;
        }
        if (this.contentAssistHandlerActivation != null) {
            this.handlerService.deactivateHandler(this.contentAssistHandlerActivation);
            this.contentAssistHandlerActivation = null;
        }
    }

    void dispose() {
        this.deactivateHandlers();
    }

    public Color getColorIncoming() {
        return this.colorIncoming;
    }

    Menu getMenu() {
        return this.menu;
    }

    public AbstractRenderingEngine getRenderingEngine(TaskAttribute attribute) {
        return this.renderingEngine;
    }

    ISelectionChangedListener getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    private boolean hasContentAssist(TaskAttribute taskAttribute) {
        String type = taskAttribute.getMetaData().getType();
        if ("person".equals(type)) {
            return true;
        }
        return "taskDepenedency".equals(type);
    }

    boolean hasSpellChecking(TaskAttribute taskAttribute) {
        String type = taskAttribute.getMetaData().getType();
        return "longRichText".equals(type) || "shortRichText".equals(type);
    }

    void setMenu(Menu menu) {
        this.menu = menu;
    }

    void setSelectionChangedListener(ISelectionChangedListener selectionListener) {
        this.selectionChangedListener = selectionListener;
    }

    public void setRenderingEngine(AbstractRenderingEngine renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    private class StyledTextFocusListener
    implements FocusListener {
        private final boolean spellCheck;
        private final SourceViewer viewer;

        public StyledTextFocusListener(SourceViewer viewer, boolean spellCheck) {
            this.viewer = viewer;
            this.spellCheck = spellCheck;
        }

        public void focusGained(FocusEvent e) {
            if (AttributeEditorToolkit.this.selectionChangedListener != null) {
                AttributeEditorToolkit.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, this.viewer.getSelection()));
            }
            AttributeEditorToolkit.this.activateHandlers(this.viewer, this.spellCheck);
        }

        public void focusLost(FocusEvent e) {
            AttributeEditorToolkit.this.deactivateHandlers();
            if (AttributeEditorToolkit.this.selectionChangedListener != null) {
                StyledText st = (StyledText)e.widget;
                st.setSelectionRange(st.getCaretOffset(), 0);
                AttributeEditorToolkit.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, (ISelection)StructuredSelection.EMPTY));
            }
        }
    }
}

