/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import java.util.Date;
import java.util.Map;
import org.eclipse.mylyn.internal.jira.core.JiraAttribute;
import org.eclipse.mylyn.internal.jira.core.JiraRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class JiraTaskMapper
extends TaskMapper {
    public JiraTaskMapper(TaskData taskData) {
        super(taskData);
    }

    public ITask.PriorityLevel getPriorityLevel() {
        TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(JiraAttribute.PRIORITY.id());
        if (attribute != null) {
            return JiraRepositoryConnector.getPriorityLevel(attribute.getValue());
        }
        return ITask.PriorityLevel.getDefault();
    }

    public Date getCompletionDate() {
        if (JiraRepositoryConnector.isCompleted(this.getTaskData())) {
            return this.getModificationDate();
        }
        return null;
    }

    public void setCompletionDate(Date dateCompleted) {
    }

    public void setComponent(String component) {
        TaskAttribute attribute = this.getTaskData().getRoot().getAttribute(JiraAttribute.COMPONENTS.id());
        if (attribute != null && !attribute.getMetaData().isReadOnly()) {
            for (Map.Entry entry : attribute.getOptions().entrySet()) {
                if (!((String)entry.getValue()).equals(component)) continue;
                attribute.setValue((String)entry.getKey());
            }
        }
    }

    public void setProduct(String product) {
    }
}

