/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.Group;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.User;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteComponent;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteFilter;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteGroup;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssueType;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemotePriority;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteProject;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteResolution;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteServerInfo;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteStatus;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteUser;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteVersion;

class JiraSoapConverter {
    JiraSoapConverter() {
    }

    protected static Priority[] convert(RemotePriority[] remotePriorities) {
        Priority[] priorities = new Priority[remotePriorities.length];
        int i = 0;
        while (i < remotePriorities.length) {
            priorities[i] = JiraSoapConverter.convert(remotePriorities[i]);
            ++i;
        }
        return priorities;
    }

    protected static Priority convert(RemotePriority remotePriority) {
        Priority priority = new Priority();
        priority.setColour(remotePriority.getColor());
        priority.setDescription(remotePriority.getDescription());
        priority.setIcon(remotePriority.getIcon());
        priority.setId(remotePriority.getId());
        priority.setName(remotePriority.getName());
        return priority;
    }

    protected static JiraStatus[] convert(RemoteStatus[] remoteStatuses) {
        JiraStatus[] statuses = new JiraStatus[remoteStatuses.length];
        int i = 0;
        while (i < remoteStatuses.length) {
            statuses[i] = JiraSoapConverter.convert(remoteStatuses[i]);
            ++i;
        }
        return statuses;
    }

    protected static JiraStatus convert(RemoteStatus remoteStatus) {
        JiraStatus status = new JiraStatus();
        status.setDescription(remoteStatus.getDescription());
        status.setIcon(remoteStatus.getIcon());
        status.setId(remoteStatus.getId());
        status.setName(remoteStatus.getName());
        return status;
    }

    protected static Version[] convert(RemoteVersion[] remoteVersions) {
        Version[] versions = new Version[remoteVersions.length];
        int i = 0;
        while (i < remoteVersions.length) {
            versions[i] = JiraSoapConverter.convert(remoteVersions[i]);
            ++i;
        }
        return versions;
    }

    protected static Version convert(RemoteVersion remoteVersion) {
        Version version = new Version();
        version.setArchived(remoteVersion.isArchived());
        version.setId(remoteVersion.getId());
        version.setName(remoteVersion.getName());
        version.setReleased(remoteVersion.isReleased());
        version.setReleaseDate(remoteVersion.getReleaseDate() != null ? remoteVersion.getReleaseDate().getTime() : null);
        version.setSequence(remoteVersion.getSequence());
        return version;
    }

    protected static Resolution[] convert(RemoteResolution[] remoteResolutions) {
        Resolution[] resolutions = new Resolution[remoteResolutions.length];
        int i = 0;
        while (i < remoteResolutions.length) {
            resolutions[i] = JiraSoapConverter.convert(remoteResolutions[i]);
            ++i;
        }
        return resolutions;
    }

    protected static Resolution convert(RemoteResolution remoteResolution) {
        Resolution resolution = new Resolution();
        resolution.setDescription(remoteResolution.getDescription());
        resolution.setIcon(remoteResolution.getIcon());
        resolution.setId(remoteResolution.getId());
        resolution.setName(remoteResolution.getName());
        return resolution;
    }

    protected static IssueType[] convert(RemoteIssueType[] remoteIssueTypes) {
        IssueType[] issueTypes = new IssueType[remoteIssueTypes.length];
        int i = 0;
        while (i < remoteIssueTypes.length) {
            issueTypes[i] = JiraSoapConverter.convert(remoteIssueTypes[i]);
            ++i;
        }
        return issueTypes;
    }

    protected static IssueType convert(RemoteIssueType remoteIssueType) {
        IssueType issueType = new IssueType();
        issueType.setDescription(remoteIssueType.getDescription());
        issueType.setIcon(remoteIssueType.getIcon());
        issueType.setId(remoteIssueType.getId());
        issueType.setName(remoteIssueType.getName());
        return issueType;
    }

    protected static Project[] convert(RemoteProject[] remoteProjects) {
        Project[] projects = new Project[remoteProjects.length];
        int i = 0;
        while (i < remoteProjects.length) {
            projects[i] = JiraSoapConverter.convert(remoteProjects[i]);
            ++i;
        }
        return projects;
    }

    protected static Project convert(RemoteProject remoteProject) {
        Project project = new Project();
        project.setDescription(remoteProject.getDescription());
        project.setId(remoteProject.getId());
        project.setKey(remoteProject.getKey());
        project.setLead(remoteProject.getLead());
        project.setName(remoteProject.getName());
        project.setProjectUrl(remoteProject.getProjectUrl());
        project.setUrl(remoteProject.getUrl());
        return project;
    }

    protected static Component[] convert(RemoteComponent[] remoteComponents) {
        Component[] components = new Component[remoteComponents.length];
        int i = 0;
        while (i < remoteComponents.length) {
            components[i] = JiraSoapConverter.convert(remoteComponents[i]);
            ++i;
        }
        return components;
    }

    protected static Component convert(RemoteComponent remoteComponent) {
        Component component = new Component();
        component.setId(remoteComponent.getId());
        component.setName(remoteComponent.getName());
        return component;
    }

    protected static User[] convert(RemoteUser[] remoteUsers) {
        User[] users = new User[remoteUsers.length];
        int i = 0;
        while (i < remoteUsers.length) {
            users[i] = JiraSoapConverter.convert(remoteUsers[i]);
            ++i;
        }
        return users;
    }

    protected static User convert(RemoteUser remoteUser) {
        User user = new User();
        user.setEmail(remoteUser.getEmail());
        user.setFullName(remoteUser.getFullname());
        user.setName(remoteUser.getName());
        return user;
    }

    protected static Group[] convert(RemoteGroup[] remoteGroups) {
        Group[] groups = new Group[remoteGroups.length];
        int i = 0;
        while (i < remoteGroups.length) {
            groups[i] = JiraSoapConverter.convert(remoteGroups[i]);
            ++i;
        }
        return groups;
    }

    protected static Group convert(RemoteGroup remoteGroup) {
        Group group = new Group();
        group.setName(remoteGroup.getName());
        group.setUsers(JiraSoapConverter.convert(remoteGroup.getUsers()));
        return group;
    }

    protected static ServerInfo convert(RemoteServerInfo remoteServerInfo) {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setBaseUrl(remoteServerInfo.getBaseUrl());
        serverInfo.setBuildDate(remoteServerInfo.getBuildDate().getTime());
        serverInfo.setBuildNumber(remoteServerInfo.getBuildNumber());
        serverInfo.setEdition(remoteServerInfo.getEdition());
        serverInfo.setVersion(remoteServerInfo.getVersion());
        return serverInfo;
    }

    public static NamedFilter[] convert(RemoteFilter[] savedFilters) {
        NamedFilter[] namedFilters = new NamedFilter[savedFilters.length];
        int i = 0;
        while (i < savedFilters.length) {
            RemoteFilter savedFilter = savedFilters[i];
            NamedFilter filter = new NamedFilter();
            filter.setId(savedFilter.getId());
            filter.setName(savedFilter.getName());
            filter.setAuthor(savedFilter.getAuthor());
            filter.setDescription(savedFilter.getDescription());
            filter.setProject(savedFilter.getProject());
            namedFilters[i] = filter;
            ++i;
        }
        return namedFilters;
    }
}

