/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.net.HtmlTag;
import org.eclipse.mylyn.internal.jira.core.JiraFieldType;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.JiraIssue;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.WebServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteException;
import org.eclipse.mylyn.internal.jira.core.service.JiraRemoteMessageException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSession;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssHandler;

public class JiraWebClient {
    private final JiraClient client;

    public JiraWebClient(JiraClient client) {
        this.client = client;
    }

    public void addCommentToIssue(final JiraIssue issue, final String comment, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient client, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/AddComment.jspa");
                PostMethod post = new PostMethod(rssUrlBuffer.toString());
                post.setRequestHeader("Content-Type", JiraWebClient.this.getContentType());
                post.addParameter("comment", comment);
                post.addParameter("commentLevel", "");
                post.addParameter("id", issue.getId());
                try {
                    this.execute((HttpMethod)post);
                    if (!this.expectRedirect((HttpMethodBase)post, issue)) {
                        JiraWebClient.this.handleErrorMessage((HttpMethodBase)post);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    private String getContentType() throws JiraException {
        return "application/x-www-form-urlencoded; charset=" + this.client.getCharacterEncoding();
    }

    public void updateIssue(final JiraIssue issue, final String comment, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient client, String baseUrl, IProgressMonitor monitor) throws JiraException {
                Version[] fixVersions;
                Version[] versions;
                int n;
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/EditIssue.jspa");
                PostMethod post = new PostMethod(rssUrlBuffer.toString());
                post.setRequestHeader("Content-Type", JiraWebClient.this.getContentType());
                post.addParameter("summary", issue.getSummary());
                post.addParameter("issuetype", issue.getType().getId());
                if (issue.getPriority() != null) {
                    post.addParameter("priority", issue.getPriority().getId());
                }
                JiraWebClient.this.addFields(client, issue, post, new String[]{"duedate"});
                post.addParameter("timetracking", String.valueOf(Long.toString(issue.getEstimate() / 60L)) + "m");
                Component[] components = issue.getComponents();
                if (components != null) {
                    if (components.length == 0) {
                        post.addParameter("components", "-1");
                    } else {
                        Component[] componentArray = components;
                        n = components.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component component = componentArray[n2];
                            post.addParameter("components", component.getId());
                            ++n2;
                        }
                    }
                }
                if ((versions = issue.getReportedVersions()) != null) {
                    if (versions.length == 0) {
                        post.addParameter("versions", "-1");
                    } else {
                        Version[] versionArray = versions;
                        int n3 = versions.length;
                        n = 0;
                        while (n < n3) {
                            Version version = versionArray[n];
                            post.addParameter("versions", version.getId());
                            ++n;
                        }
                    }
                }
                if ((fixVersions = issue.getFixVersions()) != null) {
                    if (fixVersions.length == 0) {
                        post.addParameter("fixVersions", "-1");
                    } else {
                        Version[] versionArray = fixVersions;
                        int n4 = fixVersions.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Version fixVersion = versionArray[n5];
                            post.addParameter("fixVersions", fixVersion.getId());
                            ++n5;
                        }
                    }
                }
                if (issue.getAssignee() != null) {
                    post.addParameter("assignee", issue.getAssignee());
                } else {
                    post.addParameter("assignee", "-1");
                }
                if (issue.getReporter() != null) {
                    post.addParameter("reporter", issue.getReporter());
                }
                if (issue.getEnvironment() != null) {
                    post.addParameter("environment", issue.getEnvironment());
                }
                post.addParameter("description", issue.getDescription());
                if (comment != null) {
                    post.addParameter("comment", comment);
                }
                post.addParameter("commentLevel", "");
                post.addParameter("id", issue.getId());
                if (issue.getSecurityLevel() != null) {
                    post.addParameter("security", issue.getSecurityLevel().getId());
                }
                JiraWebClient.this.addCustomFields(client, issue, post);
                try {
                    this.execute((HttpMethod)post);
                    if (!this.expectRedirect((HttpMethodBase)post, issue)) {
                        JiraWebClient.this.handleErrorMessage((HttpMethodBase)post);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void assignIssueTo(final JiraIssue issue, final int assigneeType, final String user, final String comment, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/AssignIssue.jspa");
                PostMethod post = new PostMethod(rssUrlBuffer.toString());
                post.setRequestHeader("Content-Type", JiraWebClient.this.getContentType());
                post.addParameter("assignee", JiraWebClient.this.getAssigneeParam(server, issue, assigneeType, user));
                if (comment != null) {
                    post.addParameter("comment", comment);
                }
                post.addParameter("commentLevel", "");
                post.addParameter("id", issue.getId());
                try {
                    this.execute((HttpMethod)post);
                    if (!this.expectRedirect((HttpMethodBase)post, issue)) {
                        JiraWebClient.this.handleErrorMessage((HttpMethodBase)post);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void advanceIssueWorkflow(final JiraIssue issue, final String actionKey, final String comment, final String[] fields, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                PostMethod post = new PostMethod(String.valueOf(baseUrl) + "/secure/CommentAssignIssue.jspa");
                post.setRequestHeader("Content-Type", JiraWebClient.this.getContentType());
                post.addParameter("id", issue.getId());
                post.addParameter("action", actionKey);
                if (comment != null) {
                    post.addParameter("comment", comment);
                }
                post.addParameter("commentLevel", "");
                JiraWebClient.this.addFields(server, issue, post, fields);
                try {
                    this.execute((HttpMethod)post);
                    if (!this.expectRedirect((HttpMethodBase)post, issue)) {
                        JiraWebClient.this.handleErrorMessage((HttpMethodBase)post);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void attachFile(JiraIssue issue, String comment, PartSource partSource, String contentType, IProgressMonitor monitor) throws JiraException {
        this.attachFile(issue, comment, new FilePart("filename.1", partSource), contentType, monitor);
    }

    public void attachFile(JiraIssue issue, String comment, String filename, byte[] contents, String contentType, IProgressMonitor monitor) throws JiraException {
        this.attachFile(issue, comment, new FilePart("filename.1", (PartSource)new ByteArrayPartSource(filename, contents)), contentType, monitor);
    }

    public void attachFile(JiraIssue issue, String comment, String filename, File file, String contentType, IProgressMonitor monitor) throws JiraException {
        try {
            FilePartSource partSource = new FilePartSource(filename, file);
            this.attachFile(issue, comment, new FilePart("filename.1", (PartSource)partSource), contentType, monitor);
        }
        catch (FileNotFoundException e) {
            throw new JiraException(e);
        }
    }

    public void attachFile(final JiraIssue issue, final String comment, final FilePart filePart, final String contentType, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder attachFileURLBuffer = new StringBuilder(baseUrl);
                attachFileURLBuffer.append("/secure/AttachFile.jspa");
                PostMethod post = new PostMethod(attachFileURLBuffer.toString());
                ArrayList<Object> parts = new ArrayList<Object>();
                StringPart idPart = new StringPart("id", issue.getId());
                StringPart commentLevelPart = new StringPart("commentLevel", "");
                idPart.setTransferEncoding(null);
                idPart.setContentType(null);
                if (comment != null) {
                    StringPart commentPart = new StringPart("comment", comment);
                    commentPart.setTransferEncoding(null);
                    commentPart.setContentType(null);
                    parts.add(commentPart);
                }
                commentLevelPart.setTransferEncoding(null);
                commentLevelPart.setContentType(null);
                filePart.setTransferEncoding(null);
                if (contentType != null) {
                    filePart.setContentType(contentType);
                }
                parts.add(filePart);
                parts.add(idPart);
                parts.add(commentLevelPart);
                post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), post.getParams()));
                try {
                    this.execute((HttpMethod)post);
                    if (!this.expectRedirect((HttpMethodBase)post, "/secure/ManageAttachments.jspa?id=" + issue.getId())) {
                        JiraWebClient.this.handleErrorMessage((HttpMethodBase)post);
                    }
                }
                finally {
                    post.releaseConnection();
                }
            }
        });
    }

    public void retrieveFile(JiraIssue issue, final Attachment attachment, final byte[] attachmentData, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/attachment/");
                rssUrlBuffer.append(attachment.getId());
                rssUrlBuffer.append("/");
                try {
                    rssUrlBuffer.append(URLEncoder.encode(attachment.getName(), server.getCharacterEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new JiraException(e);
                }
                GetMethod get = new GetMethod(rssUrlBuffer.toString());
                try {
                    try {
                        int result = this.execute((HttpMethod)get);
                        if (result != 200) {
                            JiraWebClient.this.handleErrorMessage((HttpMethodBase)get);
                        } else {
                            byte[] data = get.getResponseBody();
                            if (data.length != attachmentData.length) {
                                throw new IOException("Unexpected attachment size (got " + data.length + ", expected " + attachmentData.length + ")");
                            }
                            System.arraycopy(data, 0, attachmentData, 0, attachmentData.length);
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    get.releaseConnection();
                }
            }
        });
    }

    public void retrieveFile(JiraIssue issue, final Attachment attachment, final OutputStream out, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/attachment/");
                rssUrlBuffer.append(attachment.getId());
                rssUrlBuffer.append("/");
                try {
                    rssUrlBuffer.append(URLEncoder.encode(attachment.getName(), server.getCharacterEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new JiraException(e);
                }
                GetMethod get = new GetMethod(rssUrlBuffer.toString());
                try {
                    try {
                        int result = this.execute((HttpMethod)get);
                        if (result != 200) {
                            JiraWebClient.this.handleErrorMessage((HttpMethodBase)get);
                        } else {
                            out.write(get.getResponseBody());
                        }
                    }
                    catch (IOException e) {
                        throw new JiraException(e);
                    }
                }
                finally {
                    get.releaseConnection();
                }
            }
        });
    }

    public String createIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        return this.createIssue("/secure/CreateIssueDetails.jspa", issue, monitor);
    }

    public String createSubTask(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        return this.createIssue("/secure/CreateSubTaskIssueDetails.jspa", issue, monitor);
    }

    private String createIssue(final String url, final JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        final String[] issueKey = new String[1];
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient client, String baseUrl, IProgressMonitor monitor) throws JiraException {
                block20: {
                    int i;
                    StringBuilder attachFileURLBuffer = new StringBuilder(baseUrl);
                    attachFileURLBuffer.append(url);
                    PostMethod post = new PostMethod(attachFileURLBuffer.toString());
                    post.setRequestHeader("Content-Type", JiraWebClient.this.getContentType());
                    post.addParameter("pid", issue.getProject().getId());
                    post.addParameter("issuetype", issue.getType().getId());
                    post.addParameter("summary", issue.getSummary());
                    if (issue.getPriority() != null) {
                        post.addParameter("priority", issue.getPriority().getId());
                    }
                    JiraWebClient.this.addFields(client, issue, post, new String[]{"duedate"});
                    post.addParameter("timetracking", String.valueOf(Long.toString(issue.getEstimate() / 60L)) + "m");
                    if (issue.getComponents() != null) {
                        i = 0;
                        while (i < issue.getComponents().length) {
                            post.addParameter("components", issue.getComponents()[i].getId());
                            ++i;
                        }
                    } else {
                        post.addParameter("components", "-1");
                    }
                    if (issue.getReportedVersions() != null) {
                        i = 0;
                        while (i < issue.getReportedVersions().length) {
                            post.addParameter("versions", issue.getReportedVersions()[i].getId());
                            ++i;
                        }
                    } else {
                        post.addParameter("versions", "-1");
                    }
                    if (issue.getFixVersions() != null) {
                        i = 0;
                        while (i < issue.getFixVersions().length) {
                            post.addParameter("fixVersions", issue.getFixVersions()[i].getId());
                            ++i;
                        }
                    } else {
                        post.addParameter("fixVersions", "-1");
                    }
                    if (issue.getAssignee() == null) {
                        post.addParameter("assignee", "-1");
                    } else if (issue.getAssignee().length() == 0) {
                        post.addParameter("assignee", "");
                    } else {
                        post.addParameter("assignee", issue.getAssignee());
                    }
                    post.addParameter("reporter", client.getUserName());
                    post.addParameter("environment", issue.getEnvironment() != null ? issue.getEnvironment() : "");
                    post.addParameter("description", issue.getDescription() != null ? issue.getDescription() : "");
                    if (issue.getParentId() != null) {
                        post.addParameter("parentIssueId", issue.getParentId());
                    }
                    JiraWebClient.this.addCustomFields(client, issue, post);
                    try {
                        this.execute((HttpMethod)post);
                        if (!this.expectRedirect((HttpMethodBase)post, "/browse/", false)) {
                            JiraWebClient.this.handleErrorMessage((HttpMethodBase)post);
                            break block20;
                        }
                        Header locationHeader = post.getResponseHeader("location");
                        String location = locationHeader.getValue();
                        int i2 = location.lastIndexOf("/");
                        if (i2 != -1) {
                            issueKey[0] = location.substring(i2 + 1);
                            break block20;
                        }
                        throw new JiraException("The server redirected to an unexpected location while creating an issue: " + location);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }
            }
        });
        assert (issueKey[0] != null);
        return issueKey[0];
    }

    public void watchIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.watchUnwatchIssue(issue, true, monitor);
    }

    public void unwatchIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.watchUnwatchIssue(issue, false, monitor);
    }

    private void watchUnwatchIssue(final JiraIssue issue, final boolean watch, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder urlBuffer = new StringBuilder(baseUrl);
                urlBuffer.append("/browse/").append(issue.getKey());
                urlBuffer.append("?watch=").append(Boolean.toString(watch));
                HeadMethod head = new HeadMethod(urlBuffer.toString());
                try {
                    int result = this.execute((HttpMethod)head);
                    if (result != 200) {
                        throw new JiraException("Changing watch status failed. Return code: " + result);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
        });
    }

    public void voteIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.voteUnvoteIssue(issue, true, monitor);
    }

    public void unvoteIssue(JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.voteUnvoteIssue(issue, false, monitor);
    }

    private void voteUnvoteIssue(final JiraIssue issue, final boolean vote, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder urlBuffer = new StringBuilder(baseUrl);
                urlBuffer.append("/browse/").append(issue.getKey());
                urlBuffer.append("?vote=").append(vote ? "vote" : "unvote");
                HeadMethod head = new HeadMethod(urlBuffer.toString());
                try {
                    int result = this.execute((HttpMethod)head);
                    if (result != 200) {
                        throw new JiraException("Changing vote failed. Return code: " + result);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
        });
    }

    public void deleteIssue(final JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                StringBuilder urlBuffer = new StringBuilder(baseUrl);
                urlBuffer.append("/secure/DeleteIssue.jspa");
                urlBuffer.append("?id=").append(issue.getId());
                urlBuffer.append("&confirm=true");
                HeadMethod head = new HeadMethod(urlBuffer.toString());
                try {
                    int result = this.execute((HttpMethod)head);
                    if (result != 200) {
                        throw new JiraException("Deleting issue failed. Return code: " + result);
                    }
                }
                finally {
                    head.releaseConnection();
                }
            }
        });
    }

    public WebServerInfo getWebServerInfo(IProgressMonitor monitor) throws JiraException {
        final WebServerInfo webServerInfo = new WebServerInfo();
        final JiraWebSession s = new JiraWebSession(this.client);
        s.setLogEnabled(true);
        s.doInSession(new JiraWebSessionCallback(){

            public void run(JiraClient server, String baseUrl, IProgressMonitor monitor) throws JiraException {
                webServerInfo.setBaseUrl(s.getBaseURL());
                webServerInfo.setCharacterEncoding(s.getCharacterEncoding());
                webServerInfo.setInsecureRedirect(s.isInsecureRedirect());
            }
        }, monitor);
        return webServerInfo;
    }

    private String getAssigneeParam(JiraClient server, JiraIssue issue, int assigneeType, String user) {
        switch (assigneeType) {
            case 2: {
                return issue.getAssignee();
            }
            case 1: {
                return "-1";
            }
            case 3: {
                return "";
            }
            case 5: {
                return server.getUserName();
            }
            case 4: {
                return user;
            }
        }
        return user;
    }

    protected void handleErrorMessage(HttpMethodBase method) throws JiraException {
        try {
            String response = method.getResponseBodyAsString();
            if (method.getStatusCode() == 503) {
                throw new JiraRemoteException("JIRA system error", null);
            }
            if (response == null) {
                throw new JiraRemoteMessageException("Error making JIRA request: " + method.getStatusCode(), "");
            }
            StringReader reader = new StringReader(response);
            try {
                try {
                    StringBuilder msg = new StringBuilder();
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                    HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                    while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                        HtmlTag tag;
                        String classValue;
                        if (token.getType() == HtmlStreamTokenizer.Token.TAG && (classValue = (tag = (HtmlTag)token.getValue()).getAttribute("class")) != null) {
                            if (tag.getTagType() == HtmlTag.Type.DIV) {
                                if (classValue.startsWith("infoBox")) {
                                    throw new JiraRemoteMessageException(this.getContent(tokenizer, HtmlTag.Type.DIV));
                                }
                                if (classValue.startsWith("errorArea")) {
                                    throw new JiraRemoteMessageException(this.getContent(tokenizer, HtmlTag.Type.DIV));
                                }
                            } else if (tag.getTagType() == HtmlTag.Type.SPAN && classValue.startsWith("errMsg")) {
                                msg.append(this.getContent(tokenizer, HtmlTag.Type.SPAN));
                            }
                        }
                        token = tokenizer.nextToken();
                    }
                    if (msg.length() == 0) {
                        throw new JiraRemoteMessageException(response);
                    }
                    throw new JiraRemoteMessageException(msg.toString());
                }
                catch (ParseException parseException) {
                    throw new JiraRemoteMessageException("Error parsing JIRA response: " + method.getStatusCode(), "");
                }
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JiraException(e);
        }
    }

    private String getContent(HtmlStreamTokenizer tokenizer, HTML.Tag closingTag) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            HtmlTag tag;
            if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == closingTag) {
                if (tag.isEndTag()) {
                    if (count == 0) break;
                    --count;
                } else {
                    ++count;
                }
            }
            sb.append(token.toString());
            token = tokenizer.nextToken();
        }
        return sb.toString();
    }

    private void addCustomFields(JiraClient client, JiraIssue issue, PostMethod post) {
        CustomField[] customFieldArray = issue.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField customField = customFieldArray[n2];
            this.addCustomField(client, post, customField);
            ++n2;
        }
    }

    private void addCustomField(JiraClient client, PostMethod post, CustomField customField) {
        for (String value : customField.getValues()) {
            String key = customField.getKey();
            if (!this.includeCustomField(key)) continue;
            if (value != null && (JiraFieldType.DATE.getKey().equals(key) || JiraFieldType.DATETIME.getKey().equals(key))) {
                try {
                    Date date = JiraRssHandler.getDateTimeFormat().parse(value);
                    DateFormat format = JiraFieldType.DATE.getKey().equals(key) ? client.getConfiguration().getDateFormat() : client.getConfiguration().getDateTimeFormat();
                    value = format.format(date);
                }
                catch (ParseException parseException) {}
            }
            post.addParameter(customField.getId(), value == null ? "" : value);
        }
    }

    private void addFields(JiraClient client, JiraIssue issue, PostMethod post, String[] fields) {
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String field = stringArray[n2];
            if ("duedate".equals(field)) {
                if (issue.getDue() != null) {
                    DateFormat format = client.getConfiguration().getDateFormat();
                    post.addParameter("duedate", format.format(issue.getDue()));
                } else {
                    post.addParameter("duedate", "");
                }
            } else if (field.startsWith("customfield_")) {
                CustomField[] customFieldArray = issue.getCustomFields();
                n3 = customFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CustomField customField = customFieldArray[n4];
                    this.addCustomField(client, post, customField);
                    ++n4;
                }
            } else {
                String[] values = issue.getFieldValues(field);
                if (values != null) {
                    String[] stringArray2 = values;
                    int n5 = values.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String value = stringArray2[n3];
                        post.addParameter(field, value);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    private boolean includeCustomField(String key) {
        return key == null || !key.startsWith("com.atlassian.jira.toolkit") && !key.startsWith("com.atlassian.jira.ext.charting");
    }

    private void doInSession(IProgressMonitor monitor, JiraWebSessionCallback callback) throws JiraException {
        JiraWebSession session = new JiraWebSession(this.client);
        session.doInSession(callback, monitor);
    }
}

