/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.internal.jira.core.service.web.JiraWebSessionCallback;

public class JiraWebSession {
    private static final int MAX_REDIRECTS = 3;
    private final JiraClient client;
    private String baseUrl;
    private String characterEncoding;
    private final boolean secure;
    private boolean insecureRedirect;
    private boolean logEnabled;
    private final AbstractWebLocation location;
    protected static final String USER_AGENT = "JiraConnector";
    private static final Object SESSION_ID_COOKIE = "JSESSIONID";

    public JiraWebSession(JiraClient client, String baseUrl) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.secure = baseUrl.startsWith("https");
        this.location = client.getLocation();
    }

    public JiraWebSession(JiraClient client) {
        this(client, client.getBaseUrl());
    }

    public void doInSession(JiraWebSessionCallback callback, IProgressMonitor monitor) throws JiraException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
        try {
            HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
            HostConfiguration hostConfiguration = this.login(httpClient, monitor);
            try {
                try {
                    callback.configure(httpClient, hostConfiguration, this.baseUrl, this.client.getConfiguration().getFollowRedirects());
                    callback.run(this.client, this.baseUrl, monitor);
                }
                catch (IOException e) {
                    throw new JiraException(e);
                }
            }
            finally {
                this.logout(httpClient, hostConfiguration, monitor);
            }
        }
        finally {
            connectionManager.shutdown();
        }
    }

    protected String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected String getBaseURL() {
        return this.baseUrl;
    }

    protected boolean isInsecureRedirect() {
        return this.insecureRedirect;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected boolean isLogEnabled() {
        return this.logEnabled;
    }

    protected void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    private HostConfiguration login(HttpClient httpClient, IProgressMonitor monitor) throws JiraException {
        RedirectTracker tracker = new RedirectTracker();
        String url = String.valueOf(this.baseUrl) + "/login.jsp";
        int i = 0;
        while (i <= 3) {
            block13: {
                AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
                if (credentials == null) {
                    credentials = new AuthenticationCredentials("", "");
                }
                PostMethod login = new PostMethod(url);
                login.setFollowRedirects(false);
                login.getParams().setCookiePolicy("compatibility");
                login.addParameter("os_username", credentials.getUserName());
                login.addParameter("os_password", credentials.getPassword());
                login.addParameter("os_destination", "/success");
                tracker.addUrl(url);
                try {
                    HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
                    int statusCode = WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)login, (IProgressMonitor)monitor);
                    if (this.needsReauthentication(httpClient, statusCode, monitor)) break block13;
                    if (statusCode != 302 && statusCode != 301) {
                        throw new JiraServiceUnavailableException("Unexpected status code during login: " + statusCode);
                    }
                    tracker.addRedirect(url, (HttpMethodBase)login, statusCode);
                    this.characterEncoding = login.getResponseCharSet();
                    Header locationHeader = login.getResponseHeader("location");
                    if (locationHeader == null) {
                        throw new JiraServiceUnavailableException("Invalid redirect, missing location");
                    }
                    url = locationHeader.getValue();
                    tracker.checkForCircle(url);
                    if (!this.insecureRedirect && this.isSecure() && url.startsWith("http://")) {
                        tracker.log("Redirect to insecure location during login to repository: " + this.client.getBaseUrl());
                        this.insecureRedirect = true;
                    }
                    if (!url.endsWith("/success")) break block13;
                    String newBaseUrl = url.substring(0, url.lastIndexOf("/success"));
                    if (this.baseUrl.equals(newBaseUrl) || !this.client.getConfiguration().getFollowRedirects()) {
                        this.addAuthenticationCookie(httpClient, login);
                        HostConfiguration hostConfiguration2 = hostConfiguration;
                        return hostConfiguration2;
                    }
                    try {
                        this.baseUrl = newBaseUrl;
                        url = String.valueOf(newBaseUrl) + "/login.jsp";
                    }
                    catch (IOException e) {
                        throw new JiraServiceUnavailableException(e);
                    }
                }
                finally {
                    login.releaseConnection();
                }
            }
            ++i;
        }
        tracker.log("Exceeded maximum number of allowed redirects during login to repository: " + this.client.getBaseUrl());
        throw new JiraServiceUnavailableException("Exceeded maximum number of allowed redirects during login");
    }

    private void addAuthenticationCookie(HttpClient httpClient, PostMethod method) {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (SESSION_ID_COOKIE.equals(cookie.getName())) {
                return;
            }
            ++n2;
        }
        cookieArray = method.getResponseHeaders();
        n = cookieArray.length;
        n2 = 0;
        while (n2 < n) {
            Cookie header = cookieArray[n2];
            if (header.getName().equalsIgnoreCase("Set-Cookie")) {
                int i;
                String cookie = header.getValue();
                int index = cookie.indexOf(59);
                if (index != -1) {
                    cookie = cookie.substring(0, index);
                }
                String key = (i = cookie.indexOf("=")) != -1 ? cookie.substring(0, i) : cookie;
                cookie = i != -1 ? cookie.substring(i + 1) : "";
                httpClient.getState().addCookie(new Cookie(WebUtil.getHost((String)this.baseUrl), key, cookie, WebUtil.getRequestPath((String)this.baseUrl), null, JiraWebSession.isSecure(this.baseUrl)));
            }
            ++n2;
        }
    }

    private static boolean isSecure(String repositoryUrl) {
        return repositoryUrl.matches("https.*");
    }

    private boolean needsReauthentication(HttpClient httpClient, int code, IProgressMonitor monitor) throws JiraAuthenticationException {
        AuthenticationType authenticationType;
        if (code == 200) {
            authenticationType = AuthenticationType.REPOSITORY;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        try {
            this.location.requestCredentials(authenticationType, null, monitor);
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            throw new JiraAuthenticationException("Login failed.");
        }
        return true;
    }

    private void logout(HttpClient httpClient, HostConfiguration hostConfiguration, IProgressMonitor monitor) throws JiraException {
        GetMethod logout = new GetMethod(String.valueOf(this.baseUrl) + "/logout");
        logout.setFollowRedirects(false);
        try {
            try {
                WebUtil.execute((HttpClient)httpClient, (HostConfiguration)hostConfiguration, (HttpMethod)logout, (IProgressMonitor)monitor);
            }
            catch (IOException iOException) {
                logout.releaseConnection();
            }
        }
        finally {
            logout.releaseConnection();
        }
    }

    private class RedirectInfo {
        final int statusCode;
        final String url;
        final Header[] responseHeaders;

        public RedirectInfo(String url, int statusCode, Header[] responseHeaders) {
            this.url = url;
            this.statusCode = statusCode;
            this.responseHeaders = responseHeaders;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Request: ");
            sb.append(this.url).append('\n');
            sb.append("Status: ").append(this.statusCode).append('\n');
            Header[] headerArray = this.responseHeaders;
            int n = this.responseHeaders.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                if (header.getName().equalsIgnoreCase("Server") || header.getName().equalsIgnoreCase("Location")) {
                    sb.append(header.toExternalForm());
                }
                ++n2;
            }
            return sb.toString();
        }
    }

    private class RedirectTracker {
        ArrayList<RedirectInfo> redirects = new ArrayList();
        Set<String> urls = new HashSet<String>();
        private boolean loggedCircle;

        private RedirectTracker() {
        }

        public void addUrl(String url) {
            this.urls.add(url);
        }

        public void checkForCircle(String url) {
            if (!this.loggedCircle && this.urls.contains(url)) {
                this.log("Circular redirect detected while login in to repository: " + JiraWebSession.this.client.getBaseUrl());
                this.loggedCircle = true;
            }
        }

        public void addRedirect(String url, HttpMethodBase method, int statusCode) {
            this.redirects.add(new RedirectInfo(url, statusCode, method.getResponseHeaders()));
        }

        public void log(String message) {
            if (!JiraWebSession.this.isLogEnabled()) {
                return;
            }
            MultiStatus status = new MultiStatus("org.eclipse.mylyn.internal.jira.core", 0, message, null);
            for (RedirectInfo info : this.redirects) {
                status.add((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", 0, info.toString(), null));
            }
            JiraCorePlugin.log((IStatus)status);
        }
    }
}

