/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.web.rss.JiraRssHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class JiraRssReader {
    private final JiraClient client;
    private final IssueCollector collector;

    public JiraRssReader(JiraClient client, IssueCollector collector) {
        this.client = client;
        this.collector = collector;
    }

    public void readRssFeed(InputStream feed, String baseUrl) throws JiraException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(new JiraRssHandler(this.client, this.collector, baseUrl));
            InputSource inputSource = new InputSource(feed);
            inputSource.setEncoding(this.client.getCharacterEncoding());
            reader.parse(inputSource);
            this.collector.done();
        }
        catch (SAXException e) {
            throw new JiraException("Error parsing server response: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new JiraException("Internal error parsing server response", e);
        }
    }
}

