/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.trac.ui.TracHyperlinkUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TracHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        TaskRepository taskRepository = (TaskRepository)this.getAdapter(TaskRepository.class);
        if (taskRepository != null && "trac".equals(taskRepository.getConnectorKind())) {
            String line;
            IRegion lineInfo;
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return null;
            }
            try {
                lineInfo = document.getLineInformationOfOffset(region.getOffset());
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            return TracHyperlinkUtil.findTracHyperlinks(taskRepository, line, region.getOffset() - lineInfo.getOffset(), lineInfo.getOffset());
        }
        return null;
    }
}

