/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.DegreeOfSeparation;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.context.core.IDegreeOfSeparation;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearch;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaReportInfo;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaSearchManager;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.MylynBugsManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaReferencesProvider
extends AbstractRelationProvider {
    public static final String ID = "org.eclipse.mylyn.bugs.search.references";
    public static final String NAME = "referenced by";
    public static final int DEFAULT_DEGREE = 0;
    private static final Map<String, BugzillaReportInfo> reports = new HashMap<String, BugzillaReportInfo>();

    public BugzillaReferencesProvider() {
        super("bugzilla", ID);
    }

    public List<IDegreeOfSeparation> getDegreesOfSeparation() {
        ArrayList<IDegreeOfSeparation> separations = new ArrayList<IDegreeOfSeparation>();
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("disabled", 0));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("local, fully qualified matches", 1));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("local, unqualified matches", 2));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("server, fully quaified matches", 3));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("server, unqualified matches", 4));
        return separations;
    }

    protected boolean acceptElement(IJavaElement javaElement) {
        return javaElement != null && (javaElement instanceof IMember || javaElement instanceof IType) && javaElement.exists();
    }

    protected void findRelated(IInteractionElement node, int degreeOfSeparation) {
        if (!node.getContentType().equals("java")) {
            return;
        }
        IJavaElement javaElement = JavaCore.create((String)node.getHandleIdentifier());
        if (!this.acceptElement(javaElement)) {
            return;
        }
        this.runJob(node, degreeOfSeparation);
    }

    public IActiveSearchOperation getSearchOperation(IInteractionElement node, int limitTo, int degreeOfSepatation) {
        IJavaElement javaElement = JavaCore.create((String)node.getHandleIdentifier());
        ITask task = TasksUiPlugin.getTaskListManager().getActiveTask();
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        return new BugzillaMylynSearch(degreeOfSepatation, javaElement, repository.getRepositoryUrl());
    }

    private void runJob(final IInteractionElement node, final int degreeOfSeparation) {
        BugzillaMylynSearch search = (BugzillaMylynSearch)this.getSearchOperation(node, 0, degreeOfSeparation);
        search.addListener(new IActiveSearchListener(){
            private boolean gathered = false;

            /*
             * Unable to fully structure code
             */
            public void searchCompleted(List<?> nodes) {
                itr = nodes.iterator();
                if (MylynBugsManager.getDefault() != null) ** GOTO lbl9
                return;
lbl-1000:
                // 1 sources

                {
                    o = itr.next();
                    if (!(o instanceof BugzillaReportInfo)) continue;
                    bugzillaNode = (BugzillaReportInfo)o;
                    handle = bugzillaNode.getElementHandle();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            BugzillaReferencesProvider.this.incrementInterest(node, "bugzilla", handle, degreeOfSeparation);
                        }
                    });
lbl9:
                    // 3 sources

                    ** while (itr.hasNext())
                }
lbl10:
                // 1 sources

                this.gathered = true;
                BugzillaReferencesProvider.access$1(BugzillaReferencesProvider.this, node);
            }

            public boolean resultsGathered() {
                return this.gathered;
            }
        });
        search.run((IProgressMonitor)new NullProgressMonitor(), 40);
    }

    public String getGenericId() {
        return ID;
    }

    protected String getSourceId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public BugzillaReportInfo getCached(String handle) {
        return reports.get(handle);
    }

    protected void cache(String handle, BugzillaReportInfo bugzillaNode) {
        reports.put(handle, bugzillaNode);
    }

    public void clearCachedReports() {
        reports.clear();
    }

    public Collection<? extends String> getCachedHandles() {
        return reports.keySet();
    }

    public void stopAllRunningJobs() {
        BugzillaSearchManager.cancelAllRunningJobs();
    }

    protected int getDefaultDegreeOfSeparation() {
        return 0;
    }

    public void contextPreActivated(IInteractionContext context) {
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
    }

    static /* synthetic */ void access$1(BugzillaReferencesProvider bugzillaReferencesProvider, IInteractionElement iInteractionElement) {
        bugzillaReferencesProvider.searchCompleted(iInteractionElement);
    }
}

