/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.sandbox.ui.commands.ViewSourceHandler;
import org.eclipse.mylyn.internal.sandbox.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.internal.sandbox.ui.editors.TaskEditorDropTarget;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

public class ExtensibleRichTextAttributeEditor
extends RichTextAttributeEditor {
    private IContextActivation contextActivation;
    private final IContextService contextService;
    private SourceViewer defaultViewer;
    private Composite editorComposite;
    private StackLayout editorLayout;
    private final AbstractTaskEditorExtension extension;
    private SourceViewer editorViewer;
    private SourceViewer previewViewer;
    private int styles;
    private final TaskRepository taskRepository;
    private FormToolkit toolkit;
    private final IAction viewSourceAction = new ViewSourceAction();

    public ExtensibleRichTextAttributeEditor(IContextService contextService, TaskDataModel manager, TaskRepository taskRepository, AbstractTaskEditorExtension extension, TaskAttribute taskAttribute, int styles) {
        super(manager, taskRepository, taskAttribute, styles);
        this.contextService = contextService;
        this.taskRepository = taskRepository;
        this.extension = extension;
        this.styles = styles;
    }

    private void configureAsTextEditor(SourceViewer viewer, Document document) {
        AnnotationModel annotationModel = new AnnotationModel();
        viewer.showAnnotations(false);
        viewer.showAnnotationsOverview(false);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        viewer.getTextWidget().setIndent(2);
        viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
    }

    private SourceViewer configureEditor(final SourceViewer viewer, boolean readOnly) {
        Document document = new Document(this.getValue());
        if (readOnly) {
            viewer.setDocument((IDocument)document);
            viewer.getControl().setData("viewSourceAction", (Object)this.viewSourceAction);
            viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ViewSourceHandler.setChecked(ExtensibleRichTextAttributeEditor.this.getViewer() == ExtensibleRichTextAttributeEditor.this.defaultViewer);
                }
            });
        } else {
            this.configureAsTextEditor(viewer, document);
            viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    String value = viewer.getTextWidget().getText();
                    if (!ExtensibleRichTextAttributeEditor.this.getValue().equals(value)) {
                        ExtensibleRichTextAttributeEditor.this.setValue(value);
                        EditorUtil.ensureVisible((Control)viewer.getTextWidget());
                    }
                }
            });
            viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            TaskEditorDropTarget.addDropTargetSupport(viewer);
        }
        EditorUtil.setTextViewer((Widget)viewer.getTextWidget(), (TextViewer)viewer);
        viewer.setEditable(!readOnly);
        viewer.getTextWidget().setFont(this.getFont());
        this.toolkit.adapt(viewer.getControl(), false, false);
        return viewer;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.editorComposite = new Composite(parent, 0);
        this.editorLayout = new StackLayout(){

            protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
                return this.topControl.computeSize(hint, hint2, flushCache);
            }
        };
        this.editorComposite.setLayout((Layout)this.editorLayout);
        this.setControl((Control)this.editorComposite);
        if (!this.isReadOnly() && (this.styles & 0x10) == 0) {
            this.styles |= 0x200;
        }
        if (this.isReadOnly()) {
            this.editorViewer = this.extension.createViewer(this.taskRepository, this.editorComposite, this.styles);
        } else {
            this.editorViewer = this.extension.createEditor(this.taskRepository, this.editorComposite, this.styles);
            this.editorViewer.getTextWidget().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ExtensibleRichTextAttributeEditor.this.setContext();
                }

                public void focusLost(FocusEvent e) {
                    ExtensibleRichTextAttributeEditor.this.unsetContext();
                }
            });
            this.editorViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ExtensibleRichTextAttributeEditor.this.unsetContext();
                }
            });
        }
        this.configureEditor(this.editorViewer, this.isReadOnly());
        this.show(this.editorViewer);
    }

    private SourceViewer createDefaultEditor(Composite parent, int styles) {
        RepositoryTextViewer defaultEditor = new RepositoryTextViewer(this.taskRepository, parent, styles | 0x40);
        RepositoryTextViewerConfiguration viewerConfig = new RepositoryTextViewerConfiguration(this.taskRepository, this.isSpellCheckingEnabled());
        viewerConfig.setMode(this.getMode());
        defaultEditor.configure((SourceViewerConfiguration)viewerConfig);
        return defaultEditor;
    }

    private SourceViewer getDefaultViewer() {
        if (this.defaultViewer == null) {
            this.defaultViewer = this.createDefaultEditor(this.editorComposite, this.styles);
            this.configureEditor(this.defaultViewer, this.isReadOnly());
            this.defaultViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
            this.defaultViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
            this.installMenu(this.defaultViewer.getControl(), this.editorViewer.getControl().getMenu());
        }
        return this.defaultViewer;
    }

    private void installMenu(final Control control, Menu menu) {
        if (menu != null) {
            control.setMenu(menu);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    control.setMenu(null);
                }
            });
        }
    }

    private Font getFont() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
        return font;
    }

    private SourceViewer getPreviewViewer() {
        if (this.previewViewer == null) {
            this.previewViewer = this.extension.createViewer(this.taskRepository, this.editorComposite, this.styles);
            this.configureEditor(this.previewViewer, true);
            this.previewViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
        }
        Document document = new Document(this.editorViewer.getDocument().get());
        this.previewViewer.setDocument((IDocument)document);
        return this.previewViewer;
    }

    public SourceViewer getEditorViewer() {
        return this.editorViewer;
    }

    public SourceViewer getViewer() {
        if (this.defaultViewer != null && this.editorLayout.topControl == this.defaultViewer.getControl()) {
            return this.defaultViewer;
        }
        if (this.previewViewer != null && this.editorLayout.topControl == this.previewViewer.getControl()) {
            return this.previewViewer;
        }
        return this.editorViewer;
    }

    private void setContext() {
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.contextService != null && this.extension.getEditorContextId() != null) {
            this.contextActivation = this.contextService.activateContext(this.extension.getEditorContextId());
        }
    }

    private void show(SourceViewer viewer) {
        this.editorLayout.topControl = viewer.getControl();
        this.editorComposite.layout();
        viewer.getControl().setFocus();
    }

    public void showDefault() {
        this.show(this.getDefaultViewer());
    }

    public void showPreview() {
        if (!this.isReadOnly()) {
            this.show(this.getPreviewViewer());
        }
    }

    public void showEditor() {
        this.show(this.getEditorViewer());
    }

    private void unsetContext() {
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }

    public class ViewSourceAction
    extends Action {
        public ViewSourceAction() {
            super("Viewer Source", 2);
            this.setChecked(false);
        }

        public void run() {
            if (this.isChecked()) {
                ExtensibleRichTextAttributeEditor.this.showDefault();
            } else {
                ExtensibleRichTextAttributeEditor.this.showEditor();
            }
        }
    }
}

