/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.sandbox.ui.editors.CommentGroupStrategy;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleTaskEditorCommentPart
extends TaskEditorCommentPart {
    private CommentGroupStrategy commentGroupStrategy;
    private List<Section> subSections;

    private static void toggleChildren(Composite composite, boolean expended) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ExpandableComposite && !child.isDisposed()) {
                EditorUtil.toggleExpandableComposite((boolean)expended, (ExpandableComposite)((ExpandableComposite)child));
            }
            if (child instanceof Composite) {
                ExtensibleTaskEditorCommentPart.toggleChildren((Composite)child, expended);
            }
            ++n2;
        }
    }

    public ExtensibleTaskEditorCommentPart() {
        this.setPartName("Comments");
    }

    private void createCommentSubsections(FormToolkit toolkit, Composite composite, List<TaskAttribute> comments) {
        List<CommentGroupStrategy.CommentGroup> commentGroups = this.getCommentGroupStrategy().groupCommentsFromModel(this.getModel());
        if (commentGroups.size() == 1) {
            for (CommentGroupStrategy.CommentGroup commentGroup : commentGroups) {
                this.addComments(toolkit, composite, commentGroup.getCommentAttributes());
            }
        } else {
            this.subSections = new ArrayList<Section>();
            for (CommentGroupStrategy.CommentGroup commentGroup : commentGroups) {
                this.createGroupSection(toolkit, composite, commentGroup);
            }
        }
    }

    private void createCurrentSubsectionToolBar(FormToolkit toolkit, final Section section) {
        if (section == null) {
            return;
        }
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        Action collapseAllAction = new Action(""){

            public void run() {
                ExtensibleTaskEditorCommentPart.this.toggleSection(section, false);
            }
        };
        collapseAllAction.setImageDescriptor(CommonImages.COLLAPSE_ALL_SMALL);
        collapseAllAction.setToolTipText("Collapse All Current Comments");
        toolBarManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(""){

            public void run() {
                ExtensibleTaskEditorCommentPart.this.toggleSection(section, true);
            }
        };
        expandAllAction.setImageDescriptor(CommonImages.EXPAND_ALL_SMALL);
        expandAllAction.setToolTipText("Expand All Current Comments");
        toolBarManager.add((IAction)expandAllAction);
        Composite toolbarComposite = toolkit.createComposite((Composite)section);
        toolbarComposite.setBackground(null);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        toolbarComposite.setLayout((Layout)rowLayout);
        toolBarManager.createControl(toolbarComposite);
        section.setTextClient((Control)toolbarComposite);
    }

    private void createGroupSection(final FormToolkit toolkit, Composite parent, final CommentGroupStrategy.CommentGroup commentGroup) {
        int style = 514;
        if (commentGroup.getGroupName().equals("Current")) {
            style |= 0x40;
        }
        final Section groupSection = toolkit.createSection(parent, style);
        groupSection.setBackground(null);
        groupSection.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)groupSection);
        groupSection.setText(String.valueOf(commentGroup.getGroupName()) + " (" + commentGroup.getCommentAttributes().size() + ")");
        if (commentGroup.getGroupName().equals("Current")) {
            this.createCurrentSubsectionToolBar(toolkit, groupSection);
        }
        if (groupSection.isExpanded()) {
            this.expendSubsection(toolkit, commentGroup, groupSection);
        }
        groupSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExtensibleTaskEditorCommentPart.this.expendSubsection(toolkit, commentGroup, groupSection);
                ExtensibleTaskEditorCommentPart.this.getTaskEditorPage().reflow();
            }
        });
        this.subSections.add(groupSection);
    }

    protected void expandAllComments() {
        if (this.section != null) {
            EditorUtil.toggleExpandableComposite((boolean)true, (ExpandableComposite)this.section);
        }
        if (this.subSections != null) {
            try {
                this.getTaskEditorPage().setReflow(false);
                if (this.section != null) {
                    EditorUtil.toggleExpandableComposite((boolean)true, (ExpandableComposite)this.section);
                }
                for (Section subSection : this.subSections) {
                    if (subSection.isDisposed()) continue;
                    EditorUtil.toggleExpandableComposite((boolean)true, (ExpandableComposite)subSection);
                }
            }
            finally {
                this.getTaskEditorPage().setReflow(true);
            }
        }
        super.expandAllComments();
    }

    protected void expandSection(FormToolkit toolkit, Section section, List<TaskAttribute> comments) {
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        if (comments.size() < 12) {
            this.addComments(toolkit, composite, comments);
        } else {
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.createCommentSubsections(toolkit, composite, comments);
        }
    }

    private void expendSubsection(FormToolkit toolkit, CommentGroupStrategy.CommentGroup commentGroup, Section groupSection) {
        if (groupSection.getData("isInit") == null) {
            Composite groupContentComposite = toolkit.createComposite((Composite)groupSection);
            groupSection.setClient((Control)groupContentComposite);
            GridLayout contentLayout = new GridLayout();
            contentLayout.marginHeight = 0;
            contentLayout.marginWidth = 0;
            groupContentComposite.setLayout((Layout)contentLayout);
            groupContentComposite.setLayoutData((Object)new GridData(768));
            this.addComments(toolkit, groupContentComposite, commentGroup.getCommentAttributes());
            groupSection.setData("isInit", (Object)true);
        }
    }

    private CommentGroupStrategy getCommentGroupStrategy() {
        if (this.commentGroupStrategy == null) {
            this.commentGroupStrategy = new CommentGroupStrategy();
        }
        return this.commentGroupStrategy;
    }

    private void toggleSection(Section section, boolean expended) {
        try {
            this.getTaskEditorPage().setReflow(false);
            if (expended && !section.isDisposed()) {
                EditorUtil.toggleExpandableComposite((boolean)true, (ExpandableComposite)section);
            }
            ExtensibleTaskEditorCommentPart.toggleChildren((Composite)section, expended);
        }
        finally {
            this.getTaskEditorPage().setReflow(true);
        }
        this.getTaskEditorPage().reflow();
    }
}

