/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.hyperlinks;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.IResourceHyperlinkExtension;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.ResourceHyperlinkExtensions;

public class ResourceHyperlinkExtensionReader {
    public static final String ATTR_FILE_TYPE = "fileType";
    public static final String ATTR_GENERATED_PREFIX = "generatedPrefix";
    public static final String EXTENSION_RESOURCE_HYPERLINK_EXTENSIONS = "org.eclipse.mylyn.sandbox.ui.resourceHyperlinkExtensions";
    private static final String RESOURCE_HYPERLINK_EXTENSION = "resourceHyperlinkExtension";

    public static void initExtensions() {
        IExtension[] editorExtensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint editorExtensionPoint = registry.getExtensionPoint(EXTENSION_RESOURCE_HYPERLINK_EXTENSIONS);
        IExtension[] iExtensionArray = editorExtensions = editorExtensionPoint.getExtensions();
        int n = editorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(RESOURCE_HYPERLINK_EXTENSION)) {
                    ResourceHyperlinkExtensionReader.readResourceHyperlinkExtension(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void readResourceHyperlinkExtension(IConfigurationElement element) {
        try {
            String fileType = element.getAttribute(ATTR_FILE_TYPE);
            String generatedPrefix = element.getAttribute(ATTR_GENERATED_PREFIX);
            Object extension = element.createExecutableExtension("class");
            if (extension instanceof IResourceHyperlinkExtension) {
                ResourceHyperlinkExtensions.addResourceHyperlinkExtension(fileType, generatedPrefix, (IResourceHyperlinkExtension)extension);
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load resourceHyperlinkExtension: expected instanceof IResourceHyperlink, got " + extension.getClass()));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load resourceHyperlinkExtension", (Throwable)e));
        }
    }
}

