/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.token;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class ImageReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[Image:([^\\]\\|]+)(?:\\|([^\\]]*))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ImageReplacementTokenProcessor();
    }

    private static class ImageReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ImageReplacementTokenProcessor() {
        }

        public void emit() {
            String imageUrl = this.group(1);
            String optionsString = this.group(2);
            ImageAttributes attributes = new ImageAttributes();
            if (optionsString != null) {
                String[] options;
                String[] stringArray = options = optionsString.split("\\s*\\|\\s*");
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    if ("center".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Middle);
                    } else if ("left".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Left);
                    } else if ("right".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Right);
                    } else if ("none".equals(option)) {
                        attributes.setAlign(null);
                    } else if (!"thumb".equals(option) && !"thumbnail".equals(option)) {
                        if (option.matches("\\d+px")) {
                            try {
                                int size = Integer.parseInt(option.substring(0, option.length() - 2));
                                attributes.setWidth(size);
                                attributes.setHeight(size);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if ("frameless".equals(option)) {
                            attributes.setBorder(0);
                        } else if ("frame".equals(option)) {
                            attributes.setBorder(1);
                        } else {
                            attributes.setTitle(option);
                        }
                    }
                    ++n2;
                }
            }
            this.builder.image((Attributes)attributes, imageUrl);
        }
    }
}

