/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class FootnoteBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 9;
    static final Pattern startPattern = Pattern.compile("fn([0-9]{1,2})(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.\\s+(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private String footnote;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            attributes.setCssClass("footnote");
            this.footnote = this.matcher.group(1);
            attributes.setId(this.state.getFootnoteId(this.footnote));
            Textile.configureAttributes(attributes, this.matcher, 2, true);
            offset = this.matcher.start(9);
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
            this.builder.beginSpan(DocumentBuilder.SpanType.SUPERSCRIPT, new Attributes());
            this.builder.characters(this.footnote);
            this.builder.endSpan();
            this.builder.characters(" ");
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 0) {
            this.builder.lineBreak();
        }
        ++this.blockLineCount;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

