/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileContentState;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.CodeBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.FootnoteBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.QuoteBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.TableOfContentsBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.block.TextileGlossaryBlock;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.EscapeTextilePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.ImageTextilePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.phrase.SimpleTextilePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.textile.core.token.FootnoteReferenceReplacementToken;
import org.eclipse.mylyn.internal.wikitext.textile.core.token.HyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.AcronymReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityWrappingReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternEntityReferenceReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextileLanguage
extends MarkupLanguage {
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    private final MarkupLanguage.PatternBasedSyntax tokenSyntax = new MarkupLanguage.PatternBasedSyntax();
    private final MarkupLanguage.PatternBasedSyntax phraseModifierSyntax = new MarkupLanguage.PatternBasedSyntax();
    private boolean escapingHtml;

    protected MarkupLanguage.PatternBasedSyntax getPhraseModifierSyntax() {
        return this.phraseModifierSyntax;
    }

    protected MarkupLanguage.PatternBasedSyntax getReplacementTokenSyntax() {
        return this.tokenSyntax;
    }

    public TextileLanguage() {
        this.setName("Textile");
        this.initializeSyntax();
    }

    protected void initializeSyntax() {
        this.initializeBlocks();
        this.initializePhraseModifiers();
        this.initializeTokens();
    }

    protected void initializeTokens() {
        this.tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        this.tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        this.tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        this.tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        this.tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        this.tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        this.tokenSyntax.add((PatternBasedElement)new HyperlinkReplacementToken());
        this.tokenSyntax.add((PatternBasedElement)new FootnoteReferenceReplacementToken());
        this.tokenSyntax.add((PatternBasedElement)new EntityWrappingReplacementToken("\"", "#8220", "#8221"));
        this.tokenSyntax.add((PatternBasedElement)new EntityWrappingReplacementToken("'", "#8216", "#8217"));
        this.tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w)(')(?=\\w))", "#8217"));
        this.tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(--)(?=\\s\\w))", "#8212"));
        this.tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(-)(?=\\s\\w))", "#8211"));
        this.tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\d\\s)(x)(?=\\s\\d))", "#215"));
        this.tokenSyntax.add((PatternBasedElement)new AcronymReplacementToken());
        this.addTokenExtensions(this.tokenSyntax);
    }

    protected void initializePhraseModifiers() {
        this.phraseModifierSyntax.add((PatternBasedElement)new HtmlEndTagPhraseModifier(this.isEscapingHtml()));
        this.phraseModifierSyntax.add((PatternBasedElement)new HtmlStartTagPhraseModifier(this.isEscapingHtml()));
        this.phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        this.phraseModifierSyntax.add((PatternBasedElement)new EscapeTextilePhraseModifier());
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("**", DocumentBuilder.SpanType.BOLD));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("??", DocumentBuilder.SpanType.CITATION));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("__", DocumentBuilder.SpanType.ITALIC));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("*", DocumentBuilder.SpanType.STRONG));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("+", DocumentBuilder.SpanType.INSERTED));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("@", DocumentBuilder.SpanType.CODE));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("%", DocumentBuilder.SpanType.SPAN));
        this.phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("-", DocumentBuilder.SpanType.DELETED));
        this.phraseModifierSyntax.add((PatternBasedElement)new ImageTextilePhraseModifier());
        this.phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        this.addPhraseModifierExtensions(this.phraseModifierSyntax);
    }

    protected boolean isEscapingHtml() {
        return false;
    }

    protected void initializeBlocks() {
        this.blocks.add(new HeadingBlock());
        ListBlock listBlock = new ListBlock();
        this.blocks.add(listBlock);
        this.paragraphBreakingBlocks.add(listBlock);
        this.blocks.add(new PreformattedBlock());
        this.blocks.add(new QuoteBlock());
        this.blocks.add(new CodeBlock());
        this.blocks.add(new FootnoteBlock());
        TableBlock tableBlock = new TableBlock();
        this.blocks.add(tableBlock);
        this.paragraphBreakingBlocks.add(tableBlock);
        this.addBlockExtensions(this.blocks, this.paragraphBreakingBlocks);
        this.blocks.add(new ParagraphBlock());
    }

    protected void addBlockExtensions(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add((Block)new TextileGlossaryBlock());
        blocks.add(new TableOfContentsBlock());
    }

    protected void addTokenExtensions(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
    }

    protected void addPhraseModifierExtensions(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
    }

    public List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    protected ContentState createState() {
        return new TextileContentState();
    }
}

