/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.QuoteBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.BangEscapeToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.HyperlinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.LineBreakToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracWikiLanguage
extends MarkupLanguage {
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Block> paragraphNestableBlocks = new ArrayList<Block>();
    private static MarkupLanguage.PatternBasedSyntax tokenSyntax = new MarkupLanguage.PatternBasedSyntax();
    private static MarkupLanguage.PatternBasedSyntax phraseModifierSyntax = new MarkupLanguage.PatternBasedSyntax();

    static {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("__", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("--", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier(",,", DocumentBuilder.SpanType.SUBSCRIPT, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        tokenSyntax.add((PatternBasedElement)new BangEscapeToken());
        tokenSyntax.add((PatternBasedElement)new LineBreakToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
    }

    public TracWikiLanguage() {
        ListBlock listBlock = new ListBlock();
        this.blocks.add(listBlock);
        this.paragraphNestableBlocks.add(listBlock);
        HeadingBlock headingBlock = new HeadingBlock();
        this.blocks.add(headingBlock);
        this.paragraphNestableBlocks.add(listBlock);
        PreformattedBlock preformattedBlock = new PreformattedBlock();
        this.blocks.add(preformattedBlock);
        this.paragraphNestableBlocks.add(preformattedBlock);
        QuoteBlock quoteBlock = new QuoteBlock();
        this.blocks.add(quoteBlock);
        this.paragraphNestableBlocks.add(quoteBlock);
        TableBlock tableBlock = new TableBlock();
        this.blocks.add(tableBlock);
        this.paragraphNestableBlocks.add(tableBlock);
        this.blocks.add(new ParagraphBlock());
        this.setName("TracWiki");
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getParagraphNestableBlocks() {
        return this.paragraphNestableBlocks;
    }

    protected MarkupLanguage.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    protected MarkupLanguage.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }
}

