/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.OutlineContentProvider;
import org.eclipse.mylyn.internal.wikitext.ui.editor.OutlineLabelProvider;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class MarkupEditorOutline
extends ContentOutlinePage {
    private final MarkupEditor editor;
    private boolean disableReveal;

    public MarkupEditorOutline(MarkupEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setUseHashlookup(true);
        this.getTreeViewer().setAutoExpandLevel(-1);
        this.getTreeViewer().setContentProvider((IContentProvider)new OutlineContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.getTreeViewer().setInput((Object)this.editor.getOutlineModel());
        this.getTreeViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MarkupEditorOutline.this.revealInEditor(event.getSelection(), true);
            }
        });
        this.getTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarkupEditorOutline.this.revealInEditor(event.getSelection(), false);
            }
        });
        this.getTreeViewer().expandAll();
        new ToolTip(this.getTreeViewer().getControl(), 1, false){

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                Composite comp = new Composite(parent, 0);
                comp.setBackground(parent.getDisplay().getSystemColor(29));
                GridLayout gl = new GridLayout(1, false);
                gl.marginBottom = 2;
                gl.marginTop = 2;
                gl.marginHeight = 0;
                gl.marginWidth = 0;
                gl.marginLeft = 2;
                gl.marginRight = 2;
                gl.verticalSpacing = 1;
                comp.setLayout((Layout)gl);
                Object tipItem = this.getToolTipItem(new Point(event.x, event.y));
                if (tipItem instanceof OutlineItem) {
                    OutlineItem outlineItem = (OutlineItem)tipItem;
                    Label label = new Label(comp, 64);
                    label.setBackground(comp.getBackground());
                    label.setText(outlineItem.getTooltip());
                }
                return comp;
            }

            protected boolean shouldCreateToolTip(Event event) {
                boolean shouldCreate;
                Object eventItem = this.getToolTipItem(new Point(event.x, event.y));
                boolean bl = shouldCreate = eventItem != null && eventItem instanceof OutlineItem && super.shouldCreateToolTip(event);
                if (!shouldCreate) {
                    this.hide();
                }
                return shouldCreate;
            }

            protected Object getToolTipItem(Point point) {
                TreeItem item = ((Tree)MarkupEditorOutline.this.getTreeViewer().getControl()).getItem(point);
                if (item != null) {
                    return item.getData();
                }
                return null;
            }
        };
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
    }

    protected TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    private void revealInEditor(ISelection selection, boolean open) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (this.disableReveal) {
            return;
        }
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof OutlineItem) {
            OutlineItem item = (OutlineItem)firstElement;
            this.editor.selectAndReveal(item.getOffset(), item.getLength());
        }
    }

    public void refresh() {
        this.getTreeViewer().refresh();
        this.getTreeViewer().expandAll();
    }

    public void setSelection(ISelection selection) {
        this.disableReveal = true;
        try {
            super.setSelection(selection);
        }
        finally {
            this.disableReveal = false;
        }
    }
}

