/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.help;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.mylyn.wikitext.core.WikiTextPlugin;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.osgi.framework.Bundle;

public class HelpContent {
    private final Bundle provider;
    private final String resourcePath;
    private final String resourceContentLanguage;
    private final String markupLanguageName;

    public HelpContent(Bundle provider, String resourcePath, String resourceContentLanguage, String markupLanguage) {
        if (provider == null || resourcePath == null || markupLanguage == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
        this.resourcePath = resourcePath;
        this.resourceContentLanguage = resourceContentLanguage;
        this.markupLanguageName = markupLanguage;
    }

    public String getMarkupLanguageName() {
        return this.markupLanguageName;
    }

    public Bundle getProvider() {
        return this.provider;
    }

    public String getContent() throws IOException {
        try {
            String content = null;
            URL resource = this.provider.getResource(this.resourcePath);
            if (resource == null) {
                throw new Exception(String.format("Cannot find resource '%s' in plugin '%s'", this.resourcePath, this.provider.getSymbolicName()));
            }
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(resource.openStream()));
            try {
                int i;
                StringBuilder buf = new StringBuilder();
                while ((i = ((Reader)reader).read()) != -1) {
                    buf.append((char)i);
                }
                content = buf.toString();
            }
            finally {
                ((Reader)reader).close();
            }
            if (this.resourceContentLanguage == null || "html".equalsIgnoreCase(this.resourceContentLanguage)) {
                return content;
            }
            MarkupLanguage markupLanguage = WikiTextPlugin.getDefault().getMarkupLanguage(this.resourceContentLanguage);
            if (markupLanguage == null) {
                throw new IOException(String.format("No such markup language: %s", this.resourceContentLanguage));
            }
            MarkupParser markupParser = new MarkupParser(markupLanguage);
            return markupParser.parseToHtml(content);
        }
        catch (Exception e) {
            throw new IOException(String.format("Cannot access content %s/%s: %s", this.provider.getSymbolicName(), this.resourcePath, e.getMessage())){

                public Throwable getCause() {
                    return e;
                }
            };
        }
    }
}

