/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.AnnotationMarkupValidator;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.DocumentRegionValidator;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.ResourceMarkerMarkupValidator;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiTextUiPlugin;

public class MarkupValidationReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    private IProgressMonitor monitor;
    private final ISourceViewer viewer;
    private DocumentRegionValidator validator;
    private IResource resource;
    private MarkupLanguage markupLanguage;

    public MarkupValidationReconcilingStrategy(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void reconcile(IRegion partition) {
        if (this.document == null) {
            return;
        }
        if (this.validator == null) {
            this.validator = this.resource == null ? new AnnotationMarkupValidator() : new ResourceMarkerMarkupValidator();
        }
        this.validator.setMarkupLanguage(this.markupLanguage);
        this.validator.setAnnotationModel(this.getAnnotationModel());
        this.validator.setResource(this.resource);
        try {
            this.validator.validate((IProgressMonitor)(this.monitor == null ? new NullProgressMonitor() : this.monitor), this.document, partition);
        }
        catch (CoreException e) {
            WikiTextUiPlugin.getDefault().log(e);
        }
    }

    private IAnnotationModel getAnnotationModel() {
        return this.viewer.getAnnotationModel();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void initialReconcile() {
        if (this.document == null) {
            return;
        }
        this.reconcile((IRegion)new Region(0, this.document.getLength()));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

