/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Block;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Segment;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Span;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Locator;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public class FastMarkupPartitioner
extends FastPartitioner {
    public static final String CONTENT_TYPE_MARKUP = "__markup_block";
    public static final String[] ALL_CONTENT_TYPES = new String[]{"__markup_block"};
    private MarkupLanguage markupLanguage;

    public FastMarkupPartitioner() {
        super((IPartitionTokenScanner)new PartitionTokenScanner(), ALL_CONTENT_TYPES);
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
        this.getScanner().setMarkupLanguage(markupLanguage);
        this.resetPartitions();
    }

    PartitionTokenScanner getScanner() {
        return (PartitionTokenScanner)this.fScanner;
    }

    public void resetPartitions() {
        if (this.fDocument != null) {
            super.flushRewriteSession();
            this.initialize();
        } else {
            this.clearPositionCache();
        }
    }

    public void reparse(IDocument document, Block block) {
        MarkupParser markupParser = new MarkupParser(this.markupLanguage);
        this.markupLanguage.setBlocksOnly(false);
        this.markupLanguage.setFilterGenerativeContents(true);
        PartitionBuilder partitionBuilder = new PartitionBuilder(block.getOffset(), false);
        markupParser.setBuilder((DocumentBuilder)partitionBuilder);
        try {
            markupParser.parse(document.get(block.getOffset(), block.getLength()));
            for (Segment s : partitionBuilder.outerBlock.getChildren().asList()) {
                if (s.getOffset() != block.getOffset() || !(s instanceof Block)) continue;
                block.replaceChildren(s);
                block.setSpansComputed(true);
                break;
            }
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarkupPartition
    implements ITypedRegion {
        private final Block block;
        private int offset;
        private int length;
        private List<Span> spans;

        private MarkupPartition(Block block, int offset, int length) {
            this.block = block;
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getType() {
            return FastMarkupPartitioner.CONTENT_TYPE_MARKUP;
        }

        public Block getBlock() {
            return this.block;
        }

        public List<Span> getSpans() {
            if (this.spans == null) {
                ArrayList<Span> spans = new ArrayList<Span>();
                this.getSpans(this.block, spans);
                this.spans = spans;
            }
            return this.spans;
        }

        private void getSpans(Block block, List<Span> spans) {
            for (Segment s : block.getChildren().asList()) {
                if (s.getOffset() < this.offset || s.getOffset() >= this.offset + this.length) continue;
                if (s instanceof Span) {
                    spans.add((Span)s);
                    continue;
                }
                this.getSpans((Block)s, spans);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartitionBuilder
    extends DocumentBuilder {
        private final Block outerBlock;
        private Block currentBlock;
        private Span currentSpan;
        private final int offset;
        private List<MarkupPartition> partitions;
        private final boolean blocksOnly;

        public PartitionBuilder(int offset, boolean blocksOnly) {
            this.currentBlock = this.outerBlock = new Block(null, 0, 0x3FFFFFFF);
            this.currentSpan = null;
            this.offset = offset;
            this.blocksOnly = blocksOnly;
        }

        public void acronym(String text, String definition) {
        }

        public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
            int newBlockOffset = this.getLocator().getDocumentOffset() + this.offset;
            Block newBlock = new Block(type, attributes, newBlockOffset, this.currentBlock.getLength() - (newBlockOffset - this.currentBlock.getOffset()));
            newBlock.setSpansComputed(!this.blocksOnly);
            this.currentBlock.add(newBlock);
            this.currentBlock = newBlock;
        }

        public void beginDocument() {
        }

        public void beginHeading(int level, Attributes attributes) {
            int newBlockOffset = this.getLocator().getDocumentOffset() + this.offset;
            Block newBlock = new Block(level, attributes, newBlockOffset, this.currentBlock.getLength() - (newBlockOffset - this.currentBlock.getOffset()));
            newBlock.setSpansComputed(!this.blocksOnly);
            this.currentBlock.add(newBlock);
            this.currentBlock = newBlock;
        }

        public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
            Span span = new Span(type, attributes, this.getLocator().getDocumentOffset() + this.offset, this.getLocator().getLineSegmentEndOffset() - this.getLocator().getLineCharacterOffset());
            if (this.currentSpan != null) {
                this.currentSpan.add(span);
                this.currentSpan = span;
            } else {
                this.currentSpan = span;
                this.currentBlock.add(span);
            }
        }

        public void characters(String text) {
        }

        public void charactersUnescaped(String literal) {
        }

        public void endBlock() {
            this.currentBlock = this.currentBlock.getParent();
            if (this.currentBlock == null) {
                throw new IllegalStateException();
            }
        }

        public void endDocument() {
            if (this.currentBlock != this.outerBlock) {
                throw new IllegalStateException();
            }
            Locator locator = this.getLocator();
            this.outerBlock.setLength((locator == null ? 0 : locator.getDocumentOffset()) + this.offset);
            this.partitions = new ArrayList<MarkupPartition>();
            for (Segment child : this.outerBlock.getChildren().asList()) {
                this.createRegions(null, child);
            }
        }

        public MarkupPartition createRegions(MarkupPartition parent, Segment<?> segment) {
            Block block;
            if (segment.getLength() == 0) {
                return parent;
            }
            if (segment instanceof Block && !this.filtered(block = (Block)segment)) {
                MarkupPartition partition = new MarkupPartition(block, segment.getOffset(), segment.getLength());
                if (parent == null) {
                    this.partitions.add(partition);
                } else if (partition.offset == parent.offset) {
                    if (partition.length == parent.length) {
                        this.partitions.remove(parent);
                        this.partitions.add(partition);
                    } else {
                        parent.offset = partition.offset + partition.length;
                        this.partitions.add(this.partitions.size() - 1, partition);
                    }
                } else if (partition.length + partition.offset == parent.length + parent.offset) {
                    parent.length = partition.offset - parent.offset;
                } else {
                    int parentLength = parent.length;
                    parent.length = partition.offset - parent.offset;
                    int splitOffset = partition.offset + partition.length;
                    MarkupPartition split = new MarkupPartition(parent.block, splitOffset, parent.offset + parentLength - splitOffset);
                    this.partitions.add(partition);
                    this.partitions.add(split);
                    parent = split;
                }
                if (!block.getChildren().isEmpty()) {
                    for (Segment child : block.getChildren().asList()) {
                        partition = this.createRegions(partition, child);
                    }
                }
            }
            return parent;
        }

        private boolean filtered(Block block) {
            if (block.getType() == null) {
                return false;
            }
            switch (block.getType()) {
                case LIST_ITEM: 
                case TABLE_ROW: 
                case TABLE_CELL_HEADER: 
                case TABLE_CELL_NORMAL: 
                case DEFINITION_TERM: 
                case DEFINITION_ITEM: {
                    return true;
                }
                case NUMERIC_LIST: 
                case BULLETED_LIST: 
                case DEFINITION_LIST: {
                    return block.getParent() != null && this.filtered(block.getParent());
                }
            }
            return false;
        }

        public void endHeading() {
            this.currentBlock = this.currentBlock.getParent();
            if (this.currentBlock == null) {
                throw new IllegalStateException();
            }
        }

        public void endSpan() {
            if (this.currentSpan == null) {
                throw new IllegalStateException();
            }
            this.currentSpan = this.currentSpan.getParent() instanceof Span ? (Span)this.currentSpan.getParent() : null;
        }

        public void entityReference(String entity) {
        }

        public void image(Attributes attributes, String url) {
        }

        public void imageLink(Attributes linkAttributes, Attributes attributes, String href, String imageUrl) {
        }

        public void lineBreak() {
        }

        public void link(Attributes attributes, String hrefOrHashName, String text) {
        }
    }

    static class PartitionTokenScanner
    implements IPartitionTokenScanner {
        private ITypedRegion[] regions = null;
        private MarkupLanguage markupLanguage;
        private int index = -1;
        private int offsetOfPartitions;
        private int lengthOfPartitions;

        PartitionTokenScanner() {
        }

        public ITypedRegion[] computePartitions(IDocument document, int offset, int length) {
            if (this.offsetOfPartitions <= offset && this.offsetOfPartitions + this.lengthOfPartitions >= offset + length) {
                return this.regions;
            }
            return this.computeOlp((IDocument)document, (int)offset, (int)length, (int)-1).partitions;
        }

        public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
            OLP olp = this.computeOlp(document, offset, length, partitionOffset);
            this.regions = olp.partitions;
            this.offsetOfPartitions = olp.offset;
            this.lengthOfPartitions = olp.length;
            this.index = -1;
        }

        private OLP computeOlp(IDocument document, int offset, int length, int partitionOffset) {
            if (this.markupLanguage == null) {
                return new OLP(offset, length, null);
            }
            int startOffset = partitionOffset == -1 ? offset : Math.min(offset, partitionOffset);
            int endOffset = offset + length;
            MarkupParser markupParser = new MarkupParser(this.markupLanguage);
            this.markupLanguage.setBlocksOnly(partitionOffset != -1);
            this.markupLanguage.setFilterGenerativeContents(true);
            PartitionBuilder partitionBuilder = new PartitionBuilder(startOffset, this.markupLanguage.isBlocksOnly());
            markupParser.setBuilder((DocumentBuilder)partitionBuilder);
            try {
                markupParser.parse(document.get(startOffset, endOffset - startOffset));
            }
            catch (BadLocationException badLocationException) {
                markupParser.parse(document.get());
            }
            ITypedRegion[] latestPartitions = partitionBuilder.partitions.toArray(new ITypedRegion[partitionBuilder.partitions.size()]);
            ArrayList<ITypedRegion> partitioning = new ArrayList<ITypedRegion>(latestPartitions.length);
            ITypedRegion previous = null;
            ITypedRegion[] iTypedRegionArray = latestPartitions;
            int n = latestPartitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion region = iTypedRegionArray[n2];
                if (region.getLength() != 0) {
                    if (previous != null && region.getOffset() < previous.getOffset() + previous.getLength()) {
                        throw new IllegalStateException();
                    }
                    previous = region;
                    if (region.getOffset() >= startOffset && region.getOffset() < endOffset) {
                        partitioning.add(region);
                    } else if (region.getOffset() >= offset + length) break;
                }
                ++n2;
            }
            return new OLP(offset, length, partitioning.toArray(new ITypedRegion[partitioning.size()]));
        }

        public void setMarkupLanguage(MarkupLanguage markupLanguage) {
            this.markupLanguage = markupLanguage;
        }

        public int getTokenLength() {
            return this.regions[this.index].getLength();
        }

        public int getTokenOffset() {
            return this.regions[this.index].getOffset();
        }

        public IToken nextToken() {
            if (this.regions == null || ++this.index >= this.regions.length) {
                return Token.EOF;
            }
            return new Token((Object)this.regions[this.index].getType());
        }

        public void setRange(IDocument document, int offset, int length) {
            this.setPartialRange(document, offset, length, null, -1);
        }

        private static class OLP {
            int offset;
            int length;
            ITypedRegion[] partitions;

            public OLP(int offset, int length, ITypedRegion[] partitions) {
                this.offset = offset;
                this.length = length;
                this.partitions = partitions;
            }
        }
    }
}

