/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.BulletAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class BulletDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        BulletAnnotation bullet = (BulletAnnotation)annotation;
        if (gc != null) {
            Color foreground = gc.getForeground();
            Color background = gc.getBackground();
            if (length < 1) {
                return;
            }
            Point left = textWidget.getLocationAtOffset(offset);
            Point right = textWidget.getLocationAtOffset(offset + length);
            if (left.x > right.x) {
                left.x = 0;
                left.y = right.y;
            }
            int baseline = textWidget.getBaseline(offset);
            int lineHeight = textWidget.getLineHeight(offset);
            int vcenter = left.y + baseline / 2 + baseline / 4;
            int hcenter = left.x + (right.x - left.x) / 2;
            gc.setLineWidth(0);
            gc.setLineStyle(1);
            gc.fillRectangle(left.x, left.y, right.x - left.x, lineHeight);
            switch (bullet.getIndentLevel()) {
                case 1: {
                    gc.setBackground(color);
                    gc.fillOval(hcenter - 3, vcenter - 2, 5, 5);
                    break;
                }
                case 2: {
                    gc.setForeground(color);
                    gc.drawOval(hcenter - 3, vcenter - 3, 5, 5);
                    break;
                }
                default: {
                    gc.setBackground(color);
                    gc.fillRectangle(hcenter - 3, vcenter - 2, 5, 5);
                }
            }
            gc.setForeground(foreground);
            gc.setBackground(background);
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }
}

