/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.sandbox.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryCompletionProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.util.PlatformUrlHyperlink;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.AnnotationHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class MarkupTaskEditorExtension
extends AbstractTaskEditorExtension {
    private static final String ID_CONTEXT_EDITOR_TASK = "org.eclipse.mylyn.tasks.ui.TaskEditor";
    private static final String ID_CONTEXT_EDITOR_TEXT = "org.eclipse.ui.DefaultTextEditor";
    private MarkupLanguage markupLanguage;

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public String getEditorContextId() {
        return "org.eclipse.mylyn.wikitext.ui.editor.markupSourceContext";
    }

    public SourceViewer createViewer(TaskRepository taskRepository, Composite parent, int style) {
        if (this.markupLanguage == null) {
            throw new IllegalStateException();
        }
        MarkupViewer markupViewer = new MarkupViewer(parent, null, style | 0x800000 | 0x40);
        MarkupLanguage markupLanguageCopy = this.markupLanguage.clone();
        this.configureMarkupLanguage(taskRepository, markupLanguageCopy);
        markupViewer.setMarkupLanguage(markupLanguageCopy);
        MarkupViewerConfiguration configuration = this.createViewerConfiguration(taskRepository, markupViewer);
        markupViewer.configure((SourceViewerConfiguration)configuration);
        markupViewer.setEditable(false);
        markupViewer.getTextWidget().setCaret(null);
        return markupViewer;
    }

    protected MarkupViewerConfiguration createViewerConfiguration(TaskRepository taskRepository, MarkupViewer markupViewer) {
        return new TaskMarkupViewerConfiguration(markupViewer, taskRepository);
    }

    public SourceViewer createEditor(TaskRepository taskRepository, Composite parent, int style) {
        final MarkupLanguage markupLanguageCopy = this.markupLanguage.clone();
        this.configureMarkupLanguage(taskRepository, markupLanguageCopy);
        SourceViewer viewer = new SourceViewer(parent, null, style | 0x40){

            public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
                if (document != null) {
                    this.configurePartitioning(document);
                }
                super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
            }

            private void configurePartitioning(IDocument document) {
                FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
                partitioner.setMarkupLanguage(markupLanguageCopy.clone());
                partitioner.connect(document);
                document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            }
        };
        TaskMarkupSourceViewerConfiguration configuration = new TaskMarkupSourceViewerConfiguration(EditorsUI.getPreferenceStore(), taskRepository);
        configuration.setMarkupLanguage(markupLanguageCopy);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.showAnnotations(true);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        for (AnnotationPreference preference : annotationPreferences.getAnnotationPreferences()) {
            support.setAnnotationPreference(preference);
        }
        support.setCursorLinePainterPreferenceKeys("currentLine", "currentLineColor");
        support.setMarginPainterPreferenceKeys("printMargin", "printMarginColor", "printMarginColumn");
        support.install(EditorsUI.getPreferenceStore());
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.dispose();
            }
        });
        IFocusService focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker((Control)viewer.getTextWidget(), "org.eclipse.mylyn.wikitext.ui.editor.sourceViewer");
        }
        viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)markupLanguageCopy);
        viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)viewer);
        return viewer;
    }

    private void configureMarkupLanguage(TaskRepository taskRepository, MarkupLanguage markupLanguage) {
        String internalLinkPattern = taskRepository.getProperty("wikiLinkPattern");
        if (internalLinkPattern != null && internalLinkPattern.trim().length() > 0) {
            markupLanguage.setInternalLinkPattern(internalLinkPattern.trim());
        }
    }

    private static void addRepositoryHyperlinkDetectorTargets(final TaskRepository taskRepository, Map hyperlinkDetectorTargets) {
        IAdaptable context = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter == TaskRepository.class) {
                    return taskRepository;
                }
                return null;
            }
        };
        hyperlinkDetectorTargets.put(ID_CONTEXT_EDITOR_TEXT, context);
        hyperlinkDetectorTargets.put(ID_CONTEXT_EDITOR_TASK, context);
    }

    private static class TaskHyperlinkPresenter
    extends DefaultHyperlinkPresenter {
        private IRegion activeRegion;
        private ITask currentTaskHyperlink;
        private final ISourceViewer sourceViewer;

        public TaskHyperlinkPresenter(ISourceViewer sourceViewer, IPreferenceStore store) {
            super(store);
            this.sourceViewer = sourceViewer;
        }

        public TaskHyperlinkPresenter(ISourceViewer sourceViewer, RGB color) {
            super(color);
            this.sourceViewer = sourceViewer;
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            super.applyTextPresentation(textPresentation);
            if (this.activeRegion != null && this.currentTaskHyperlink != null && this.currentTaskHyperlink.isCompleted()) {
                Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
                while (styleRangeIterator.hasNext()) {
                    StyleRange styleRange = (StyleRange)styleRangeIterator.next();
                    if (this.activeRegion.getOffset() != styleRange.start || this.activeRegion.getLength() != styleRange.length) continue;
                    styleRange.strikeout = true;
                    break;
                }
            }
        }

        public void showHyperlinks(IHyperlink[] hyperlinks) {
            this.activeRegion = null;
            if (hyperlinks != null && hyperlinks.length > 0 && hyperlinks[0] instanceof TaskHyperlink) {
                TaskHyperlink hyperlink = (TaskHyperlink)hyperlinks[0];
                ITask task = TasksUi.getRepositoryModel().getTask(hyperlink.getRepository(), hyperlink.getTaskId());
                if (task != null && task != this.currentTaskHyperlink) {
                    this.currentTaskHyperlink = task;
                    this.activeRegion = hyperlink.getHyperlinkRegion();
                    Control cursorControl = this.sourceViewer.getTextWidget().getDisplay().getCursorControl();
                    if (cursorControl != null) {
                        if (task.getTaskKey() == null) {
                            cursorControl.setToolTipText(task.getSummary());
                        } else {
                            cursorControl.setToolTipText(String.valueOf(task.getTaskKey()) + ": " + task.getSummary());
                        }
                    }
                }
            }
            super.showHyperlinks(hyperlinks);
        }

        public void hideHyperlinks() {
            if (this.currentTaskHyperlink != null) {
                Control cursorControl = this.sourceViewer.getTextWidget().getDisplay().getCursorControl();
                if (cursorControl != null) {
                    cursorControl.setToolTipText(null);
                }
                this.currentTaskHyperlink = null;
            }
            super.hideHyperlinks();
        }
    }

    protected static class TaskMarkupSourceViewerConfiguration
    extends MarkupSourceViewerConfiguration {
        private final TaskRepository taskRepository;

        public TaskMarkupSourceViewerConfiguration(IPreferenceStore preferenceStore, TaskRepository taskRepository) {
            super(preferenceStore);
            this.taskRepository = taskRepository;
        }

        protected IContentAssistProcessor[] createContentAssistProcessors() {
            return new IContentAssistProcessor[]{new RepositoryCompletionProcessor(this.taskRepository)};
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
            return new DefaultAnnotationHover(){

                protected boolean isIncluded(Annotation annotation) {
                    return annotation.getType().startsWith("org.eclipse.wikitext") || super.isIncluded(annotation);
                }
            };
        }

        protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            Map hyperlinkDetectorTargets = super.getHyperlinkDetectorTargets(sourceViewer);
            MarkupTaskEditorExtension.addRepositoryHyperlinkDetectorTargets(this.taskRepository, hyperlinkDetectorTargets);
            return hyperlinkDetectorTargets;
        }
    }

    protected static class TaskMarkupViewerConfiguration
    extends MarkupViewerConfiguration {
        private final TaskRepository taskRepository;

        public TaskMarkupViewerConfiguration(MarkupViewer viewer, TaskRepository taskRepository) {
            super(viewer);
            this.taskRepository = taskRepository;
        }

        protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            Map hyperlinkDetectorTargets = super.getHyperlinkDetectorTargets(sourceViewer);
            MarkupTaskEditorExtension.addRepositoryHyperlinkDetectorTargets(this.taskRepository, hyperlinkDetectorTargets);
            return hyperlinkDetectorTargets;
        }

        protected AnnotationHyperlinkDetector createAnnotationHyperlinkDetector() {
            return new AnnotationHyperlinkDetector(){

                protected IHyperlink createUrlHyperlink(IRegion region, String href) {
                    return new PlatformUrlHyperlink(region, href);
                }
            };
        }

        public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
            return 0;
        }

        public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
            if (this.fPreferenceStore == null) {
                return new TaskHyperlinkPresenter(sourceViewer, new RGB(0, 0, 255));
            }
            return new TaskHyperlinkPresenter(sourceViewer, this.fPreferenceStore);
        }
    }
}

