/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.core.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.xplanner.core.XPlannerCorePlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.core.service.XPlannerService;
import org.eclipse.mylyn.xplanner.core.service.XPlannerServiceFactory;

public class ServiceManager {
    private static XPlannerServiceFactory factory;

    public static synchronized XPlannerService getXPlannerService(XPlannerClient client) {
        if (factory == null) {
            factory = ServiceManager.loadServiceProviderFactories();
        }
        return factory.createService(client);
    }

    public static XPlannerServiceFactory loadServiceProviderFactories() {
        IExtensionPoint extension;
        XPlannerCorePlugin plugin = XPlannerCorePlugin.getDefault();
        if (plugin != null && (extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mylyn.xplanner.core", "serviceProviderFactory")) != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                if (configElements.length != 0) {
                    IConfigurationElement configElement = iConfigurationElementArray[0];
                    try {
                        return (XPlannerServiceFactory)configElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        plugin.getLog().log(e.getStatus());
                    }
                    catch (ClassCastException e) {
                        XPlannerCorePlugin.log(4, "Must implement the correct class", e);
                        XPlannerCorePlugin.log(4, "Must implement the correct class", e);
                    }
                    return null;
                }
                ++n2;
            }
        }
        return null;
    }
}

