/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.core.service.soap;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.FileProvider;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.core.service.XPlannerService;
import org.eclipse.mylyn.xplanner.core.service.exceptions.AuthenticationException;
import org.eclipse.mylyn.xplanner.core.service.exceptions.ServiceUnavailableException;
import org.eclipse.mylyn.xplanner.wsdl.db.QueryException;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.NoteData;
import org.xplanner.soap.PersonData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.TaskData;
import org.xplanner.soap.TimeEntryData;
import org.xplanner.soap.UserStoryData;
import org.xplanner.soap.XPlanner.XPlanner;
import org.xplanner.soap.XPlanner.XPlannerServiceLocator;

public class SoapXPlannerService
extends XPlannerService {
    private static final String SOAP_URL_PREFIX = "/soap/XPlanner";
    private final XPlannerClient client;
    private XPlanner service;
    boolean loginActive;

    public SoapXPlannerService(XPlannerClient aClient) {
        this.client = aClient;
        try {
            XPlannerServiceLocator s = new XPlannerServiceLocator((EngineConfiguration)new FileProvider(this.getClass().getClassLoader().getResourceAsStream("client-config.wsdd")));
            s.setHttpUser(this.client.getHttpUser());
            s.setHttpPassword(this.client.getHttpPassword());
            s.setProxy(this.client.getProxy());
            s.setCompression(this.client.useCompression());
            this.service = s.getXPlanner(new URL(String.valueOf(this.client.getBaseURL()) + SOAP_URL_PREFIX));
            this.login(this.client.getCurrentUserName(), this.client.getCurrentUserPassword());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String login(String username, String password) throws AuthenticationException, ServiceUnavailableException {
        ((Stub)this.service).setUsername(username);
        ((Stub)this.service).setPassword(password);
        this.loginActive = true;
        return null;
    }

    public boolean logout() throws ServiceUnavailableException {
        this.loginActive = false;
        return true;
    }

    public IterationData addIteration(IterationData iteration) throws RemoteException {
        return this.service.addIteration(iteration);
    }

    public NoteData addNote(NoteData note) throws RemoteException {
        return this.service.addNote(note);
    }

    public PersonData addPerson(PersonData object) throws RemoteException {
        return this.service.addPerson(object);
    }

    public ProjectData addProject(ProjectData project) throws RemoteException {
        return this.service.addProject(project);
    }

    public TaskData addTask(TaskData task) throws RemoteException {
        return this.service.addTask(task);
    }

    public TimeEntryData addTimeEntry(TimeEntryData timeEntry) throws RemoteException {
        return this.service.addTimeEntry(timeEntry);
    }

    public UserStoryData addUserStory(UserStoryData story) throws RemoteException {
        return this.service.addUserStory(story);
    }

    public void deleteAttribute(int objectId, String key) throws RemoteException {
        this.service.deleteAttribute(objectId, key);
    }

    public String getAttribute(int objectId, String key) throws RemoteException {
        return this.service.getAttribute(objectId, key);
    }

    public HashMap getAttributes(int objectId) throws RemoteException {
        return this.service.getAttributes(objectId);
    }

    public HashMap getAttributesWithPrefix(int objectId, String prefix) throws RemoteException {
        return this.service.getAttributesWithPrefix(objectId, prefix);
    }

    public IterationData getCurrentIteration(int projectId) throws RemoteException {
        return this.service.getCurrentIteration(projectId);
    }

    public TaskData[] getCurrentTasksForPerson(int personId) throws RemoteException, QueryException {
        return this.service.getCurrentTasksForPerson(personId);
    }

    public IterationData getIteration(int id) throws RemoteException {
        return this.service.getIteration(id);
    }

    public IterationData[] getIterations(int projectId) throws RemoteException {
        return this.service.getIterations(projectId);
    }

    public NoteData getNote(int id) throws RemoteException {
        return this.service.getNote(id);
    }

    public NoteData[] getNotesForObject(int attachedToId) throws RemoteException {
        return this.service.getNotesForObject(attachedToId);
    }

    public PersonData[] getPeople() throws RemoteException {
        return this.service.getPeople();
    }

    public PersonData getPerson(int id) throws RemoteException {
        return this.service.getPerson(id);
    }

    public TaskData[] getPlannedTasksForPerson(int personId) throws RemoteException, QueryException {
        return this.service.getPlannedTasksForPerson(personId);
    }

    public ProjectData getProject(int id) throws RemoteException {
        return this.service.getProject(id);
    }

    public ProjectData[] getProjects() throws RemoteException {
        return this.service.getProjects();
    }

    public TaskData getTask(int id) throws RemoteException {
        return this.service.getTask(id);
    }

    public TaskData[] getTasks(int containerId) throws RemoteException {
        return this.service.getTasks(containerId);
    }

    public TimeEntryData[] getTimeEntries(int containerId) throws RemoteException {
        return this.service.getTimeEntries(containerId);
    }

    public TimeEntryData getTimeEntry(int id) throws RemoteException {
        return this.service.getTimeEntry(id);
    }

    public UserStoryData[] getUserStories(int containerId) throws RemoteException {
        return this.service.getUserStories(containerId);
    }

    public UserStoryData getUserStory(int id) throws RemoteException {
        return this.service.getUserStory(id);
    }

    public void removeIteration(int id) throws RemoteException {
        this.service.removeIteration(id);
    }

    public void removeNote(int id) throws RemoteException {
        this.service.removeNote(id);
    }

    public void removePerson(int id) throws RemoteException {
        this.service.removePerson(id);
    }

    public void removeProject(int id) throws RemoteException {
        this.service.removeProject(id);
    }

    public void removeTask(int id) throws RemoteException {
        this.service.removeTask(id);
    }

    public void removeTimeEntry(int id) throws RemoteException {
        this.service.removeTimeEntry(id);
    }

    public void removeUserStory(int id) throws RemoteException {
        this.service.removeUserStory(id);
    }

    public void setAttribute(int objectId, String key, String value) throws RemoteException {
        this.service.setAttribute(objectId, key, value);
    }

    public void update(IterationData object) throws RemoteException {
        this.service.update(object);
    }

    public void update(NoteData note) throws RemoteException {
        this.service.update(note);
    }

    public void update(PersonData object) throws RemoteException {
        this.service.update(object);
    }

    public void update(ProjectData object) throws RemoteException {
        this.service.update(object);
    }

    public void update(TaskData object) throws RemoteException {
        this.service.update(object);
    }

    public void update(TimeEntryData object) throws RemoteException {
        this.service.update(object);
    }

    public void update(UserStoryData object) throws RemoteException {
        this.service.update(object);
    }
}

