/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.xplanner.ui.XPlannerAttributeMapper;
import org.eclipse.mylyn.xplanner.ui.XPlannerImages;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.xplanner.ui.wizard.EditXPlannerQueryWizard;
import org.eclipse.mylyn.xplanner.ui.wizard.Messages;
import org.eclipse.mylyn.xplanner.ui.wizard.NewXPlannerQueryWizard;
import org.eclipse.mylyn.xplanner.ui.wizard.NewXPlannerTaskWizard;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerCustomQueryPage;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerRepositorySettingsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerRepositoryUi
extends AbstractRepositoryConnectorUi {
    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new XPlannerRepositorySettingsPage(taskRepository);
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        XPlannerAttributeMapper.XPlannerTaskKind kind = XPlannerAttributeMapper.XPlannerTaskKind.fromString(task.getTaskKind());
        ImageDescriptor overlayImage = kind.equals((Object)XPlannerAttributeMapper.XPlannerTaskKind.TASK) ? XPlannerImages.OVERLAY_TASK : (kind.equals((Object)XPlannerAttributeMapper.XPlannerTaskKind.USER_STORY) ? XPlannerImages.OVERLAY_USER_STORY : super.getTaskKindOverlay(task));
        return overlayImage;
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        try {
            return new XPlannerCustomQueryPage(repository, null);
        }
        catch (RuntimeException e) {
            XPlannerMylynUIPlugin.log(e.getCause(), Messages.XPlannerQueryWizardUtils_COULD_NOT_CREATE_QUERY_PAGE_MESSAGE, true);
            return null;
        }
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        Object queryWizard = null;
        queryWizard = query != null ? new EditXPlannerQueryWizard(repository, query) : new NewXPlannerQueryWizard(repository);
        return queryWizard;
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        return new NewXPlannerTaskWizard(taskRepository);
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getTaskKindLabel(ITask repositoryTask) {
        return repositoryTask == null ? super.getTaskKindLabel(repositoryTask) : repositoryTask.getTaskKind();
    }

    public List<LegendElement> getLegendElements() {
        ArrayList<LegendElement> legendElements = new ArrayList<LegendElement>();
        legendElements.add(LegendElement.createTask((String)"Task", (ImageDescriptor)XPlannerImages.OVERLAY_TASK));
        legendElements.add(LegendElement.createTask((String)"User Story", (ImageDescriptor)XPlannerImages.OVERLAY_USER_STORY));
        return legendElements;
    }
}

