/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.IInteractionContextReader;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.SaxContextContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxContextReader
implements IInteractionContextReader {
    private IInteractionContextScaling contextScaling;

    public void setContextScaling(IInteractionContextScaling contextScaling) {
        this.contextScaling = contextScaling;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InteractionContext readContext(String handleIdentifier, File file) {
        ZipInputStream zipInputStream;
        FileInputStream fileInputStream;
        block8: {
            InteractionContext interactionContext;
            if (!file.exists()) {
                return null;
            }
            fileInputStream = null;
            zipInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                zipInputStream = new ZipInputStream(fileInputStream);
                String encoded = URLEncoder.encode(handleIdentifier, "UTF-8");
                String contextFileName = String.valueOf(encoded) + ".xml";
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null && !contextFileName.equals(entry.getName())) {
                    entry = zipInputStream.getNextEntry();
                }
                if (entry == null) {
                    break block8;
                }
            }
            catch (Throwable throwable) {
                try {
                    SaxContextReader.closeStream(zipInputStream);
                    SaxContextReader.closeStream(fileInputStream);
                    file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + "-save"));
                    break block8;
                }
                catch (Throwable throwable2) {
                    SaxContextReader.closeStream(zipInputStream);
                    SaxContextReader.closeStream(fileInputStream);
                    throw throwable2;
                }
            }
            {
                SaxContextContentHandler contentHandler = new SaxContextContentHandler(handleIdentifier, this.contextScaling);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(contentHandler);
                reader.parse(new InputSource(zipInputStream));
                interactionContext = contentHandler.getContext();
            }
            SaxContextReader.closeStream(zipInputStream);
            SaxContextReader.closeStream(fileInputStream);
            return interactionContext;
        }
        SaxContextReader.closeStream(zipInputStream);
        SaxContextReader.closeStream(fileInputStream);
        return null;
    }

    private static final void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Failed to close context input", (Throwable)e));
            }
        }
    }
}

