/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.wizards;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.ViewUsageCollector;
import org.eclipse.mylyn.internal.monitor.usage.MonitorFileRolloverJob;
import org.eclipse.mylyn.internal.monitor.usage.collectors.PerspectiveUsageCollector;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSummaryEditorWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewUsageSummaryEditorWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "New Usage Summary Report";
    private UsageSummaryEditorWizardPage usageSummaryPage;

    public NewUsageSummaryEditorWizard() {
        this.init();
        this.setWindowTitle(TITLE);
    }

    private void init() {
        this.usageSummaryPage = new UsageSummaryEditorWizardPage();
    }

    public boolean performFinish() {
        if (!this.usageSummaryPage.includePerspective() && !this.usageSummaryPage.includeViews()) {
            return false;
        }
        ArrayList<IUsageCollector> collectors = new ArrayList<IUsageCollector>();
        if (this.usageSummaryPage.includePerspective()) {
            collectors.add(new PerspectiveUsageCollector());
        }
        if (this.usageSummaryPage.includeViews()) {
            ViewUsageCollector mylynViewUsageCollector = new ViewUsageCollector();
            collectors.add((IUsageCollector)mylynViewUsageCollector);
        }
        MonitorFileRolloverJob job = new MonitorFileRolloverJob(collectors);
        job.setPriority(30);
        job.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage(this.usageSummaryPage);
    }
}

