/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearch;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaReportInfo;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaSearchEngine;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.IBugzillaSearchOperation;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.MylynBugsManager;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.ProgressQueryHitCollector;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.Util;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.ITaskFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.TaskFactory;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractRepositorySearchQuery;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaMylynSearchOperation
extends WorkspaceModifyOperation
implements IBugzillaSearchOperation {
    private final IMember javaElement;
    private ProgressQueryHitCollector collector = null;
    private IStatus status;
    private LoginException loginException = null;
    private final String name;
    private AbstractRepositorySearchQuery query;
    private final BugzillaMylynSearch search;
    private final int scope;

    public BugzillaMylynSearchOperation(BugzillaMylynSearch search, IMember m, int scope) {
        this.javaElement = m;
        this.search = search;
        this.scope = scope;
        this.name = BugzillaMylynSearchOperation.getFullyQualifiedName((IJavaElement)m);
    }

    public static String getFullyQualifiedName(IJavaElement je) {
        if (!(je instanceof IMember)) {
            return null;
        }
        IMember m = (IMember)je;
        if (m.getDeclaringType() == null) {
            return ((IType)m).getFullyQualifiedName();
        }
        return String.valueOf(m.getDeclaringType().getFullyQualifiedName()) + "." + m.getElementName();
    }

    public void execute(IProgressMonitor monitor) {
        ProgressQueryHitCollector searchCollector = null;
        if (this.scope == 3) {
            searchCollector = this.searchQualified(this.search.getServerUrl(), monitor);
        } else if (this.scope == 4) {
            searchCollector = this.searchUnqualified(this.search.getServerUrl(), monitor);
        } else if (this.scope == 1) {
            searchCollector = this.searchLocalQual(monitor);
        } else if (this.scope == 2) {
            searchCollector = this.searchLocalUnQual(monitor);
        } else {
            this.status = Status.OK_STATUS;
            return;
        }
        if (searchCollector == null) {
            this.search.notifySearchCompleted(new ArrayList<BugzillaReportInfo>());
            return;
        }
        Set<AbstractTask> l = searchCollector.getTasks();
        List<BugzillaReportInfo> doiList = this.getDoiList(l);
        MylynBugsManager.getBridge().addToLandmarksHash(doiList, this.javaElement, this.scope);
        this.search.notifySearchCompleted(doiList);
    }

    private ProgressQueryHitCollector searchLocalQual(IProgressMonitor monitor) {
        String elementName = BugzillaMylynSearchOperation.getFullyQualifiedName((IJavaElement)this.javaElement);
        this.collector = new ProgressQueryHitCollector(TasksUiInternal.getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        HashSet<ITask> tasks = new HashSet<ITask>();
        this.searchLocal(tasks, this.collector, elementName, monitor);
        for (AbstractTaskCategory cat : TasksUiPlugin.getTaskList().getTaskCategories()) {
            this.searchLocal(cat.getChildren(), this.collector, elementName, monitor);
        }
        return this.collector;
    }

    private ProgressQueryHitCollector searchLocalUnQual(IProgressMonitor monitor) {
        String elementName = this.javaElement.getElementName();
        this.collector = new ProgressQueryHitCollector(TasksUiInternal.getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        HashSet<ITask> tasks = new HashSet<ITask>();
        this.searchLocal(tasks, this.collector, elementName, monitor);
        for (AbstractTaskCategory cat : TasksUiPlugin.getTaskList().getTaskCategories()) {
            this.searchLocal(cat.getChildren(), this.collector, elementName, monitor);
        }
        return this.collector;
    }

    private void searchLocal(Collection<ITask> tasks, ProgressQueryHitCollector searchCollector, String elementName, IProgressMonitor monitor) {
        if (tasks == null) {
            return;
        }
        for (ITask task : tasks) {
            monitor.worked(1);
            RepositoryTaskData bugTaskData = TasksUiPlugin.getTaskDataStorageManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
            boolean bl = this.search(elementName, bugTaskData);
        }
        this.status = Status.OK_STATUS;
    }

    private boolean search(String elementName, RepositoryTaskData bug) {
        if (bug == null) {
            return false;
        }
        String description = bug.getDescription();
        String summary = bug.getSummary();
        List taskComments = bug.getComments();
        if (Util.hasElementName(elementName, summary)) {
            return true;
        }
        if (Util.hasElementName(elementName, description)) {
            return true;
        }
        for (TaskComment taskComment : taskComments) {
            String commentText = taskComment.getText();
            if (!Util.hasElementName(elementName, commentText)) continue;
            return true;
        }
        return false;
    }

    private ProgressQueryHitCollector search(String url, TaskRepository repository, ProgressQueryHitCollector searchCollector, IProgressMonitor monitor) {
        block5: {
            block4: {
                int matches = 0;
                searchCollector.setProgressMonitor(monitor);
                BugzillaSearchEngine engine = new BugzillaSearchEngine(repository, url);
                try {
                    this.status = engine.search(searchCollector, matches);
                    if (this.status.getCode() != 8) break block4;
                    return null;
                }
                catch (LoginException e) {
                    this.loginException = e;
                    return null;
                }
            }
            if (this.status.isOK()) break block5;
            MultiStatus errorStatus = new MultiStatus("org.eclipse.mylyn.sandbox.ui", 0, "Search error", null);
            errorStatus.add(this.status);
            StatusHandler.fail((IStatus)errorStatus);
            return null;
        }
        return searchCollector;
    }

    private ProgressQueryHitCollector searchQualified(String repositoryUrl, IProgressMonitor monitor) {
        this.collector = new ProgressQueryHitCollector(TasksUiInternal.getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        String url = Util.getExactSearchURL(repositoryUrl, this.javaElement);
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("bugzilla", repositoryUrl);
        return this.search(url, repository, this.collector, monitor);
    }

    private ProgressQueryHitCollector searchUnqualified(String repositoryUrl, IProgressMonitor monitor) {
        this.collector = new ProgressQueryHitCollector(TasksUiInternal.getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        String url = Util.getInexactSearchURL(repositoryUrl, this.javaElement);
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository("bugzilla", repositoryUrl);
        return this.search(url, repository, this.collector, monitor);
    }

    public static void secondPassBugzillaParser(List<BugzillaReportInfo> doiList) {
        for (BugzillaReportInfo info : doiList) {
            TaskData b = null;
            try {
                b = info.getBug();
            }
            catch (Exception exception) {}
            if (b != null) continue;
        }
    }

    private List<BugzillaReportInfo> getDoiList(Set<AbstractTask> results) {
        ArrayList<BugzillaReportInfo> doiList = new ArrayList<BugzillaReportInfo>();
        boolean isExact = this.scope == 3 || this.scope == 1;
        BugzillaReportInfo info = null;
        for (ITask iTask : results) {
            try {
                try {
                    float value = 0.0f;
                    info = new BugzillaReportInfo(value, iTask, isExact);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.sandbox.ui", "Search failed", (Throwable)e));
                    doiList.add(info);
                    continue;
                }
            }
            catch (Throwable throwable) {
                doiList.add(info);
                throw throwable;
            }
            doiList.add(info);
        }
        return doiList;
    }

    @Override
    public IStatus getStatus() throws LoginException {
        if (this.loginException == null) {
            return this.status;
        }
        throw this.loginException;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IMember getSearchMember() {
        return this.javaElement;
    }

    public String getSearchMemberName() {
        return this.name;
    }

    @Override
    public AbstractRepositorySearchQuery getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(AbstractRepositorySearchQuery newQuery) {
        this.query = newQuery;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getScope() {
        return this.scope;
    }
}

