/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.StackTrace;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaReportInfo {
    private static final int MAX_LABEL_LENGTH = 150;
    private static final long serialVersionUID = 3257004367222419506L;
    private final ITask hit;
    private boolean isExact = false;
    private final List<StackTrace> stackTraces;
    private TaskData bug;

    public BugzillaReportInfo(float initialValue, ITask hit, boolean isExact) {
        this.hit = hit;
        this.isExact = isExact;
        this.bug = null;
        this.stackTraces = new ArrayList<StackTrace>();
    }

    public ITask getHit() {
        return this.hit;
    }

    public String toString() {
        return this.hit.toString();
    }

    public boolean isExact() {
        return this.isExact;
    }

    public void setExact(boolean isExact) {
        this.isExact = isExact;
    }

    public TaskData getBug() throws CoreException {
        if (this.bug == null) {
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository("bugzilla", this.hit.getRepositoryUrl());
            BugzillaRepositoryConnector bugzillaConnector = (BugzillaRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("bugzilla");
            BugzillaTaskDataHandler handler = new BugzillaTaskDataHandler(bugzillaConnector);
            this.bug = handler.getTaskData(repository, this.hit.getTaskId(), (IProgressMonitor)new NullProgressMonitor());
        }
        return this.bug;
    }

    public void setBug(TaskData bug) {
        this.bug = bug;
    }

    public List<StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public boolean hasStackTraces() {
        return !this.stackTraces.isEmpty();
    }

    public void addStackTrace(StackTrace stackTrace) {
        this.stackTraces.add(stackTrace);
    }

    public void addStackTraces(StackTrace[] stackTracesToAdd) {
        StackTrace[] stackTraceArray = stackTracesToAdd;
        int n = stackTracesToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            StackTrace element = stackTraceArray[n2];
            this.stackTraces.add(element);
            ++n2;
        }
    }

    public String getName() {
        String description = this.hit.getSummary();
        int length = description.length();
        if (length > 150) {
            description = String.valueOf(description.substring(0, 150)) + "..";
        }
        return "bug " + this.hit.getTaskId() + ": " + description;
    }

    public String getElementHandle() {
        return String.valueOf(this.hit.getRepositoryUrl()) + ";" + this.hit.getTaskId();
    }
}

