/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.ProgressQueryHitCollector;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class BugzillaSearchEngine {
    protected static final String QUERYING_SERVER = "Querying Bugzilla Server...";
    public static final Pattern reValue = Pattern.compile("<td><nobr>([^<]*)</nobr>");
    public static final Pattern reValueBugzilla220 = Pattern.compile("<td style=\"white-space: nowrap\">([^<]*)");
    private final TaskRepository repository;
    private final boolean maxReached = false;

    public BugzillaSearchEngine(TaskRepository repository, String queryUrl) {
        this.repository = repository;
    }

    public IStatus search(ProgressQueryHitCollector collector) throws LoginException {
        return this.search(collector, 0, -1);
    }

    public IStatus search(ProgressQueryHitCollector collector, int startMatches) throws LoginException {
        return this.search(collector, startMatches, BugzillaUiPlugin.getDefault().getMaxResults());
    }

    /*
     * Loose catch block
     */
    public IStatus search(ProgressQueryHitCollector collector, int startMatches, int maxHits) throws LoginException {
        Status status;
        block24: {
            IProgressMonitor monitor = collector.getProgressMonitor();
            status = null;
            boolean possibleBadLogin = false;
            boolean numCollected = false;
            BufferedReader in = null;
            try {
                monitor.beginTask(QUERYING_SERVER, maxHits);
                collector.aboutToStart(startMatches);
                throw new OperationCanceledException("Bugzilla Active Searchn not implemented");
            }
            catch (CoreException e) {
                status = new MultiStatus("org.eclipse.mylyn.bugzilla.ui", 4, "Core Exception occurred while querying Bugzilla Server " + this.repository.getRepositoryUrl() + ".\n" + "\nClick Details for more information.", (Throwable)e);
                ((MultiStatus)status).add(e.getStatus());
                BugzillaCorePlugin.log((IStatus)status);
                if (monitor != null) {
                    monitor.done();
                }
                collector.done();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    BugzillaCorePlugin.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", 4, "Problem closing the stream", (Throwable)e2));
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                status = new Status(8, "org.eclipse.mylyn.bugzilla.ui", 8, "", null);
            }
            catch (Exception e) {
                block23: {
                    status = new MultiStatus("org.eclipse.mylyn.bugzilla.ui", 4, "An error occurred while querying Bugzilla Server " + this.repository.getRepositoryUrl() + ".\n" + "\nCheck network connection and repository configuration in " + "Task Repositories" + ".", (Throwable)e);
                    Status s = new Status(4, "org.eclipse.mylyn.bugzilla.ui", 4, String.valueOf(e.getClass().toString()) + ":  ", (Throwable)e);
                    ((MultiStatus)status).add((IStatus)s);
                    s = new Status(4, "org.eclipse.mylyn.bugzilla.ui", 0, "search failed", (Throwable)e);
                    ((MultiStatus)status).add((IStatus)s);
                    if (monitor == null) break block23;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    monitor.done();
                }
                collector.done();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e3) {
                    BugzillaCorePlugin.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", 4, "Problem closing the stream", (Throwable)e3));
                }
            }
            {
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                    collector.done();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        BugzillaCorePlugin.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", 4, "Problem closing the stream", (Throwable)e));
                    }
                }
            }
            if (numCollected || !possibleBadLogin) break block24;
            throw new LoginException("Bugzilla login information or repository version incorrect for repository: " + this.repository.getRepositoryUrl() + " username: " + this.repository.getUserName());
        }
        if (status == null) {
            return new Status(0, "org.eclipse.mylyn.bugzilla.ui", 0, "", null);
        }
        return status;
    }

    public boolean isMaxReached() {
        return false;
    }
}

