/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.deprecated.ITaskFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.LegacyTaskDataCollector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressQueryHitCollector
extends LegacyTaskDataCollector {
    public static final int MAX_HITS = 5000;
    public static final String MAX_HITS_REACHED = "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.";
    protected Set<AbstractTask> taskResults = new HashSet<AbstractTask>();
    private IProgressMonitor monitor = new NullProgressMonitor();
    private int matchCount;
    private static final String STARTING = "querying the server";
    private static final String MATCH = "1 match";
    private static final String MATCHES = "{0} matches";
    private static final String DONE = "done";
    protected ITaskList taskList;
    protected ITaskFactory taskFactory;

    public ProgressQueryHitCollector(ITaskList tasklist, ITaskFactory taskFactory) {
        this.taskList = tasklist;
        this.taskFactory = taskFactory;
    }

    public void aboutToStart(int startMatchCount) throws CoreException {
        this.taskResults.clear();
        this.matchCount = startMatchCount;
        this.monitor.setTaskName(STARTING);
    }

    public void accept(RepositoryTaskData taskData) {
        if (taskData == null) {
            return;
        }
        if (!this.getProgressMonitor().isCanceled()) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.matchCount));
            this.getProgressMonitor().worked(1);
        }
        try {
            AbstractTask task = this.taskFactory.createTask(taskData, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            this.taskResults.add(task);
            ++this.matchCount;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void done() {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.matchCount);
            this.monitor.setTaskName(MessageFormat.format(DONE, matchesString));
            this.monitor.done();
        }
        this.monitor = null;
    }

    protected String getFormattedMatchesString(int count) {
        if (count == 1) {
            return MATCH;
        }
        Object[] messageFormatArgs = new Object[]{new Integer(count)};
        return MessageFormat.format(MATCHES, messageFormatArgs);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public Set<AbstractTask> getTasks() {
        return this.taskResults;
    }

    public void clear() {
        this.taskResults.clear();
    }
}

