/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.sandbox.ui.ActiveSearchViewTracker;
import org.eclipse.mylyn.internal.sandbox.ui.InterestInducingProblemListener;
import org.eclipse.mylyn.internal.sandbox.ui.SharedDataDirectoryManager;
import org.eclipse.mylyn.internal.sandbox.ui.highlighters.Highlighter;
import org.eclipse.mylyn.internal.sandbox.ui.highlighters.HighlighterList;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SandboxUiPlugin
extends AbstractUIPlugin {
    public static final String HIGHLIGHTER_PREFIX = "org.eclipse.mylyn.ui.interest.highlighters";
    public static final String TASK_HIGHLIGHTER_PREFIX = "org.eclipse.mylyn.ui.interest.highlighters.task.";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.sandbox.ui";
    private static SandboxUiPlugin plugin;
    private final SharedDataDirectoryManager sharedDataDirectoryManager = new SharedDataDirectoryManager();
    public static final String OVERLAYS_INCOMING_TIGHT = "org.eclipse.mylyn.tasks.ui.overlays.incoming.tight";
    private final ActiveSearchViewTracker activeSearchViewTracker = new ActiveSearchViewTracker();
    private InterestInducingProblemListener problemListener;
    private HighlighterList highlighters;

    public SandboxUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.java.ui.interest.prediction.errors", false);
        this.problemListener = new InterestInducingProblemListener();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.problemListener);
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors")) {
            this.problemListener.enable();
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow[] windows;
                    workbench.addWindowListener((IWindowListener)SandboxUiPlugin.this.activeSearchViewTracker);
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage[] pages;
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        window.addPageListener((IPageListener)SandboxUiPlugin.this.activeSearchViewTracker);
                        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                        int n3 = pages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            page.addPartListener((IPartListener2)SandboxUiPlugin.this.activeSearchViewTracker);
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, SandboxUiPlugin.ID_PLUGIN, "Sandbox UI initialization failed", (Throwable)e));
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        IWorkbench workbench;
        if (this.highlighters != null) {
            this.highlighters.dispose();
            this.highlighters = null;
        }
        if (this.problemListener != null) {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.problemListener);
        }
        if ((workbench = PlatformUI.getWorkbench()) != null) {
            IWorkbenchWindow[] windows;
            workbench.removeWindowListener((IWindowListener)this.activeSearchViewTracker);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] pages = window.getPages();
                window.removePageListener((IPageListener)this.activeSearchViewTracker);
                IWorkbenchPage[] iWorkbenchPageArray = pages;
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    page.removePartListener((IPartListener2)this.activeSearchViewTracker);
                    ++n4;
                }
                ++n2;
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static SandboxUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.internal.sandbox", (String)path);
    }

    public SharedDataDirectoryManager getSharedDataDirectoryManager() {
        return this.sharedDataDirectoryManager;
    }

    private void initializeHighlighters() {
        String hlist = this.getPreferenceStore().getString(HIGHLIGHTER_PREFIX);
        if (hlist.equals("")) {
            hlist = ContextUiPlugin.getDefault().getPreferenceStore().getString(HIGHLIGHTER_PREFIX);
            this.getPreferenceStore().setValue(HIGHLIGHTER_PREFIX, hlist);
            ContextUiPlugin.getDefault().getPreferenceStore().setToDefault(HIGHLIGHTER_PREFIX);
        }
        if (hlist != null && hlist.length() != 0) {
            this.highlighters = new HighlighterList(hlist);
        } else {
            this.highlighters = new HighlighterList();
            this.highlighters.setToDefaultList();
        }
    }

    public HighlighterList getHighlighterList() {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters;
    }

    public List<Highlighter> getHighlighters() {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters.getHighlighters();
    }

    public Highlighter getHighlighter(String name) {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters.getHighlighter(name);
    }

    public Highlighter getHighlighterForContextId(String id) {
        String prefId = TASK_HIGHLIGHTER_PREFIX + id;
        String highlighterName = this.getPreferenceStore().getString(prefId);
        if (highlighterName.equals("")) {
            highlighterName = ContextUiPlugin.getDefault().getPreferenceStore().getString(prefId);
            this.getPreferenceStore().setValue(prefId, highlighterName);
            ContextUiPlugin.getDefault().getPreferenceStore().setToDefault(prefId);
        }
        return this.getHighlighter(highlighterName);
    }

    public void setHighlighterMapping(String id, String name) {
        String prefId = TASK_HIGHLIGHTER_PREFIX + id;
        this.getPreferenceStore().putValue(prefId, name);
    }
}

