/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.DoiOrderSorter;
import org.eclipse.mylyn.internal.context.ui.views.ContextContentProvider;
import org.eclipse.mylyn.internal.context.ui.views.ContextNodeOpenListener;
import org.eclipse.mylyn.internal.sandbox.ui.DelegatingContextLabelProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ActiveSearchQuickView {
    private static final String STORE_DISABLE_RESTORE_SIZE = "DISABLE_RESTORE_SIZE";
    private static final String STORE_DISABLE_RESTORE_LOCATION = "DISABLE_RESTORE_LOCATION";
    private static final String STORE_LOCATION_X = "location.x";
    private static final String STORE_LOCATION_Y = "location.y";
    private static final String STORE_SIZE_WIDTH = "size.width";
    private static final String STORE_SIZE_HEIGHT = "size.height";
    private static final String sectionName = "org.eclipse.contribution.internal.xref.QuickXRef";
    private Text filterText;
    private Font statusTextFont;
    private Rectangle bounds;
    private Rectangle trim;
    private ToolBar toolBar;
    private MenuManager viewMenuManager;
    private boolean isDeactivateListenerActive = false;
    private Composite composite;
    private Composite viewMenuButtonComposite;
    private final int shellStyle;
    private Listener deactivateListener;
    private Shell parentShell;
    private Shell dialogShell;
    private TreeViewer viewer;

    public ActiveSearchQuickView(Shell parent) {
        this.parentShell = parent;
        this.shellStyle = 16;
    }

    public void open(IInteractionElement focusNode) {
        if (this.dialogShell != null) {
            this.close();
        }
        this.createShell();
        this.createComposites();
        this.filterText = this.createFilterText(this.viewMenuButtonComposite);
        this.createViewMenu(this.viewMenuButtonComposite);
        this.createHorizontalSeparator(this.composite);
        this.viewer = this.createTreeViewer(this.composite, 768);
        this.addListenersToTree(this.viewer);
        this.viewMenuButtonComposite.setTabList(new Control[]{this.filterText});
        this.composite.setTabList(new Control[]{this.viewMenuButtonComposite, this.viewer.getTree()});
        this.setInfoSystemColor();
        this.installFilter();
        this.addListenersToShell();
        this.viewer.addOpenListener((IOpenListener)new ContextNodeOpenListener((Viewer)this.viewer));
        this.viewer.setSorter((ViewerSorter)new DoiOrderSorter());
        this.createContents();
        this.initializeBounds();
        this.viewer.expandToLevel((Object)focusNode, 3);
        this.dialogShell.open();
    }

    private void createShell() {
        this.dialogShell = new Shell(this.parentShell, this.shellStyle);
        this.dialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                event.doit = false;
                ActiveSearchQuickView.this.close();
            }
        });
        Display display = this.dialogShell.getDisplay();
        this.dialogShell.setBackground(display.getSystemColor(2));
        int border = (this.shellStyle & 8) == 0 ? 0 : 1;
        this.dialogShell.setLayout((Layout)new BorderFillLayout(border));
    }

    private void createComposites() {
        this.composite = new Composite((Composite)this.dialogShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(768));
        this.viewMenuButtonComposite = new Composite(this.composite, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewMenuButtonComposite.setLayout((Layout)layout);
        this.viewMenuButtonComposite.setLayoutData((Object)new GridData(768));
    }

    private TreeViewer createTreeViewer(Composite parent, int style) {
        this.viewer = new TreeViewer(parent, 4 | style & 0xFFFFFFFD);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ContextContentProvider(this.dialogShell, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new DelegatingContextLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.addFilter((ViewerFilter)new NamePatternFilter());
        this.viewer.setInput((Object)this.dialogShell);
        return this.viewer;
    }

    private void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void setInfoSystemColor() {
        Display display = this.dialogShell.getDisplay();
        this.viewer.getTree().setForeground(display.getSystemColor(28));
        this.filterText.setForeground(display.getSystemColor(28));
        this.composite.setForeground(display.getSystemColor(28));
        this.viewMenuButtonComposite.setForeground(display.getSystemColor(28));
        this.toolBar.setForeground(display.getSystemColor(28));
        this.viewer.getTree().setBackground(display.getSystemColor(29));
        this.filterText.setBackground(display.getSystemColor(29));
        this.composite.setBackground(display.getSystemColor(29));
        this.viewMenuButtonComposite.setBackground(display.getSystemColor(29));
        this.toolBar.setBackground(display.getSystemColor(29));
    }

    private void addListenersToTree(TreeViewer treeViewer) {
        final Tree tree = treeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    ActiveSearchQuickView.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = ActiveSearchQuickView.this.viewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = ActiveSearchQuickView.this.viewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        ActiveSearchQuickView.this.gotoSelectedElement();
                    }
                }
            }
        });
    }

    private void addListenersToShell() {
        this.dialogShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ActiveSearchQuickView.this.close();
                if (ActiveSearchQuickView.this.statusTextFont != null && !ActiveSearchQuickView.this.statusTextFont.isDisposed()) {
                    ActiveSearchQuickView.this.statusTextFont.dispose();
                }
                ActiveSearchQuickView.this.dialogShell = null;
                ActiveSearchQuickView.this.viewer = null;
                ActiveSearchQuickView.this.composite = null;
                ActiveSearchQuickView.this.filterText = null;
                ActiveSearchQuickView.this.statusTextFont = null;
            }
        });
        this.deactivateListener = new Listener(){

            public void handleEvent(Event event) {
                if (ActiveSearchQuickView.this.isDeactivateListenerActive) {
                    ActiveSearchQuickView.this.dispose();
                }
            }
        };
        this.dialogShell.addListener(27, this.deactivateListener);
        this.isDeactivateListenerActive = true;
        this.dialogShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (e.widget == ActiveSearchQuickView.this.dialogShell && ActiveSearchQuickView.this.dialogShell.getShells().length == 0) {
                    ActiveSearchQuickView.this.isDeactivateListenerActive = true;
                }
            }
        });
        this.dialogShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                ActiveSearchQuickView.this.bounds = ActiveSearchQuickView.this.dialogShell.getBounds();
                if (ActiveSearchQuickView.this.trim != null) {
                    Point location = ActiveSearchQuickView.this.composite.getLocation();
                    ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.x = ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.x - ((ActiveSearchQuickView)ActiveSearchQuickView.this).trim.x + location.x;
                    ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.y = ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.y - ((ActiveSearchQuickView)ActiveSearchQuickView.this).trim.y + location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                ActiveSearchQuickView.this.bounds = ActiveSearchQuickView.this.dialogShell.getBounds();
                if (ActiveSearchQuickView.this.trim != null) {
                    Point location = ActiveSearchQuickView.this.composite.getLocation();
                    ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.x = ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.x - ((ActiveSearchQuickView)ActiveSearchQuickView.this).trim.x + location.x;
                    ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.y = ((ActiveSearchQuickView)ActiveSearchQuickView.this).bounds.y - ((ActiveSearchQuickView)ActiveSearchQuickView.this).trim.y + location.y;
                }
            }
        });
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        ToolItem viewMenuToolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.verticalAlignment = 1;
        this.toolBar.setLayoutData((Object)data);
        viewMenuToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActiveSearchQuickView.this.showViewMenu();
            }
        });
    }

    private void showViewMenu() {
        this.isDeactivateListenerActive = false;
        Menu aMenu = this.getViewMenuManager().createContextMenu((Control)this.dialogShell);
        Rectangle toolbarBounds = this.toolBar.getBounds();
        Point topLeft = new Point(toolbarBounds.x, toolbarBounds.y + toolbarBounds.height);
        topLeft = this.dialogShell.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.setVisible(true);
    }

    private MenuManager getViewMenuManager() {
        if (this.viewMenuManager == null) {
            this.viewMenuManager = new MenuManager();
            this.fillViewMenu((IMenuManager)this.viewMenuManager);
        }
        return this.viewMenuManager;
    }

    private void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new GroupMarker("SystemMenuStart"));
        viewMenu.add((IAction)new MoveAction());
        viewMenu.add((IAction)new ResizeAction());
        viewMenu.add((IAction)new RememberBoundsAction());
        viewMenu.add((IContributionItem)new Separator("SystemMenuEnd"));
    }

    private void initializeBounds() {
        Rectangle oldBounds = this.restoreBounds();
        if (oldBounds != null) {
            this.dialogShell.setBounds(oldBounds);
            return;
        }
        Point size = this.dialogShell.computeSize(-1, -1, true);
        Point location = this.getDefaultLocation(size);
        this.dialogShell.setBounds(new Rectangle(location.x, location.y, size.x, size.y));
    }

    private Point getDefaultLocation(Point initialSize) {
        Monitor monitor = this.dialogShell.getDisplay().getPrimaryMonitor();
        if (this.parentShell != null) {
            monitor = this.parentShell.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = this.parentShell != null ? Geometry.centerPoint((Rectangle)this.parentShell.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = ContextUiPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = ContextUiPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    private void storeBounds() {
        boolean controlRestoresLocation;
        IDialogSettings dialogSettings = this.getDialogSettings();
        boolean controlRestoresSize = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_SIZE);
        boolean bl = controlRestoresLocation = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_LOCATION);
        if (this.bounds == null) {
            return;
        }
        if (controlRestoresSize) {
            dialogSettings.put(STORE_SIZE_WIDTH, this.bounds.width);
            dialogSettings.put(STORE_SIZE_HEIGHT, this.bounds.height);
        }
        if (controlRestoresLocation) {
            dialogSettings.put(STORE_LOCATION_X, this.bounds.x);
            dialogSettings.put(STORE_LOCATION_Y, this.bounds.y);
        }
    }

    private Rectangle restoreBounds() {
        boolean controlRestoresLocation;
        IDialogSettings dialogSettings = this.getDialogSettings();
        boolean controlRestoresSize = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_SIZE);
        boolean bl = controlRestoresLocation = !dialogSettings.getBoolean(STORE_DISABLE_RESTORE_LOCATION);
        if (controlRestoresSize) {
            try {
                this.bounds.width = dialogSettings.getInt(STORE_SIZE_WIDTH);
                this.bounds.height = dialogSettings.getInt(STORE_SIZE_HEIGHT);
            }
            catch (NumberFormatException numberFormatException) {
                this.bounds.width = -1;
                this.bounds.height = -1;
            }
        }
        if (controlRestoresLocation) {
            try {
                this.bounds.x = dialogSettings.getInt(STORE_LOCATION_X);
                this.bounds.y = dialogSettings.getInt(STORE_LOCATION_Y);
            }
            catch (NumberFormatException numberFormatException) {
                this.bounds.x = -1;
                this.bounds.y = -1;
            }
        }
        if (this.bounds.x == -1 && this.bounds.y == -1 && this.bounds.width == -1 && this.bounds.height == -1) {
            return null;
        }
        Rectangle maxBounds = null;
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            maxBounds = this.dialogShell.getDisplay().getBounds();
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                maxBounds = display.getBounds();
            }
        }
        if (this.bounds.width > -1 && this.bounds.height > -1) {
            if (maxBounds != null) {
                this.bounds.width = Math.min(this.bounds.width, maxBounds.width);
                this.bounds.height = Math.min(this.bounds.height, maxBounds.height);
            }
            this.bounds.width = Math.max(this.bounds.width, 30);
            this.bounds.height = Math.max(this.bounds.height, 30);
        }
        if (this.bounds.x > -1 && this.bounds.y > -1 && maxBounds != null) {
            this.bounds.x = Math.max(this.bounds.x, maxBounds.x);
            this.bounds.y = Math.max(this.bounds.y, maxBounds.y);
            if (this.bounds.width > -1 && this.bounds.height > -1) {
                this.bounds.x = Math.min(this.bounds.x, maxBounds.width - this.bounds.width);
                this.bounds.y = Math.min(this.bounds.y, maxBounds.height - this.bounds.height);
            }
        }
        return this.bounds;
    }

    private Text createFilterText(Composite parent) {
        this.filterText = new Text(parent, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    ActiveSearchQuickView.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    ActiveSearchQuickView.this.viewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    ActiveSearchQuickView.this.viewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    ActiveSearchQuickView.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.filterText;
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        boolean cfr_ignored_0 = selectedElement instanceof IStructuredSelection;
    }

    private Object getSelectedElement() {
        if (this.viewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    private void installFilter() {
        this.filterText.setText("");
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
    }

    public void close() {
        this.storeBounds();
        this.toolBar = null;
        this.viewMenuManager = null;
    }

    public void dispose() {
        this.filterText = null;
        if (this.dialogShell != null) {
            if (!this.dialogShell.isDisposed()) {
                this.dialogShell.dispose();
            }
            this.dialogShell = null;
            this.parentShell = null;
            this.viewer = null;
            this.composite = null;
        }
    }

    private void performTrackerAction(int style) {
        Tracker tracker = new Tracker(this.dialogShell.getDisplay(), style);
        tracker.setStippled(true);
        Rectangle[] r = new Rectangle[]{this.dialogShell.getBounds()};
        tracker.setRectangles(r);
        if (tracker.open()) {
            this.dialogShell.setBounds(tracker.getRectangles()[0]);
        }
    }

    private void createContents() {
    }

    public void setLastSelection(ISelection lastSelection) {
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
    }

    public boolean isOpen() {
        return this.dialogShell != null;
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    Point size = element.computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++n2;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++n2;
                }
            }
        }
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super("move", 1);
        }

        public void run() {
            ActiveSearchQuickView.this.performTrackerAction(0);
            ActiveSearchQuickView.this.isDeactivateListenerActive = true;
        }
    }

    protected static class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer selectedViewer, Object parentElement, Object element) {
            TreeViewer treeViewer = (TreeViewer)selectedViewer;
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer treeViewer, Object element) {
            return false;
        }
    }

    private class RememberBoundsAction
    extends Action {
        RememberBoundsAction() {
            super("remember-bounds", 2);
            this.setChecked(!ActiveSearchQuickView.this.getDialogSettings().getBoolean(ActiveSearchQuickView.STORE_DISABLE_RESTORE_LOCATION));
        }

        public void run() {
            IDialogSettings settings = ActiveSearchQuickView.this.getDialogSettings();
            boolean newValue = !this.isChecked();
            settings.put(ActiveSearchQuickView.STORE_DISABLE_RESTORE_LOCATION, newValue);
            settings.put(ActiveSearchQuickView.STORE_DISABLE_RESTORE_SIZE, newValue);
            ActiveSearchQuickView.this.isDeactivateListenerActive = true;
        }
    }

    private class ResizeAction
    extends Action {
        ResizeAction() {
            super("resize", 1);
        }

        public void run() {
            ActiveSearchQuickView.this.performTrackerAction(16);
            ActiveSearchQuickView.this.isDeactivateListenerActive = true;
        }
    }
}

