/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ParameterizedBlock;

public abstract class AbstractConfluenceDelimitedBlock
extends ParameterizedBlock {
    private final Pattern startPattern;
    private final Pattern endPattern;
    protected int blockLineCount = 0;
    private Matcher matcher;

    public AbstractConfluenceDelimitedBlock(String blockName) {
        this.startPattern = Pattern.compile("\\{" + blockName + "(?::([^\\}]*))?\\}(.*)");
        this.endPattern = Pattern.compile("(\\{" + blockName + "\\})(.*)");
    }

    public int processLineContent(String line, int offset) {
        int end;
        if (this.blockLineCount == 0) {
            this.setOptions(this.matcher.group(1));
            offset = this.matcher.start(2);
            this.beginBlock();
        }
        int segmentEnd = end = line.length();
        boolean terminating = false;
        Matcher endMatcher = this.endPattern.matcher(line);
        if (offset < end) {
            if (this.blockLineCount == 0) {
                endMatcher.region(offset, end);
            }
            if (endMatcher.find()) {
                terminating = true;
                end = endMatcher.start(2);
                segmentEnd = endMatcher.start(1);
            }
        }
        if (end < line.length()) {
            this.state.setLineSegmentEndOffset(end);
        }
        ++this.blockLineCount;
        String content = line.substring(offset, segmentEnd);
        this.handleBlockContent(content);
        if (terminating) {
            this.setClosed(true);
        }
        return end == line.length() ? -1 : end;
    }

    protected abstract void handleBlockContent(String var1);

    protected abstract void beginBlock();

    protected abstract void endBlock();

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.endBlock();
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        this.resetState();
        this.matcher = this.startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    protected void resetState() {
        this.blockLineCount = 0;
    }
}

