/*******************************************************************************
 * Copyright (c) 2007, 2008 David Green and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     David Green - initial API and implementation
 *******************************************************************************/
package org.eclipse.mylyn.wikitext.core.parser.markup.phrase;

import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

/**
 * 
 * 
 * @author David Green
 */
public class HtmlEndTagPhraseModifier extends PatternBasedElement {

	private final boolean escaping;

	public HtmlEndTagPhraseModifier() {
		this(false);
	}

	public HtmlEndTagPhraseModifier(boolean escaping) {
		this.escaping = escaping;
	}

	@Override
	protected String getPattern(int groupOffset) {
		return "(</[a-zA-Z][a-zA-Z0-9_:-]*\\s*>)";
	}

	@Override
	protected PatternBasedElementProcessor newProcessor() {
		return new LiteralPhraseModifierProcessor(escaping);
	}

	@Override
	protected int getPatternGroupCount() {
		return 1;
	}

}
