/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.outline;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.HeadingAttributes;
import org.eclipse.mylyn.wikitext.core.parser.IdGenerator;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;

public class OutlineParser {
    private int labelMaxLength = 0;
    private MarkupLanguage markupLanguage;

    public OutlineParser(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public OutlineParser() {
    }

    public int getLabelMaxLength() {
        return this.labelMaxLength;
    }

    public void setLabelMaxLength(int labelMaxLength) {
        this.labelMaxLength = labelMaxLength;
    }

    public OutlineItem parse(String markup) {
        OutlineItem root = this.createRootItem();
        return this.parse(root, markup);
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public OutlineItem createRootItem() {
        return this.createOutlineItem(null, 0, "<root>", -1, 0, "<root>");
    }

    public OutlineItem parse(OutlineItem root, String markup) {
        if (markup == null || markup.length() == 0 || this.markupLanguage == null) {
            return root;
        }
        this.markupLanguage.setFilterGenerativeContents(true);
        this.markupLanguage.setBlocksOnly(true);
        try {
            OutlineBuilder outlineBuilder = (OutlineBuilder)this.createOutlineUpdater(root);
            MarkupParser markupParser = new MarkupParser();
            markupParser.setBuilder(outlineBuilder);
            markupParser.setMarkupLanaguage(this.markupLanguage);
            markupParser.parse(markup);
        }
        finally {
            this.markupLanguage.setFilterGenerativeContents(false);
            this.markupLanguage.setBlocksOnly(false);
        }
        return root;
    }

    protected OutlineItem createOutlineItem(OutlineItem current, int level, String id, int offset, int length, String label) {
        return new OutlineItem(current, level, id, offset, length, label);
    }

    public DocumentBuilder createOutlineUpdater(OutlineItem rootItem) {
        return new OutlineBuilder(rootItem, this.labelMaxLength);
    }

    protected class OutlineBuilder
    extends DocumentBuilder {
        private OutlineItem currentItem;
        private int level;
        private StringBuilder buf;
        private final IdGenerator idGenerator = new IdGenerator();
        private int offset;
        private int length;
        private final OutlineItem rootItem;
        private final int labelMaxLength;
        private Attributes attributes;

        public OutlineBuilder(OutlineItem root, int labelMaxLength) {
            this.currentItem = root;
            this.rootItem = root;
            this.labelMaxLength = labelMaxLength;
        }

        public void acronym(String text, String definition) {
        }

        public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        }

        public void beginDocument() {
            this.rootItem.clear();
            this.currentItem = this.rootItem;
        }

        public void beginHeading(int level, Attributes attributes) {
            this.level = level;
            this.attributes = attributes;
            this.buf = new StringBuilder();
            this.offset = this.getLocator().getDocumentOffset();
            this.length = this.getLocator().getLineLength();
        }

        public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        }

        public void characters(String text) {
            if (this.buf != null) {
                this.buf.append(text);
            }
        }

        public void charactersUnescaped(String literal) {
            if (this.buf != null) {
                this.buf.append(literal);
            }
        }

        public void endBlock() {
        }

        public void endDocument() {
        }

        public void endHeading() {
            HeadingAttributes headingAttributes;
            boolean includeInToc = true;
            if (this.attributes instanceof HeadingAttributes && (headingAttributes = (HeadingAttributes)this.attributes).isOmitFromTableOfContents()) {
                includeInToc = false;
            }
            if (includeInToc) {
                String label;
                String fullLabelText = label = this.buf.toString();
                if (label == null) {
                    label = "";
                } else if (this.labelMaxLength > 0 && label.length() > this.labelMaxLength) {
                    label = String.valueOf(label.substring(0, this.labelMaxLength)) + "...";
                }
                String kind = "h" + this.level;
                while (this.level <= this.currentItem.getLevel()) {
                    this.currentItem = this.currentItem.getParent();
                }
                this.currentItem = OutlineParser.this.createOutlineItem(this.currentItem, this.level, this.idGenerator.newId(kind, fullLabelText), this.offset, this.length, label);
                this.currentItem.setTooltip(fullLabelText);
                this.currentItem.setKind(kind);
            }
            this.buf = null;
            this.offset = 0;
            this.length = 0;
            this.attributes = null;
        }

        public void endSpan() {
        }

        public void entityReference(String entity) {
        }

        public void image(Attributes attributes, String url) {
        }

        public void imageLink(Attributes linkAttributes, Attributes ImageAttributes2, String href, String imageUrl) {
        }

        public void lineBreak() {
        }

        public void link(Attributes attributes, String hrefOrHashName, String text) {
            if (this.buf != null) {
                this.buf.append(text);
            }
        }
    }
}

