/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.DefaultSplittingStrategy;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.NoSplittingStrategy;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplitOutlineItem;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingHtmlDocumentBuilder;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingOutlineParser;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.SplittingStrategy;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupToHtmlTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    protected String htmlFilenameFormat = "$1.html";
    protected boolean overwrite = true;
    private final List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();
    protected File file;
    protected String title;
    protected boolean multipleOutputFiles = false;
    protected boolean formatOutput = false;
    protected boolean navigationImages = false;
    private boolean useInlineCssStyles = true;
    private boolean suppressBuiltInCssStyles = false;

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException("Please add one or more source filesets or specify @file");
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException("@file may not be specified if filesets are also specified");
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(String.format("File cannot be found: %s", this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(String.format("Not a file: %s", this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(String.format("Cannot read file: %s", this.file));
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (Stylesheet stylesheet : this.stylesheets) {
            if (stylesheet.url == null && stylesheet.file == null) {
                throw new BuildException("Must specify one of @file or @url on <stylesheet>");
            }
            if (stylesheet.url != null && stylesheet.file != null) {
                throw new BuildException("May only specify one of @file or @url on <stylesheet>");
            }
            if (stylesheet.file == null) continue;
            if (!stylesheet.file.exists()) {
                throw new BuildException("Stylesheet file does not exist: " + stylesheet.file);
            }
            if (!stylesheet.file.isFile()) {
                throw new BuildException("Referenced stylesheet is not a file: " + stylesheet.file);
            }
            if (stylesheet.file.canRead()) continue;
            throw new BuildException("Cannot read stylesheet: " + stylesheet.file);
        }
        HashSet<File> outputFolders = new HashSet<File>();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                this.testForOutputFolderConflict(outputFolders, inputFile);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot process file '%s': %s", inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            this.testForOutputFolderConflict(outputFolders, this.file);
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot process file '%s': %s", this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void testForOutputFolderConflict(Set<File> outputFolders, File inputFile) {
        if (this.multipleOutputFiles && !outputFolders.add(inputFile.getAbsoluteFile().getParentFile())) {
            this.log(String.format("multipleOutputFiles have already been created in folder '%s'", new Object[0]), 1);
        }
    }

    protected String processFile(MarkupLanguage markupLanguage, File baseDir, File source) throws BuildException {
        File htmlOutputFile;
        this.log(String.format("Processing file '%s'", source), 3);
        String markupContent = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(htmlOutputFile = this.computeHtmlFile(source, name)).exists() || this.overwrite || htmlOutputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            if (markupContent == null) {
                markupContent = this.readFully(source);
            }
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(htmlOutputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", htmlOutputFile, e.getMessage()), (Throwable)e);
            }
            try {
                HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer, this.formatOutput);
                for (Stylesheet stylesheet : this.stylesheets) {
                    if (stylesheet.url != null) {
                        builder.addCssStylesheet(stylesheet.url);
                        continue;
                    }
                    builder.addCssStylesheet(stylesheet.file);
                }
                builder.setTitle(this.title == null ? name : this.title);
                builder.setEmitDtd(true);
                builder.setUseInlineStyles(this.useInlineCssStyles);
                builder.setSuppressBuiltInStyles(this.suppressBuiltInCssStyles);
                SplittingStrategy splittingStrategy = this.multipleOutputFiles ? new DefaultSplittingStrategy() : new NoSplittingStrategy();
                SplittingOutlineParser outlineParser = new SplittingOutlineParser();
                outlineParser.setMarkupLanguage(markupLanguage.clone());
                outlineParser.setSplittingStrategy(splittingStrategy);
                SplitOutlineItem item = outlineParser.parse(markupContent);
                item.setSplitTarget(htmlOutputFile.getName());
                SplittingHtmlDocumentBuilder splittingBuilder = new SplittingHtmlDocumentBuilder();
                splittingBuilder.setRootBuilder(builder);
                splittingBuilder.setOutline(item);
                splittingBuilder.setRootFile(htmlOutputFile);
                splittingBuilder.setNavigationImages(this.navigationImages);
                MarkupParser parser = new MarkupParser();
                parser.setMarkupLanaguage(markupLanguage);
                parser.setBuilder(splittingBuilder);
                parser.parse(markupContent);
                this.processed(markupContent, item, baseDir, source);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot write to file '%s': %s", htmlOutputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", htmlOutputFile, e.getMessage()), (Throwable)e);
            }
        }
        return markupContent;
    }

    void processed(String markupContent, SplitOutlineItem item, File baseDir, File source) {
    }

    protected File computeHtmlFile(File source, String name) {
        return new File(source.getParentFile(), this.htmlFilenameFormat.replace("$1", name));
    }

    protected String readFully(File inputFile) {
        StringWriter w = new StringWriter();
        try {
            InputStreamReader r = new InputStreamReader(new BufferedInputStream(new FileInputStream(inputFile)));
            try {
                int i;
                while ((i = ((Reader)r).read()) != -1) {
                    w.write((char)i);
                }
            }
            finally {
                ((Reader)r).close();
            }
        }
        catch (IOException e) {
            throw new BuildException(String.format("Cannot read file '%s': %s", inputFile, e.getMessage()), (Throwable)e);
        }
        return w.toString();
    }

    public String getHtmlFilenameFormat() {
        return this.htmlFilenameFormat;
    }

    public void setHtmlFilenameFormat(String htmlFilenameFormat) {
        this.htmlFilenameFormat = htmlFilenameFormat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException();
        }
        this.stylesheets.add(stylesheet);
    }

    public boolean isMultipleOutputFiles() {
        return this.multipleOutputFiles;
    }

    public void setMultipleOutputFiles(boolean multipleOutputFiles) {
        this.multipleOutputFiles = multipleOutputFiles;
    }

    public boolean isFormatOutput() {
        return this.formatOutput;
    }

    public void setFormatOutput(boolean formatOutput) {
        this.formatOutput = formatOutput;
    }

    public boolean isNavigationImages() {
        return this.navigationImages;
    }

    public void setNavigationImages(boolean navigationImages) {
        this.navigationImages = navigationImages;
    }

    public boolean isUseInlineCssStyles() {
        return this.useInlineCssStyles;
    }

    public void setUseInlineCssStyles(boolean useInlineCssStyles) {
        this.useInlineCssStyles = useInlineCssStyles;
    }

    public boolean isSuppressBuiltInCssStyles() {
        return this.suppressBuiltInCssStyles;
    }

    public void setSuppressBuiltInCssStyles(boolean suppressBuiltInCssStyles) {
        this.suppressBuiltInCssStyles = suppressBuiltInCssStyles;
    }

    public static class Stylesheet {
        private File file;
        private String url;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

