/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupValidator {
    private static final Comparator<ValidationProblem> PROBLEM_COMPARATOR = new Comparator<ValidationProblem>(){

        @Override
        public int compare(ValidationProblem o1, ValidationProblem o2) {
            int length2;
            int offset2;
            if (o1 == o2) {
                return 0;
            }
            int offset1 = o1.getOffset();
            if (offset1 < (offset2 = o2.getOffset())) {
                return -1;
            }
            if (offset2 < offset1) {
                return 1;
            }
            int length1 = o1.getLength();
            if (length1 > (length2 = o2.getLength())) {
                return -1;
            }
            if (length2 > length1) {
                return 1;
            }
            int i = o1.getMessage().compareTo(o2.getMessage());
            if (i == 0) {
                i = o1.getMarkerId().compareTo(o2.getMarkerId());
            }
            return i;
        }
    };
    private final List<ValidationRule> rules = new ArrayList<ValidationRule>();

    public List<ValidationProblem> validate(IProgressMonitor monitor, String markup) {
        return this.validate(monitor, markup, 0, markup.length());
    }

    public List<ValidationProblem> validate(IProgressMonitor monitor, String markup, int offset, int length) {
        int totalWork = length == 0 ? 1 : length * this.rules.size();
        monitor.beginTask("Markup Validation", totalWork);
        try {
            if (length == 0 || this.rules.isEmpty()) {
                List<ValidationProblem> list = Collections.emptyList();
                return list;
            }
            int end = offset + length;
            if (end > markup.length()) {
                end = markup.length();
            }
            ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
            block4: for (ValidationRule rule : this.rules) {
                int o = offset;
                while (o < end) {
                    ValidationProblem problem = rule.findProblem(markup, o, length - (o - offset));
                    if (problem == null) continue block4;
                    problems.add(problem);
                    int newO = problem.getOffset() + problem.getLength();
                    if (newO <= o) continue block4;
                    monitor.worked(newO - o);
                    o = newO;
                }
            }
            if (!problems.isEmpty()) {
                Collections.sort(problems, PROBLEM_COMPARATOR);
            }
            ArrayList<ValidationProblem> arrayList = problems;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public List<ValidationRule> getRules() {
        return this.rules;
    }
}

