/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;

public class TextileContentState
extends ContentState {
    private static final Pattern NAMED_LINK_PATTERN = Pattern.compile("\\[(\\S+)\\]([a-zA-Z]{3,5}:\\S+)", 8);
    private final Map<String, String> nameToUrl = new HashMap<String, String>();

    protected void setMarkupContent(String markupContent) {
        super.setMarkupContent(markupContent);
        this.preprocessContent(markupContent);
    }

    private void preprocessContent(String markupContent) {
        Matcher matcher = NAMED_LINK_PATTERN.matcher(markupContent);
        while (matcher.find()) {
            String name = matcher.group(1);
            String href = matcher.group(2);
            this.nameToUrl.put(name, href);
        }
    }

    public String getNamedLinkUrl(String name) {
        return this.nameToUrl.get(name);
    }
}

