/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.phrase;

import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.internal.wikitext.textile.core.TextileContentState;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.core.parser.util.Matcher;

public class ImageTextilePhraseModifier
extends PatternBasedElement {
    protected static final int ALIGNMENT_GROUP = 5;
    protected static final int CONTENT_GROUP = 6;
    protected static final int ATTRIBUTES_OFFSET = 1;

    protected String getPattern(int groupOffset) {
        String quotedDelimiter = Pattern.quote("!");
        return String.valueOf(quotedDelimiter) + "(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}" + "(<|>|=)?(\\S(?:.*?\\S)?)(\\([^\\)]+\\))?" + quotedDelimiter + "(:([^\\s]*[^\\s!.)(,]))?";
    }

    protected int getPatternGroupCount() {
        return 9;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ImagePhraseModifierProcessor();
    }

    private static class ImagePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private ImagePhraseModifierProcessor() {
        }

        public void emit() {
            String namedLinkUrl;
            String alignment = this.group(5);
            String imageUrl = this.group(6);
            String altAndTitle = this.group(7);
            String href = this.group(9);
            String string = namedLinkUrl = href == null ? null : ((TextileContentState)this.getState()).getNamedLinkUrl(href);
            if (namedLinkUrl != null) {
                href = namedLinkUrl;
            }
            ImageAttributes attributes = new ImageAttributes();
            attributes.setTitle(altAndTitle);
            attributes.setAlt(altAndTitle);
            if (alignment != null) {
                if ("<".equals(alignment)) {
                    attributes.setAlign(ImageAttributes.Align.Left);
                } else if (">".equals(alignment)) {
                    attributes.setAlign(ImageAttributes.Align.Right);
                } else if ("=".equals(alignment)) {
                    attributes.setAlign(ImageAttributes.Align.Center);
                }
            }
            Textile.configureAttributes((Matcher)this, (Attributes)attributes, 1, false);
            if (href != null) {
                this.builder.imageLink((Attributes)attributes, href, imageUrl);
            } else {
                this.builder.image((Attributes)attributes, imageUrl);
            }
        }
    }
}

