/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Segment;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends Segment<Segment<?>> {
    private final DocumentBuilder.BlockType type;
    private final int headingLevel;
    private boolean spansComputed = false;

    public Block(DocumentBuilder.BlockType type, int offset, int length) {
        super(offset, length);
        this.type = type;
        this.headingLevel = 0;
    }

    public Block(int headingLevel, int offset, int length) {
        super(offset, length);
        if (headingLevel <= 0) {
            throw new IllegalArgumentException();
        }
        this.headingLevel = headingLevel;
        this.type = null;
    }

    public Block(DocumentBuilder.BlockType type, Attributes attributes, int offset, int length) {
        super(attributes, offset, length);
        this.type = type;
        this.headingLevel = 0;
    }

    public Block(int headingLevel, Attributes attributes, int offset, int length) {
        super(attributes, offset, length);
        this.headingLevel = headingLevel;
        this.type = null;
    }

    public Block getParent() {
        return (Block)super.getParent();
    }

    public DocumentBuilder.BlockType getType() {
        return this.type;
    }

    public int getHeadingLevel() {
        return this.headingLevel;
    }

    public boolean isSpansComputed() {
        return this.spansComputed;
    }

    public void setSpansComputed(boolean spansComputed) {
        this.spansComputed = spansComputed;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        String elementName = this.type != null ? this.type.name() : "h" + this.headingLevel;
        buf.append(elementName);
        buf.append(" offset=\"");
        buf.append(this.getOffset());
        buf.append("\" length=\"");
        buf.append(this.getLength());
        buf.append('\"');
        if (this.getChildren().isEmpty()) {
            buf.append("/>\n");
        } else {
            buf.append(">\n");
            StringBuilder buf2 = new StringBuilder();
            buf2.append("\t");
            for (Segment child : this.getChildren().asList()) {
                buf2.append(child);
            }
            String children = buf2.toString();
            children = (children = children.replace("\n", "\n\t")).endsWith("\t") ? children.substring(0, children.length() - 1) : String.valueOf(children) + "\n";
            buf.append(children);
            buf.append("</");
            buf.append(elementName);
            buf.append(">\n");
        }
        return buf.toString();
    }
}

