/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.FontState;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class CssStyleManager {
    private static final int MIN_FONT_SIZE = 9;
    private static final int MAX_FONT_SIZE = 50;
    private static final Map<String, Integer> colorToRgb = new HashMap<String, Integer>();
    static final Pattern cssRulePattern;
    static final Pattern rgbPattern;
    private final Font defaultFont;

    static {
        colorToRgb.put("AliceBlue".toLowerCase(), 0xF0F8FF);
        colorToRgb.put("AntiqueWhite".toLowerCase(), 16444375);
        colorToRgb.put("Aqua".toLowerCase(), 65535);
        colorToRgb.put("Aquamarine".toLowerCase(), 8388564);
        colorToRgb.put("Azure".toLowerCase(), 0xF0FFFF);
        colorToRgb.put("Beige".toLowerCase(), 16119260);
        colorToRgb.put("Bisque".toLowerCase(), 16770244);
        colorToRgb.put("Black".toLowerCase(), 0);
        colorToRgb.put("BlanchedAlmond".toLowerCase(), 16772045);
        colorToRgb.put("Blue".toLowerCase(), 255);
        colorToRgb.put("BlueViolet".toLowerCase(), 9055202);
        colorToRgb.put("Brown".toLowerCase(), 0xA52A2A);
        colorToRgb.put("BurlyWood".toLowerCase(), 14596231);
        colorToRgb.put("CadetBlue".toLowerCase(), 6266528);
        colorToRgb.put("Chartreuse".toLowerCase(), 0x7FFF00);
        colorToRgb.put("Chocolate".toLowerCase(), 13789470);
        colorToRgb.put("Coral".toLowerCase(), 16744272);
        colorToRgb.put("CornflowerBlue".toLowerCase(), 6591981);
        colorToRgb.put("Cornsilk".toLowerCase(), 16775388);
        colorToRgb.put("Crimson".toLowerCase(), 14423100);
        colorToRgb.put("Cyan".toLowerCase(), 65535);
        colorToRgb.put("DarkBlue".toLowerCase(), 139);
        colorToRgb.put("DarkCyan".toLowerCase(), 35723);
        colorToRgb.put("DarkGoldenRod".toLowerCase(), 12092939);
        colorToRgb.put("DarkGray".toLowerCase(), 0xA9A9A9);
        colorToRgb.put("DarkGrey".toLowerCase(), 0xA9A9A9);
        colorToRgb.put("DarkGreen".toLowerCase(), 25600);
        colorToRgb.put("DarkKhaki".toLowerCase(), 12433259);
        colorToRgb.put("DarkMagenta".toLowerCase(), 0x8B008B);
        colorToRgb.put("DarkOliveGreen".toLowerCase(), 5597999);
        colorToRgb.put("Darkorange".toLowerCase(), 16747520);
        colorToRgb.put("DarkOrchid".toLowerCase(), 10040012);
        colorToRgb.put("DarkRed".toLowerCase(), 0x8B0000);
        colorToRgb.put("DarkSalmon".toLowerCase(), 15308410);
        colorToRgb.put("DarkSeaGreen".toLowerCase(), 9419919);
        colorToRgb.put("DarkSlateBlue".toLowerCase(), 4734347);
        colorToRgb.put("DarkSlateGray".toLowerCase(), 0x2F4F4F);
        colorToRgb.put("DarkSlateGrey".toLowerCase(), 0x2F4F4F);
        colorToRgb.put("DarkTurquoise".toLowerCase(), 52945);
        colorToRgb.put("DarkViolet".toLowerCase(), 9699539);
        colorToRgb.put("DeepPink".toLowerCase(), 16716947);
        colorToRgb.put("DeepSkyBlue".toLowerCase(), 49151);
        colorToRgb.put("DimGray".toLowerCase(), 0x696969);
        colorToRgb.put("DimGrey".toLowerCase(), 0x696969);
        colorToRgb.put("DodgerBlue".toLowerCase(), 2003199);
        colorToRgb.put("FireBrick".toLowerCase(), 0xB22222);
        colorToRgb.put("FloralWhite".toLowerCase(), 0xFFFAF0);
        colorToRgb.put("ForestGreen".toLowerCase(), 0x228B22);
        colorToRgb.put("Fuchsia".toLowerCase(), 0xFF00FF);
        colorToRgb.put("Gainsboro".toLowerCase(), 0xDCDCDC);
        colorToRgb.put("GhostWhite".toLowerCase(), 0xF8F8FF);
        colorToRgb.put("Gold".toLowerCase(), 16766720);
        colorToRgb.put("GoldenRod".toLowerCase(), 14329120);
        colorToRgb.put("Gray".toLowerCase(), 0x808080);
        colorToRgb.put("Grey".toLowerCase(), 0x808080);
        colorToRgb.put("Green".toLowerCase(), 32768);
        colorToRgb.put("GreenYellow".toLowerCase(), 11403055);
        colorToRgb.put("HoneyDew".toLowerCase(), 0xF0FFF0);
        colorToRgb.put("HotPink".toLowerCase(), 16738740);
        colorToRgb.put("IndianRed".toLowerCase(), 0xCD5C5C);
        colorToRgb.put("Indigo".toLowerCase(), 4915330);
        colorToRgb.put("Ivory".toLowerCase(), 0xFFFFF0);
        colorToRgb.put("Khaki".toLowerCase(), 15787660);
        colorToRgb.put("Lavender".toLowerCase(), 15132410);
        colorToRgb.put("LavenderBlush".toLowerCase(), 0xFFF0F5);
        colorToRgb.put("LawnGreen".toLowerCase(), 8190976);
        colorToRgb.put("LemonChiffon".toLowerCase(), 16775885);
        colorToRgb.put("LightBlue".toLowerCase(), 11393254);
        colorToRgb.put("LightCoral".toLowerCase(), 0xF08080);
        colorToRgb.put("LightCyan".toLowerCase(), 0xE0FFFF);
        colorToRgb.put("LightGoldenRodYellow".toLowerCase(), 16448210);
        colorToRgb.put("LightGray".toLowerCase(), 0xD3D3D3);
        colorToRgb.put("LightGrey".toLowerCase(), 0xD3D3D3);
        colorToRgb.put("LightGreen".toLowerCase(), 0x90EE90);
        colorToRgb.put("LightPink".toLowerCase(), 16758465);
        colorToRgb.put("LightSalmon".toLowerCase(), 16752762);
        colorToRgb.put("LightSeaGreen".toLowerCase(), 2142890);
        colorToRgb.put("LightSkyBlue".toLowerCase(), 8900346);
        colorToRgb.put("LightSlateGray".toLowerCase(), 0x778899);
        colorToRgb.put("LightSlateGrey".toLowerCase(), 0x778899);
        colorToRgb.put("LightSteelBlue".toLowerCase(), 11584734);
        colorToRgb.put("LightYellow".toLowerCase(), 0xFFFFE0);
        colorToRgb.put("Lime".toLowerCase(), 65280);
        colorToRgb.put("LimeGreen".toLowerCase(), 3329330);
        colorToRgb.put("Linen".toLowerCase(), 16445670);
        colorToRgb.put("Magenta".toLowerCase(), 0xFF00FF);
        colorToRgb.put("Maroon".toLowerCase(), 0x800000);
        colorToRgb.put("MediumAquaMarine".toLowerCase(), 6737322);
        colorToRgb.put("MediumBlue".toLowerCase(), 205);
        colorToRgb.put("MediumOrchid".toLowerCase(), 12211667);
        colorToRgb.put("MediumPurple".toLowerCase(), 9662680);
        colorToRgb.put("MediumSeaGreen".toLowerCase(), 3978097);
        colorToRgb.put("MediumSlateBlue".toLowerCase(), 8087790);
        colorToRgb.put("MediumSpringGreen".toLowerCase(), 64154);
        colorToRgb.put("MediumTurquoise".toLowerCase(), 4772300);
        colorToRgb.put("MediumVioletRed".toLowerCase(), 13047173);
        colorToRgb.put("MidnightBlue".toLowerCase(), 1644912);
        colorToRgb.put("MintCream".toLowerCase(), 0xF5FFFA);
        colorToRgb.put("MistyRose".toLowerCase(), 16770273);
        colorToRgb.put("Moccasin".toLowerCase(), 16770229);
        colorToRgb.put("NavajoWhite".toLowerCase(), 16768685);
        colorToRgb.put("Navy".toLowerCase(), 128);
        colorToRgb.put("OldLace".toLowerCase(), 16643558);
        colorToRgb.put("Olive".toLowerCase(), 0x808000);
        colorToRgb.put("OliveDrab".toLowerCase(), 7048739);
        colorToRgb.put("Orange".toLowerCase(), 16753920);
        colorToRgb.put("OrangeRed".toLowerCase(), 16729344);
        colorToRgb.put("Orchid".toLowerCase(), 14315734);
        colorToRgb.put("PaleGoldenRod".toLowerCase(), 0xEEE8AA);
        colorToRgb.put("PaleGreen".toLowerCase(), 10025880);
        colorToRgb.put("PaleTurquoise".toLowerCase(), 0xAFEEEE);
        colorToRgb.put("PaleVioletRed".toLowerCase(), 14184595);
        colorToRgb.put("PapayaWhip".toLowerCase(), 16773077);
        colorToRgb.put("PeachPuff".toLowerCase(), 16767673);
        colorToRgb.put("Peru".toLowerCase(), 13468991);
        colorToRgb.put("Pink".toLowerCase(), 16761035);
        colorToRgb.put("Plum".toLowerCase(), 0xDDA0DD);
        colorToRgb.put("PowderBlue".toLowerCase(), 11591910);
        colorToRgb.put("Purple".toLowerCase(), 0x800080);
        colorToRgb.put("Red".toLowerCase(), 0xFF0000);
        colorToRgb.put("RosyBrown".toLowerCase(), 12357519);
        colorToRgb.put("RoyalBlue".toLowerCase(), 4286945);
        colorToRgb.put("SaddleBrown".toLowerCase(), 9127187);
        colorToRgb.put("Salmon".toLowerCase(), 16416882);
        colorToRgb.put("SandyBrown".toLowerCase(), 16032864);
        colorToRgb.put("SeaGreen".toLowerCase(), 3050327);
        colorToRgb.put("SeaShell".toLowerCase(), 0xFFF5EE);
        colorToRgb.put("Sienna".toLowerCase(), 10506797);
        colorToRgb.put("Silver".toLowerCase(), 0xC0C0C0);
        colorToRgb.put("SkyBlue".toLowerCase(), 8900331);
        colorToRgb.put("SlateBlue".toLowerCase(), 6970061);
        colorToRgb.put("SlateGray".toLowerCase(), 7372944);
        colorToRgb.put("SlateGrey".toLowerCase(), 7372944);
        colorToRgb.put("Snow".toLowerCase(), 0xFFFAFA);
        colorToRgb.put("SpringGreen".toLowerCase(), 65407);
        colorToRgb.put("SteelBlue".toLowerCase(), 4620980);
        colorToRgb.put("Tan".toLowerCase(), 13808780);
        colorToRgb.put("Teal".toLowerCase(), 32896);
        colorToRgb.put("Thistle".toLowerCase(), 14204888);
        colorToRgb.put("Tomato".toLowerCase(), 16737095);
        colorToRgb.put("Turquoise".toLowerCase(), 4251856);
        colorToRgb.put("Violet".toLowerCase(), 0xEE82EE);
        colorToRgb.put("Wheat".toLowerCase(), 16113331);
        colorToRgb.put("White".toLowerCase(), 0xFFFFFF);
        colorToRgb.put("WhiteSmoke".toLowerCase(), 0xF5F5F5);
        colorToRgb.put("Yellow".toLowerCase(), 0xFFFF00);
        colorToRgb.put("YellowGreen".toLowerCase(), 10145074);
        cssRulePattern = Pattern.compile("(?:^|\\s?)([\\w-]+)\\s*:\\s*([^;]+)(;|$)", 40);
        rgbPattern = Pattern.compile("rgb\\((\\d+),(\\d+),(\\d+)\\)");
    }

    public CssStyleManager(Font defaultFont) {
        if (defaultFont == null) {
            throw new IllegalArgumentException();
        }
        this.defaultFont = defaultFont;
    }

    public CssStyleManager() {
        this.defaultFont = null;
    }

    public StyleRange createStyleRange(FontState fontState, int offset, int length) {
        StyleRange styleRange = new StyleRange(offset, length, this.getColorFromRgb(fontState.foreground), this.getColorFromRgb(fontState.background));
        if (fontState.isBold()) {
            styleRange.fontStyle |= 1;
        }
        if (fontState.isUnderline()) {
            styleRange.underline = true;
        }
        if (fontState.isStrikethrough()) {
            styleRange.strikeout = true;
        }
        if (fontState.isItalic()) {
            styleRange.fontStyle |= 2;
        }
        if (fontState.isSubscript()) {
            styleRange.rise = -4;
        } else if (fontState.isSuperscript()) {
            styleRange.rise = 4;
        }
        if (fontState.isFixedWidth()) {
            String symbolicName = String.valueOf(this.getClass().getSimpleName()) + "-monospace-" + fontState.size;
            Font monospaceFont = JFaceResources.getFontRegistry().get(symbolicName);
            if (monospaceFont == null) {
                Font defaultFont = JFaceResources.getFontRegistry().defaultFont();
                FontData[] fontData = defaultFont.getDevice().getFontList("Courier New", true);
                if (fontData == null || fontData.length == 0) {
                    fontData = defaultFont.getDevice().getFontList("Courier", true);
                }
                if (fontData != null && fontData.length > 0) {
                    FontData[] fontDataArray = fontData;
                    int n = fontData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FontData fd = fontDataArray[n2];
                        fd.setHeight((int)fontState.size);
                        ++n2;
                    }
                    JFaceResources.getFontRegistry().put(symbolicName, fontData);
                    monospaceFont = JFaceResources.getFontRegistry().get(symbolicName);
                }
            }
            if (monospaceFont != null) {
                styleRange.font = monospaceFont;
            }
        } else {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            String defaultName = this.defaultFont.getFontData()[0].getName();
            if (fontState.size != defaultSize) {
                Font font;
                String symbolicName = String.valueOf(defaultName) + "-default-" + fontState.size;
                if (fontState.isBold()) {
                    symbolicName = String.valueOf(symbolicName) + "-bold";
                }
                if (fontState.isItalic()) {
                    symbolicName = String.valueOf(symbolicName) + "-italic";
                }
                Font font2 = font = JFaceResources.getFontRegistry().hasValueFor(symbolicName) ? JFaceResources.getFontRegistry().get(symbolicName) : null;
                if (font == null) {
                    FontData[] fontData = new FontData[this.defaultFont.getFontData().length];
                    int index = -1;
                    FontData[] fontDataArray = this.defaultFont.getFontData();
                    int n = fontDataArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FontData fd = fontDataArray[n3];
                        FontData newData = new FontData(fd.getName(), fd.getHeight(), fd.getStyle());
                        newData.setHeight((int)fontState.size);
                        int style = newData.getStyle();
                        if (fontState.isBold()) {
                            style |= 1;
                        }
                        if (fontState.isItalic()) {
                            style |= 2;
                        }
                        newData.setStyle(style);
                        fontData[++index] = newData;
                        ++n3;
                    }
                    JFaceResources.getFontRegistry().put(symbolicName, fontData);
                    font = JFaceResources.getFontRegistry().get(symbolicName);
                }
                if (font != null) {
                    styleRange.font = font;
                }
            }
        }
        return styleRange;
    }

    public Color getColorFromRgb(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String symbolicName = String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
        Color color = JFaceResources.getColorRegistry().get(symbolicName);
        if (color == null) {
            JFaceResources.getColorRegistry().put(symbolicName, rgb);
            color = JFaceResources.getColorRegistry().get(symbolicName);
        }
        return color;
    }

    public void processCssStyles(FontState fontState, FontState parentFontState, String styleValue) {
        if (styleValue == null) {
            return;
        }
        Matcher matcher = cssRulePattern.matcher(styleValue);
        while (matcher.find()) {
            String part;
            int n;
            int n2;
            String[] stringArray;
            String[] parts;
            Integer rgb;
            String ruleName = matcher.group(1);
            String ruleValue = matcher.group(2);
            ruleValue = ruleValue.trim();
            if ("color".equals(ruleName)) {
                rgb = this.cssColorRgb(ruleValue);
                if (rgb == null) continue;
                fontState.foreground = this.toRGB(rgb);
                continue;
            }
            if ("background-color".equals(ruleName)) {
                rgb = this.cssColorRgb(ruleValue);
                if (rgb == null) continue;
                fontState.background = this.toRGB(rgb);
                continue;
            }
            if ("font-style".equals(ruleName)) {
                stringArray = parts = ruleValue.split("((\\s+)|(\\s*,\\s*))");
                n2 = parts.length;
                n = 0;
                while (n < n2) {
                    part = stringArray[n];
                    if ("italic".equals(part)) {
                        fontState.setItalic(true);
                    } else if ("bold".equals(part)) {
                        fontState.setBold(true);
                    } else if ("normal".equals(part)) {
                        fontState.setItalic(false);
                    }
                    ++n;
                }
                continue;
            }
            if ("font-weight".equals(ruleName)) {
                if ("bold".equals(ruleValue) || "bolder".equals(ruleValue)) {
                    fontState.setBold(true);
                    continue;
                }
                if (!"normal".equals(ruleValue) && !"lighter".equals(ruleValue)) continue;
                fontState.setBold(false);
                continue;
            }
            if ("font-size".equals(ruleName)) {
                this.updateFontSize(fontState, parentFontState, ruleValue);
                continue;
            }
            if ("font-family".equals(ruleName)) {
                stringArray = parts = ruleValue.split("((\\s+)|(\\s*,\\s*))");
                n2 = parts.length;
                n = 0;
                while (n < n2) {
                    part = stringArray[n];
                    if ("monospace".equals(part) || "courier".equalsIgnoreCase(part) || "courier new".equalsIgnoreCase(part)) {
                        fontState.setFixedWidth(true);
                    } else {
                        fontState.setFixedWidth(false);
                    }
                    ++n;
                }
                continue;
            }
            if ("text-decoration".equals(ruleName)) {
                stringArray = parts = ruleValue.split("((\\s+)|(\\s*,\\s*))");
                n2 = parts.length;
                n = 0;
                while (n < n2) {
                    part = stringArray[n];
                    if ("none".equals(part)) {
                        fontState.setStrikethrough(false);
                        fontState.setUnderline(false);
                    } else if ("line-through".equals(part)) {
                        fontState.setStrikethrough(true);
                    } else if ("underline".equals(part)) {
                        fontState.setUnderline(true);
                    }
                    ++n;
                }
                continue;
            }
            if (!"vertical-align".equals(ruleName)) continue;
            if ("super".equals(ruleValue)) {
                fontState.setSuperscript(true);
                continue;
            }
            if (!"sub".equals(ruleValue)) continue;
            fontState.setSubscript(true);
        }
    }

    private RGB toRGB(int rgb) {
        return new RGB((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
    }

    private void updateFontSize(FontState fontState, FontState parentFontState, String cssFontSizeValue) {
        if (cssFontSizeValue.endsWith("%")) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            try {
                float percentage = Float.parseFloat(cssFontSizeValue.substring(0, cssFontSizeValue.length() - 1)) / 100.0f;
                if (percentage > 0.0f) {
                    fontState.size = percentage * defaultSize;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else if ("xx-small".equals(cssFontSizeValue)) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            fontState.size = defaultSize - defaultSize * 0.6f;
        } else if ("x-small".equals(cssFontSizeValue)) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            fontState.size = defaultSize - defaultSize * 0.4f;
        } else if ("small".equals(cssFontSizeValue)) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            fontState.size = defaultSize - defaultSize * 0.2f;
        } else if ("medium".equals(cssFontSizeValue)) {
            float defaultSize;
            fontState.size = defaultSize = (float)this.defaultFont.getFontData()[0].getHeight();
        } else if ("large".equals(cssFontSizeValue)) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            fontState.size = defaultSize + defaultSize * 0.2f;
        } else if ("x-large".equals(cssFontSizeValue)) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            fontState.size = defaultSize + defaultSize * 0.4f;
        } else if ("xx-large".equals(cssFontSizeValue)) {
            float defaultSize = this.defaultFont.getFontData()[0].getHeight();
            fontState.size = defaultSize + defaultSize * 0.6f;
        } else if ("larger".equals(cssFontSizeValue)) {
            fontState.size = parentFontState.size * 1.2f;
        } else if ("smaller".equals(cssFontSizeValue)) {
            fontState.size = parentFontState.size - parentFontState.size * 0.2f;
        } else {
            try {
                float exactSize;
                if (cssFontSizeValue.endsWith("pt") || cssFontSizeValue.endsWith("px")) {
                    cssFontSizeValue = cssFontSizeValue.substring(0, cssFontSizeValue.length() - 2);
                }
                if ((exactSize = Float.parseFloat(cssFontSizeValue)) > 0.0f) {
                    fontState.size = exactSize;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        fontState.size = Math.min(50.0f, Math.max(9.0f, fontState.size));
    }

    public Integer cssColorRgb(String cssColor) {
        Integer rgb = colorToRgb.get(cssColor.toLowerCase());
        if (rgb == null) {
            try {
                if (cssColor.startsWith("#")) {
                    String rgbNumeric = cssColor.substring(1);
                    if (rgbNumeric.length() == 3) {
                        String firstDigit = rgbNumeric.substring(0, 1);
                        String secondDigit = rgbNumeric.substring(1, 2);
                        String thirdDigit = rgbNumeric.substring(2, 3);
                        rgbNumeric = String.valueOf(firstDigit) + firstDigit + secondDigit + secondDigit + thirdDigit + thirdDigit;
                    }
                    rgb = Integer.parseInt(rgbNumeric, 16);
                } else {
                    Matcher rgbMatcher = rgbPattern.matcher(cssColor);
                    if (rgbMatcher.matches()) {
                        String r = rgbMatcher.group(1);
                        String g = rgbMatcher.group(2);
                        String b = rgbMatcher.group(3);
                        String rgbNumeric = String.format("%02X%02X%02X", Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
                        rgb = Integer.parseInt(rgbNumeric, 16);
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return rgb;
    }

    public FontState createDefaultFontState() {
        FontState fontState = new FontState();
        fontState.size = this.defaultFont.getFontData()[0].getHeight();
        return fontState;
    }
}

